/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractStateMachineTableProcedure<TState>
extends StateMachineProcedure<MasterProcedureEnv, TState>
implements TableProcedureInterface {
    private final ProcedurePrepareLatch syncLatch;
    private User user;

    protected AbstractStateMachineTableProcedure() {
        this.syncLatch = null;
    }

    protected AbstractStateMachineTableProcedure(MasterProcedureEnv env) {
        this(env, null);
    }

    protected AbstractStateMachineTableProcedure(MasterProcedureEnv env, ProcedurePrepareLatch latch) {
        if (env != null) {
            this.user = env.getRequestUser();
            this.setOwner(this.user);
        }
        this.syncLatch = latch;
    }

    @Override
    public abstract TableName getTableName();

    @Override
    public abstract TableProcedureInterface.TableOperationType getTableOperationType();

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.waitInitialized(this)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        if (env.getProcedureScheduler().waitTableExclusiveLock(this, this.getTableName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeTableExclusiveLock(this, this.getTableName());
    }

    protected User getUser() {
        return this.user;
    }

    protected void setUser(User user) {
        this.user = user;
    }

    protected void releaseSyncLatch() {
        ProcedurePrepareLatch.releaseLatch(this.syncLatch, this);
    }

    protected void checkTableModifiable(MasterProcedureEnv env) throws IOException {
        if (!MetaTableAccessor.tableExists(env.getMasterServices().getConnection(), this.getTableName())) {
            throw new TableNotFoundException(this.getTableName());
        }
    }
}

