/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterDDLOperationHelper;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AddColumnFamilyProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.AddColumnFamilyState> {
    private static final Log LOG = LogFactory.getLog(AddColumnFamilyProcedure.class);
    private TableName tableName;
    private TableDescriptor unmodifiedTableDescriptor;
    private ColumnFamilyDescriptor cfDescriptor;
    private List<HRegionInfo> regionInfoList;
    private Boolean traceEnabled;

    public AddColumnFamilyProcedure() {
        this.unmodifiedTableDescriptor = null;
        this.regionInfoList = null;
        this.traceEnabled = null;
    }

    public AddColumnFamilyProcedure(MasterProcedureEnv env, TableName tableName, ColumnFamilyDescriptor cfDescriptor) throws IOException {
        this(env, tableName, cfDescriptor, null);
    }

    public AddColumnFamilyProcedure(MasterProcedureEnv env, TableName tableName, ColumnFamilyDescriptor cfDescriptor, ProcedurePrepareLatch latch) {
        super(env, latch);
        this.tableName = tableName;
        this.cfDescriptor = cfDescriptor;
        this.unmodifiedTableDescriptor = null;
        this.regionInfoList = null;
        this.traceEnabled = null;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.AddColumnFamilyState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case ADD_COLUMN_FAMILY_PREPARE: {
                    this.prepareAdd(env);
                    this.setNextState(MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_PRE_OPERATION);
                    break;
                }
                case ADD_COLUMN_FAMILY_PRE_OPERATION: {
                    this.preAdd(env, state);
                    this.setNextState(MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case ADD_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    this.setNextState(MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_POST_OPERATION);
                    break;
                }
                case ADD_COLUMN_FAMILY_POST_OPERATION: {
                    this.postAdd(env, state);
                    this.setNextState(MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_REOPEN_ALL_REGIONS);
                    break;
                }
                case ADD_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                    if (env.getAssignmentManager().isTableEnabled(this.getTableName())) {
                        this.addChildProcedure(env.getAssignmentManager().createReopenProcedures(this.getRegionInfoList(env)));
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-add-columnfamily", e);
            }
            LOG.warn((Object)("Retriable error trying to add the column family " + this.getColumnFamilyName() + " to the table " + this.tableName + " (in state=" + state + ")"), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.AddColumnFamilyState state) throws IOException {
        if (state == MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_PREPARE || state == MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_PRE_OPERATION) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.AddColumnFamilyState state) {
        switch (state) {
            case ADD_COLUMN_FAMILY_PREPARE: 
            case ADD_COLUMN_FAMILY_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void completionCleanup(MasterProcedureEnv env) {
        this.releaseSyncLatch();
    }

    @Override
    protected MasterProcedureProtos.AddColumnFamilyState getState(int stateId) {
        return MasterProcedureProtos.AddColumnFamilyState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.AddColumnFamilyState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.AddColumnFamilyState getInitialState() {
        return MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.AddColumnFamilyStateData.Builder addCFMsg = MasterProcedureProtos.AddColumnFamilyStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setTableName(ProtobufUtil.toProtoTableName(this.tableName)).setColumnfamilySchema(ProtobufUtil.toColumnFamilySchema(this.cfDescriptor));
        if (this.unmodifiedTableDescriptor != null) {
            addCFMsg.setUnmodifiedTableSchema(ProtobufUtil.toTableSchema(this.unmodifiedTableDescriptor));
        }
        serializer.serialize(addCFMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.AddColumnFamilyStateData addCFMsg = serializer.deserialize(MasterProcedureProtos.AddColumnFamilyStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(addCFMsg.getUserInfo()));
        this.tableName = ProtobufUtil.toTableName(addCFMsg.getTableName());
        this.cfDescriptor = ProtobufUtil.toColumnFamilyDescriptor(addCFMsg.getColumnfamilySchema());
        if (addCFMsg.hasUnmodifiedTableSchema()) {
            this.unmodifiedTableDescriptor = ProtobufUtil.toTableDescriptor(addCFMsg.getUnmodifiedTableSchema());
        }
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.tableName);
        sb.append(", columnfamily=");
        if (this.cfDescriptor != null) {
            sb.append(this.getColumnFamilyName());
        } else {
            sb.append("Unknown");
        }
        sb.append(")");
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private void prepareAdd(MasterProcedureEnv env) throws IOException {
        this.checkTableModifiable(env);
        this.unmodifiedTableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (this.unmodifiedTableDescriptor == null) {
            throw new IOException("TableDescriptor missing for " + this.tableName);
        }
        if (this.unmodifiedTableDescriptor.hasColumnFamily(this.cfDescriptor.getName())) {
            throw new InvalidFamilyOperationException("Column family '" + this.getColumnFamilyName() + "' in table '" + this.tableName + "' already exists so cannot be added");
        }
    }

    private void preAdd(MasterProcedureEnv env, MasterProcedureProtos.AddColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        LOG.info((Object)("AddColumn. Table = " + this.tableName + " HCD = " + this.cfDescriptor.toString()));
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (htd.hasColumnFamily(this.cfDescriptor.getName())) {
            return;
        }
        env.getMasterServices().getTableDescriptors().add(TableDescriptorBuilder.newBuilder(htd).addColumnFamily(this.cfDescriptor).build());
    }

    private void restoreTableDescriptor(MasterProcedureEnv env) throws IOException {
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (htd.hasColumnFamily(this.cfDescriptor.getName())) {
            MasterDDLOperationHelper.deleteColumnFamilyFromFileSystem(env, this.tableName, this.getRegionInfoList(env), this.cfDescriptor.getName(), this.cfDescriptor.isMobEnabled());
            env.getMasterServices().getTableDescriptors().add(this.unmodifiedTableDescriptor);
        }
    }

    private void postAdd(MasterProcedureEnv env, MasterProcedureProtos.AddColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private String getColumnFamilyName() {
        return this.cfDescriptor.getNameAsString();
    }

    private void runCoprocessorAction(MasterProcedureEnv env, MasterProcedureProtos.AddColumnFamilyState state) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            switch (state) {
                case ADD_COLUMN_FAMILY_PRE_OPERATION: {
                    cpHost.preAddColumnFamilyAction(this.tableName, this.cfDescriptor, this.getUser());
                    break;
                }
                case ADD_COLUMN_FAMILY_POST_OPERATION: {
                    cpHost.postCompletedAddColumnFamilyAction(this.tableName, this.cfDescriptor, this.getUser());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
    }

    private List<HRegionInfo> getRegionInfoList(MasterProcedureEnv env) throws IOException {
        if (this.regionInfoList == null) {
            this.regionInfoList = env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName());
        }
        return this.regionInfoList;
    }
}

