/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterDDLOperationHelper;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DeleteColumnFamilyProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.DeleteColumnFamilyState> {
    private static final Log LOG = LogFactory.getLog(DeleteColumnFamilyProcedure.class);
    private TableDescriptor unmodifiedTableDescriptor;
    private TableName tableName;
    private byte[] familyName;
    private boolean hasMob;
    private List<HRegionInfo> regionInfoList;
    private Boolean traceEnabled;

    public DeleteColumnFamilyProcedure() {
        this.unmodifiedTableDescriptor = null;
        this.regionInfoList = null;
        this.traceEnabled = null;
    }

    public DeleteColumnFamilyProcedure(MasterProcedureEnv env, TableName tableName, byte[] familyName) {
        this(env, tableName, familyName, null);
    }

    public DeleteColumnFamilyProcedure(MasterProcedureEnv env, TableName tableName, byte[] familyName, ProcedurePrepareLatch latch) {
        super(env, latch);
        this.tableName = tableName;
        this.familyName = familyName;
        this.unmodifiedTableDescriptor = null;
        this.regionInfoList = null;
        this.traceEnabled = null;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.DeleteColumnFamilyState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case DELETE_COLUMN_FAMILY_PREPARE: {
                    this.prepareDelete(env);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_PRE_OPERATION);
                    break;
                }
                case DELETE_COLUMN_FAMILY_PRE_OPERATION: {
                    this.preDelete(env, state);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case DELETE_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_DELETE_FS_LAYOUT);
                    break;
                }
                case DELETE_COLUMN_FAMILY_DELETE_FS_LAYOUT: {
                    this.deleteFromFs(env);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_POST_OPERATION);
                    break;
                }
                case DELETE_COLUMN_FAMILY_POST_OPERATION: {
                    this.postDelete(env, state);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_REOPEN_ALL_REGIONS);
                    break;
                }
                case DELETE_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                    if (env.getAssignmentManager().isTableEnabled(this.getTableName())) {
                        this.addChildProcedure(env.getAssignmentManager().createReopenProcedures(this.getRegionInfoList(env)));
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-delete-columnfamily", e);
            }
            LOG.warn((Object)("Retriable error trying to delete the column family " + this.getColumnFamilyName() + " from table " + this.tableName + " (in state=" + state + ")"), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.DeleteColumnFamilyState state) throws IOException {
        if (state == MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_PREPARE || state == MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_PRE_OPERATION) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.DeleteColumnFamilyState state) {
        switch (state) {
            case DELETE_COLUMN_FAMILY_PREPARE: 
            case DELETE_COLUMN_FAMILY_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void completionCleanup(MasterProcedureEnv env) {
        this.releaseSyncLatch();
    }

    @Override
    protected MasterProcedureProtos.DeleteColumnFamilyState getState(int stateId) {
        return MasterProcedureProtos.DeleteColumnFamilyState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.DeleteColumnFamilyState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.DeleteColumnFamilyState getInitialState() {
        return MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.DeleteColumnFamilyStateData.Builder deleteCFMsg = MasterProcedureProtos.DeleteColumnFamilyStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setTableName(ProtobufUtil.toProtoTableName(this.tableName)).setColumnfamilyName(UnsafeByteOperations.unsafeWrap(this.familyName));
        if (this.unmodifiedTableDescriptor != null) {
            deleteCFMsg.setUnmodifiedTableSchema(ProtobufUtil.toTableSchema(this.unmodifiedTableDescriptor));
        }
        serializer.serialize(deleteCFMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.DeleteColumnFamilyStateData deleteCFMsg = serializer.deserialize(MasterProcedureProtos.DeleteColumnFamilyStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(deleteCFMsg.getUserInfo()));
        this.tableName = ProtobufUtil.toTableName(deleteCFMsg.getTableName());
        this.familyName = deleteCFMsg.getColumnfamilyName().toByteArray();
        if (deleteCFMsg.hasUnmodifiedTableSchema()) {
            this.unmodifiedTableDescriptor = ProtobufUtil.toTableDescriptor(deleteCFMsg.getUnmodifiedTableSchema());
        }
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.tableName);
        sb.append(", columnfamily=");
        if (this.familyName != null) {
            sb.append(this.getColumnFamilyName());
        } else {
            sb.append("Unknown");
        }
        sb.append(")");
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private void prepareDelete(MasterProcedureEnv env) throws IOException {
        this.checkTableModifiable(env);
        this.unmodifiedTableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (this.unmodifiedTableDescriptor == null) {
            throw new IOException("TableDescriptor missing for " + this.tableName);
        }
        if (!this.unmodifiedTableDescriptor.hasColumnFamily(this.familyName)) {
            throw new InvalidFamilyOperationException("Family '" + this.getColumnFamilyName() + "' does not exist, so it cannot be deleted");
        }
        if (this.unmodifiedTableDescriptor.getColumnFamilyCount() == 1) {
            throw new InvalidFamilyOperationException("Family '" + this.getColumnFamilyName() + "' is the only column family in the table, so it cannot be deleted");
        }
        this.hasMob = this.unmodifiedTableDescriptor.getColumnFamily(this.familyName).isMobEnabled();
    }

    private void preDelete(MasterProcedureEnv env, MasterProcedureProtos.DeleteColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        LOG.info((Object)("DeleteColumn. Table = " + this.tableName + " family = " + this.getColumnFamilyName()));
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (!htd.hasColumnFamily(this.familyName)) {
            return;
        }
        env.getMasterServices().getTableDescriptors().add(TableDescriptorBuilder.newBuilder(htd).removeColumnFamily(this.familyName).build());
    }

    private void restoreTableDescriptor(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getTableDescriptors().add(this.unmodifiedTableDescriptor);
    }

    private void deleteFromFs(MasterProcedureEnv env) throws IOException {
        MasterDDLOperationHelper.deleteColumnFamilyFromFileSystem(env, this.tableName, this.getRegionInfoList(env), this.familyName, this.hasMob);
    }

    private void postDelete(MasterProcedureEnv env, MasterProcedureProtos.DeleteColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private String getColumnFamilyName() {
        return Bytes.toString(this.familyName);
    }

    private void runCoprocessorAction(MasterProcedureEnv env, MasterProcedureProtos.DeleteColumnFamilyState state) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            switch (state) {
                case DELETE_COLUMN_FAMILY_PRE_OPERATION: {
                    cpHost.preDeleteColumnFamilyAction(this.tableName, this.familyName, this.getUser());
                    break;
                }
                case DELETE_COLUMN_FAMILY_POST_OPERATION: {
                    cpHost.postCompletedDeleteColumnFamilyAction(this.tableName, this.familyName, this.getUser());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
    }

    private List<HRegionInfo> getRegionInfoList(MasterProcedureEnv env) throws IOException {
        if (this.regionInfoList == null) {
            this.regionInfoList = env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName());
        }
        return this.regionInfoList;
    }
}

