/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class EnableTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.EnableTableState> {
    private static final Log LOG = LogFactory.getLog(EnableTableProcedure.class);
    private TableName tableName;
    private boolean skipTableStateCheck;
    private Boolean traceEnabled = null;

    public EnableTableProcedure() {
    }

    public EnableTableProcedure(MasterProcedureEnv env, TableName tableName, boolean skipTableStateCheck) {
        this(env, tableName, skipTableStateCheck, null);
    }

    public EnableTableProcedure(MasterProcedureEnv env, TableName tableName, boolean skipTableStateCheck, ProcedurePrepareLatch syncLatch) {
        super(env, syncLatch);
        this.tableName = tableName;
        this.skipTableStateCheck = skipTableStateCheck;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case ENABLE_TABLE_PREPARE: {
                    if (this.prepareEnable(env)) {
                        this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_PRE_OPERATION);
                        break;
                    }
                    assert (this.isFailed()) : "enable should have an exception here";
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case ENABLE_TABLE_PRE_OPERATION: {
                    this.preEnable(env, state);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_SET_ENABLING_TABLE_STATE);
                    break;
                }
                case ENABLE_TABLE_SET_ENABLING_TABLE_STATE: {
                    EnableTableProcedure.setTableStateToEnabling(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_MARK_REGIONS_ONLINE);
                    break;
                }
                case ENABLE_TABLE_MARK_REGIONS_ONLINE: {
                    this.addChildProcedure(env.getAssignmentManager().createAssignProcedures(this.tableName));
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_SET_ENABLED_TABLE_STATE);
                    break;
                }
                case ENABLE_TABLE_SET_ENABLED_TABLE_STATE: {
                    EnableTableProcedure.setTableStateToEnabled(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_POST_OPERATION);
                    break;
                }
                case ENABLE_TABLE_POST_OPERATION: {
                    this.postEnable(env, state);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-enable-table", e);
            }
            LOG.warn((Object)("Retriable error trying to enable table=" + this.tableName + " (in state=" + state + ")"), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException {
        switch (state) {
            case ENABLE_TABLE_PRE_OPERATION: {
                return;
            }
            case ENABLE_TABLE_PREPARE: {
                this.releaseSyncLatch();
                return;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.EnableTableState state) {
        switch (state) {
            case ENABLE_TABLE_PREPARE: 
            case ENABLE_TABLE_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected MasterProcedureProtos.EnableTableState getState(int stateId) {
        return MasterProcedureProtos.EnableTableState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.EnableTableState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.EnableTableState getInitialState() {
        return MasterProcedureProtos.EnableTableState.ENABLE_TABLE_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.EnableTableStateData.Builder enableTableMsg = MasterProcedureProtos.EnableTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setTableName(ProtobufUtil.toProtoTableName(this.tableName)).setSkipTableStateCheck(this.skipTableStateCheck);
        serializer.serialize(enableTableMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.EnableTableStateData enableTableMsg = serializer.deserialize(MasterProcedureProtos.EnableTableStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(enableTableMsg.getUserInfo()));
        this.tableName = ProtobufUtil.toTableName(enableTableMsg.getTableName());
        this.skipTableStateCheck = enableTableMsg.getSkipTableStateCheck();
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.ENABLE;
    }

    private boolean prepareEnable(MasterProcedureEnv env) throws IOException {
        TableStateManager tsm;
        TableState.State state;
        boolean canTableBeEnabled = true;
        if (!MetaTableAccessor.tableExists(env.getMasterServices().getConnection(), this.tableName)) {
            this.setFailure("master-enable-table", new TableNotFoundException(this.tableName));
            canTableBeEnabled = false;
        } else if (!this.skipTableStateCheck && !(state = (tsm = env.getMasterServices().getTableStateManager()).getTableState(this.tableName)).equals((Object)TableState.State.DISABLED)) {
            LOG.info((Object)("Table " + this.tableName + " isn't disabled;is " + state.name() + "; skipping enable"));
            this.setFailure("master-enable-table", new TableNotDisabledException(this.tableName + " state is " + state.name()));
            canTableBeEnabled = false;
        }
        this.releaseSyncLatch();
        return canTableBeEnabled;
    }

    private void preEnable(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    protected static void setTableStateToEnabling(MasterProcedureEnv env, TableName tableName) throws IOException {
        LOG.info((Object)("Attempting to enable the table " + tableName));
        env.getMasterServices().getTableStateManager().setTableState(tableName, TableState.State.ENABLING);
    }

    protected static void setTableStateToEnabled(MasterProcedureEnv env, TableName tableName) throws IOException {
        env.getMasterServices().getTableStateManager().setTableState(tableName, TableState.State.ENABLED);
        LOG.info((Object)("Table '" + tableName + "' was successfully enabled."));
    }

    private void postEnable(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private void runCoprocessorAction(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            switch (state) {
                case ENABLE_TABLE_PRE_OPERATION: {
                    cpHost.preEnableTableAction(this.getTableName(), this.getUser());
                    break;
                }
                case ENABLE_TABLE_POST_OPERATION: {
                    cpHost.postCompletedEnableTableAction(this.getTableName(), this.getUser());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
    }
}

