/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterProcedureEnv
implements ConfigurationObserver {
    private static final Log LOG = LogFactory.getLog(MasterProcedureEnv.class);
    private final RSProcedureDispatcher remoteDispatcher;
    private final MasterProcedureScheduler procSched;
    private final MasterServices master;

    public MasterProcedureEnv(MasterServices master) {
        this(master, new RSProcedureDispatcher(master));
    }

    public MasterProcedureEnv(MasterServices master, RSProcedureDispatcher remoteDispatcher) {
        this.master = master;
        this.procSched = new MasterProcedureScheduler(master.getConfiguration());
        this.remoteDispatcher = remoteDispatcher;
    }

    public User getRequestUser() {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            user = Superusers.getSystemUser();
        }
        return user;
    }

    public MasterServices getMasterServices() {
        return this.master;
    }

    public Configuration getMasterConfiguration() {
        return this.master.getConfiguration();
    }

    public AssignmentManager getAssignmentManager() {
        return this.master.getAssignmentManager();
    }

    public MasterCoprocessorHost getMasterCoprocessorHost() {
        return this.master.getMasterCoprocessorHost();
    }

    public MasterProcedureScheduler getProcedureScheduler() {
        return this.procSched;
    }

    public RSProcedureDispatcher getRemoteDispatcher() {
        return this.remoteDispatcher;
    }

    public boolean isRunning() {
        if (this.master == null || this.master.getMasterProcedureExecutor() == null) {
            return false;
        }
        return this.master.getMasterProcedureExecutor().isRunning();
    }

    public boolean isInitialized() {
        return this.master.isInitialized();
    }

    public boolean waitInitialized(Procedure proc) {
        return this.procSched.waitEvent(this.master.getInitializedEvent(), proc);
    }

    public boolean waitServerCrashProcessingEnabled(Procedure proc) {
        if (this.master instanceof HMaster) {
            return this.procSched.waitEvent(((HMaster)this.master).getServerCrashProcessingEnabledEvent(), proc);
        }
        return false;
    }

    public boolean waitFailoverCleanup(Procedure proc) {
        return this.procSched.waitEvent(this.master.getAssignmentManager().getFailoverCleanupEvent(), proc);
    }

    public void setEventReady(ProcedureEvent event, boolean isReady) {
        if (isReady) {
            this.procSched.wakeEvent(event);
        } else {
            this.procSched.suspendEvent(event);
        }
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.master.getMasterProcedureExecutor().refreshConfiguration(conf);
    }

    @InterfaceAudience.Private
    public static class MasterProcedureStoreListener
    implements ProcedureStore.ProcedureStoreListener {
        private final MasterServices master;

        public MasterProcedureStoreListener(MasterServices master) {
            this.master = master;
        }

        @Override
        public void postSync() {
        }

        @Override
        public void abortProcess() {
            this.master.abort("The Procedure Store lost the lease", null);
        }
    }

    @InterfaceAudience.Private
    public static class WALStoreLeaseRecovery
    implements WALProcedureStore.LeaseRecovery {
        private final MasterServices master;

        public WALStoreLeaseRecovery(MasterServices master) {
            this.master = master;
        }

        @Override
        public void recoverFileLease(FileSystem fs, final Path path) throws IOException {
            Configuration conf = this.master.getConfiguration();
            FSUtils fsUtils = FSUtils.getInstance(fs, conf);
            fsUtils.recoverFileLease(fs, path, conf, new CancelableProgressable(){

                @Override
                public boolean progress() {
                    LOG.debug((Object)("Recover Procedure Store log lease: " + path));
                    return this.isRunning();
                }
            });
        }

        private boolean isRunning() {
            return this.master.isActiveMaster() && !this.master.isStopped() && !this.master.isStopping() && !this.master.isAborted();
        }
    }
}

