/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ModifyColumnFamilyProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.ModifyColumnFamilyState> {
    private static final Log LOG = LogFactory.getLog(ModifyColumnFamilyProcedure.class);
    private TableName tableName;
    private TableDescriptor unmodifiedtableDescriptor;
    private ColumnFamilyDescriptor cfDescriptor;
    private Boolean traceEnabled;

    public ModifyColumnFamilyProcedure() {
        this.unmodifiedtableDescriptor = null;
        this.traceEnabled = null;
    }

    public ModifyColumnFamilyProcedure(MasterProcedureEnv env, TableName tableName, ColumnFamilyDescriptor cfDescriptor) {
        this(env, tableName, cfDescriptor, null);
    }

    public ModifyColumnFamilyProcedure(MasterProcedureEnv env, TableName tableName, ColumnFamilyDescriptor cfDescriptor, ProcedurePrepareLatch latch) {
        super(env, latch);
        this.tableName = tableName;
        this.cfDescriptor = cfDescriptor;
        this.unmodifiedtableDescriptor = null;
        this.traceEnabled = null;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyColumnFamilyState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case MODIFY_COLUMN_FAMILY_PREPARE: {
                    this.prepareModify(env);
                    this.setNextState(MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_PRE_OPERATION);
                    break;
                }
                case MODIFY_COLUMN_FAMILY_PRE_OPERATION: {
                    this.preModify(env, state);
                    this.setNextState(MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case MODIFY_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    this.setNextState(MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_POST_OPERATION);
                    break;
                }
                case MODIFY_COLUMN_FAMILY_POST_OPERATION: {
                    this.postModify(env, state);
                    this.setNextState(MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_REOPEN_ALL_REGIONS);
                    break;
                }
                case MODIFY_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                    if (env.getAssignmentManager().isTableEnabled(this.getTableName())) {
                        this.addChildProcedure(env.getAssignmentManager().createReopenProcedures(this.getTableName()));
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-modify-columnfamily", e);
            }
            LOG.warn((Object)("Retriable error trying to disable table=" + this.tableName + " (in state=" + state + ")"), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyColumnFamilyState state) throws IOException {
        if (state == MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_PREPARE || state == MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_PRE_OPERATION) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.ModifyColumnFamilyState state) {
        switch (state) {
            case MODIFY_COLUMN_FAMILY_PREPARE: 
            case MODIFY_COLUMN_FAMILY_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void completionCleanup(MasterProcedureEnv env) {
        this.releaseSyncLatch();
    }

    @Override
    protected MasterProcedureProtos.ModifyColumnFamilyState getState(int stateId) {
        return MasterProcedureProtos.ModifyColumnFamilyState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.ModifyColumnFamilyState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.ModifyColumnFamilyState getInitialState() {
        return MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ModifyColumnFamilyStateData.Builder modifyCFMsg = MasterProcedureProtos.ModifyColumnFamilyStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setTableName(ProtobufUtil.toProtoTableName(this.tableName)).setColumnfamilySchema(ProtobufUtil.toColumnFamilySchema(this.cfDescriptor));
        if (this.unmodifiedtableDescriptor != null) {
            modifyCFMsg.setUnmodifiedTableSchema(ProtobufUtil.toTableSchema(this.unmodifiedtableDescriptor));
        }
        serializer.serialize(modifyCFMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ModifyColumnFamilyStateData modifyCFMsg = serializer.deserialize(MasterProcedureProtos.ModifyColumnFamilyStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(modifyCFMsg.getUserInfo()));
        this.tableName = ProtobufUtil.toTableName(modifyCFMsg.getTableName());
        this.cfDescriptor = ProtobufUtil.toColumnFamilyDescriptor(modifyCFMsg.getColumnfamilySchema());
        if (modifyCFMsg.hasUnmodifiedTableSchema()) {
            this.unmodifiedtableDescriptor = ProtobufUtil.toTableDescriptor(modifyCFMsg.getUnmodifiedTableSchema());
        }
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.tableName);
        sb.append(", columnfamily=");
        if (this.cfDescriptor != null) {
            sb.append(this.getColumnFamilyName());
        } else {
            sb.append("Unknown");
        }
        sb.append(")");
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private void prepareModify(MasterProcedureEnv env) throws IOException {
        this.checkTableModifiable(env);
        this.unmodifiedtableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (this.unmodifiedtableDescriptor == null) {
            throw new IOException("TableDescriptor missing for " + this.tableName);
        }
        if (!this.unmodifiedtableDescriptor.hasColumnFamily(this.cfDescriptor.getName())) {
            throw new InvalidFamilyOperationException("Family '" + this.getColumnFamilyName() + "' does not exist, so it cannot be modified");
        }
    }

    private void preModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        LOG.info((Object)("ModifyColumnFamily. Table = " + this.tableName + " HCD = " + this.cfDescriptor.toString()));
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder(env.getMasterServices().getTableDescriptors().get(this.tableName));
        builder.modifyColumnFamily(this.cfDescriptor);
        env.getMasterServices().getTableDescriptors().add(builder.build());
    }

    private void restoreTableDescriptor(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getTableDescriptors().add(this.unmodifiedtableDescriptor);
    }

    private void postModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private String getColumnFamilyName() {
        return this.cfDescriptor.getNameAsString();
    }

    private void runCoprocessorAction(MasterProcedureEnv env, MasterProcedureProtos.ModifyColumnFamilyState state) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            switch (state) {
                case MODIFY_COLUMN_FAMILY_PRE_OPERATION: {
                    cpHost.preModifyColumnFamilyAction(this.tableName, this.cfDescriptor, this.getUser());
                    break;
                }
                case MODIFY_COLUMN_FAMILY_POST_OPERATION: {
                    cpHost.postCompletedModifyColumnFamilyAction(this.tableName, this.cfDescriptor, this.getUser());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
    }
}

