/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;

public class RSProcedureDispatcher
extends RemoteProcedureDispatcher<MasterProcedureEnv, ServerName>
implements ServerListener {
    private static final Log LOG = LogFactory.getLog(RSProcedureDispatcher.class);
    public static final String RS_RPC_STARTUP_WAIT_TIME_CONF_KEY = "hbase.regionserver.rpc.startup.waittime";
    private static final int DEFAULT_RS_RPC_STARTUP_WAIT_TIME = 60000;
    private static final int RS_VERSION_WITH_EXEC_PROCS = 0x200000;
    protected final MasterServices master;
    protected final long rsStartupWaitTime;

    public RSProcedureDispatcher(MasterServices master) {
        super(master.getConfiguration());
        this.master = master;
        this.rsStartupWaitTime = master.getConfiguration().getLong(RS_RPC_STARTUP_WAIT_TIME_CONF_KEY, 60000L);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        this.master.getServerManager().registerListener(this);
        for (ServerName serverName : this.master.getServerManager().getOnlineServersList()) {
            this.addNode(serverName);
        }
        return true;
    }

    @Override
    public boolean stop() {
        if (!super.stop()) {
            return false;
        }
        this.master.getServerManager().unregisterListener(this);
        return true;
    }

    @Override
    protected void remoteDispatch(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
        int rsVersion = this.master.getAssignmentManager().getServerVersion(serverName);
        if (rsVersion >= 0x200000) {
            LOG.info((Object)String.format("Using procedure batch rpc execution for serverName=%s version=%s", serverName, rsVersion));
            this.submitTask(new ExecuteProceduresRemoteCall(serverName, operations));
        } else {
            LOG.info((Object)String.format("Fallback to compat rpc execution for serverName=%s version=%s", serverName, rsVersion));
            this.submitTask(new CompatRemoteProcedureResolver(serverName, operations));
        }
    }

    @Override
    protected void abortPendingOperations(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
        DoNotRetryIOException e = new DoNotRetryIOException("server not online " + serverName);
        MasterProcedureEnv env = this.master.getMasterProcedureExecutor().getEnvironment();
        for (RemoteProcedureDispatcher.RemoteProcedure proc : operations) {
            proc.remoteCallFailed(env, serverName, e);
        }
    }

    @Override
    public void serverAdded(ServerName serverName) {
        this.addNode(serverName);
    }

    @Override
    public void serverRemoved(ServerName serverName) {
        this.removeNode(serverName);
    }

    public void splitAndResolveOperation(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations, RemoteProcedureResolver resolver) {
        List<RegionCloseOperation> closeOps;
        MasterProcedureEnv env = this.master.getMasterProcedureExecutor().getEnvironment();
        ArrayListMultimap<Class<?>, RemoteProcedureDispatcher.RemoteOperation> reqsByType = this.buildAndGroupRequestByType(env, serverName, operations);
        List<RegionOpenOperation> openOps = this.fetchType(reqsByType, RegionOpenOperation.class);
        if (!openOps.isEmpty()) {
            resolver.dispatchOpenRequests(env, openOps);
        }
        if (!(closeOps = this.fetchType(reqsByType, RegionCloseOperation.class)).isEmpty()) {
            resolver.dispatchCloseRequests(env, closeOps);
        }
        if (!reqsByType.isEmpty()) {
            LOG.warn((Object)("unknown request type in the queue: " + reqsByType));
        }
    }

    private static AdminProtos.OpenRegionRequest buildOpenRegionRequest(MasterProcedureEnv env, ServerName serverName, List<RegionOpenOperation> operations) {
        AdminProtos.OpenRegionRequest.Builder builder = AdminProtos.OpenRegionRequest.newBuilder();
        builder.setServerStartCode(serverName.getStartcode());
        builder.setMasterSystemTime(EnvironmentEdgeManager.currentTime());
        for (RegionOpenOperation op : operations) {
            builder.addOpenInfo(op.buildRegionOpenInfoRequest(env));
        }
        return builder.build();
    }

    public static class RegionCloseOperation
    extends RegionOperation {
        private final ServerName destinationServer;
        private boolean closed = false;

        public RegionCloseOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, HRegionInfo regionInfo, ServerName destinationServer) {
            super(remoteProcedure, regionInfo);
            this.destinationServer = destinationServer;
        }

        public ServerName getDestinationServer() {
            return this.destinationServer;
        }

        protected void setClosed(boolean closed) {
            this.closed = closed;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName serverName) {
            return ProtobufUtil.buildCloseRegionRequest(serverName, this.getRegionInfo().getRegionName(), this.getDestinationServer());
        }
    }

    public static class RegionOpenOperation
    extends RegionOperation {
        private final List<ServerName> favoredNodes;
        private final boolean openForReplay;
        private boolean failedOpen;

        public RegionOpenOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, HRegionInfo regionInfo, List<ServerName> favoredNodes, boolean openForReplay) {
            super(remoteProcedure, regionInfo);
            this.favoredNodes = favoredNodes;
            this.openForReplay = openForReplay;
        }

        protected void setFailedOpen(boolean failedOpen) {
            this.failedOpen = failedOpen;
        }

        public boolean isFailedOpen() {
            return this.failedOpen;
        }

        public AdminProtos.OpenRegionRequest.RegionOpenInfo buildRegionOpenInfoRequest(MasterProcedureEnv env) {
            return RequestConverter.buildRegionOpenInfo(this.getRegionInfo(), env.getAssignmentManager().getFavoredNodes(this.getRegionInfo()), false);
        }
    }

    public static abstract class RegionOperation
    extends RemoteProcedureDispatcher.RemoteOperation {
        private final HRegionInfo regionInfo;

        protected RegionOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, HRegionInfo regionInfo) {
            super(remoteProcedure);
            this.regionInfo = regionInfo;
        }

        public HRegionInfo getRegionInfo() {
            return this.regionInfo;
        }
    }

    public static abstract class ServerOperation
    extends RemoteProcedureDispatcher.RemoteOperation {
        protected ServerOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure) {
            super(remoteProcedure);
        }
    }

    protected class CompatRemoteProcedureResolver
    implements Callable<Void>,
    RemoteProcedureResolver {
        private final Set<RemoteProcedureDispatcher.RemoteProcedure> operations;
        private final ServerName serverName;

        public CompatRemoteProcedureResolver(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
            this.serverName = serverName;
            this.operations = operations;
        }

        @Override
        public Void call() {
            RSProcedureDispatcher.this.splitAndResolveOperation(this.serverName, this.operations, this);
            return null;
        }

        @Override
        public void dispatchOpenRequests(MasterProcedureEnv env, List<RegionOpenOperation> operations) {
            RSProcedureDispatcher.this.submitTask(new OpenRegionRemoteCall(this.serverName, operations));
        }

        @Override
        public void dispatchCloseRequests(MasterProcedureEnv env, List<RegionCloseOperation> operations) {
            for (RegionCloseOperation op : operations) {
                RSProcedureDispatcher.this.submitTask(new CloseRegionRemoteCall(this.serverName, op));
            }
        }
    }

    private final class CloseRegionRemoteCall
    extends AbstractRSRemoteCall {
        private final RegionCloseOperation operation;

        public CloseRegionRemoteCall(ServerName serverName, RegionCloseOperation operation) {
            super(serverName);
            this.operation = operation;
        }

        @Override
        public Void call() {
            block2: {
                MasterProcedureEnv env = RSProcedureDispatcher.this.master.getMasterProcedureExecutor().getEnvironment();
                AdminProtos.CloseRegionRequest request = this.operation.buildCloseRegionRequest(this.getServerName());
                try {
                    AdminProtos.CloseRegionResponse response = this.sendRequest(this.getServerName(), request);
                    this.remoteCallCompleted(env, response);
                }
                catch (IOException e) {
                    e = this.unwrapException(e);
                    if (this.scheduleForRetry(e)) break block2;
                    this.remoteCallFailed(env, e);
                }
            }
            return null;
        }

        private AdminProtos.CloseRegionResponse sendRequest(ServerName serverName, AdminProtos.CloseRegionRequest request) throws IOException {
            try {
                return this.getRsAdmin().closeRegion(null, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }

        private void remoteCallCompleted(MasterProcedureEnv env, AdminProtos.CloseRegionResponse response) {
            this.operation.setClosed(response.getClosed());
            this.operation.getRemoteProcedure().remoteCallCompleted(env, this.getServerName(), this.operation);
        }

        private void remoteCallFailed(MasterProcedureEnv env, IOException e) {
            this.operation.getRemoteProcedure().remoteCallFailed(env, this.getServerName(), e);
        }
    }

    private final class OpenRegionRemoteCall
    extends AbstractRSRemoteCall {
        private final List<RegionOpenOperation> operations;

        public OpenRegionRemoteCall(ServerName serverName, List<RegionOpenOperation> operations) {
            super(serverName);
            this.operations = operations;
        }

        @Override
        public Void call() {
            block2: {
                MasterProcedureEnv env = RSProcedureDispatcher.this.master.getMasterProcedureExecutor().getEnvironment();
                AdminProtos.OpenRegionRequest request = RSProcedureDispatcher.buildOpenRegionRequest(env, this.getServerName(), this.operations);
                try {
                    AdminProtos.OpenRegionResponse response = this.sendRequest(this.getServerName(), request);
                    this.remoteCallCompleted(env, response);
                }
                catch (IOException e) {
                    e = this.unwrapException(e);
                    if (this.scheduleForRetry(e)) break block2;
                    this.remoteCallFailed(env, e);
                }
            }
            return null;
        }

        private AdminProtos.OpenRegionResponse sendRequest(ServerName serverName, AdminProtos.OpenRegionRequest request) throws IOException {
            try {
                return this.getRsAdmin().openRegion(null, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }

        private void remoteCallCompleted(MasterProcedureEnv env, AdminProtos.OpenRegionResponse response) {
            int index = 0;
            for (RegionOpenOperation op : this.operations) {
                AdminProtos.OpenRegionResponse.RegionOpeningState state;
                op.setFailedOpen((state = response.getOpeningState(index++)) == AdminProtos.OpenRegionResponse.RegionOpeningState.FAILED_OPENING);
                op.getRemoteProcedure().remoteCallCompleted(env, this.getServerName(), op);
            }
        }

        private void remoteCallFailed(MasterProcedureEnv env, IOException e) {
            for (RegionOpenOperation op : this.operations) {
                op.getRemoteProcedure().remoteCallFailed(env, this.getServerName(), e);
            }
        }
    }

    protected class ExecuteProceduresRemoteCall
    extends AbstractRSRemoteCall
    implements RemoteProcedureResolver {
        private final Set<RemoteProcedureDispatcher.RemoteProcedure> operations;
        private AdminProtos.ExecuteProceduresRequest.Builder request;

        public ExecuteProceduresRemoteCall(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
            super(serverName);
            this.request = null;
            this.operations = operations;
        }

        @Override
        public Void call() {
            block3: {
                MasterProcedureEnv env = RSProcedureDispatcher.this.master.getMasterProcedureExecutor().getEnvironment();
                this.request = AdminProtos.ExecuteProceduresRequest.newBuilder();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Building request with operations count=" + this.operations.size()));
                }
                RSProcedureDispatcher.this.splitAndResolveOperation(this.getServerName(), this.operations, this);
                try {
                    AdminProtos.ExecuteProceduresResponse response = this.sendRequest(this.getServerName(), this.request.build());
                    this.remoteCallCompleted(env, response);
                }
                catch (IOException e) {
                    e = this.unwrapException(e);
                    if (this.scheduleForRetry(e)) break block3;
                    this.remoteCallFailed(env, e);
                }
            }
            return null;
        }

        @Override
        public void dispatchOpenRequests(MasterProcedureEnv env, List<RegionOpenOperation> operations) {
            this.request.addOpenRegion(RSProcedureDispatcher.buildOpenRegionRequest(env, this.getServerName(), operations));
        }

        @Override
        public void dispatchCloseRequests(MasterProcedureEnv env, List<RegionCloseOperation> operations) {
            for (RegionCloseOperation op : operations) {
                this.request.addCloseRegion(op.buildCloseRegionRequest(this.getServerName()));
            }
        }

        protected AdminProtos.ExecuteProceduresResponse sendRequest(ServerName serverName, AdminProtos.ExecuteProceduresRequest request) throws IOException {
            try {
                return this.getRsAdmin().executeProcedures(null, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }

        private void remoteCallCompleted(MasterProcedureEnv env, AdminProtos.ExecuteProceduresResponse response) {
        }

        private void remoteCallFailed(MasterProcedureEnv env, IOException e) {
            for (RemoteProcedureDispatcher.RemoteProcedure proc : this.operations) {
                proc.remoteCallFailed(env, this.getServerName(), e);
            }
        }
    }

    private static interface RemoteProcedureResolver {
        public void dispatchOpenRequests(MasterProcedureEnv var1, List<RegionOpenOperation> var2);

        public void dispatchCloseRequests(MasterProcedureEnv var1, List<RegionCloseOperation> var2);
    }

    protected abstract class AbstractRSRemoteCall
    implements Callable<Void> {
        private final ServerName serverName;
        private int numberOfAttemptsSoFar = 0;
        private long maxWaitTime = -1L;

        public AbstractRSRemoteCall(ServerName serverName) {
            this.serverName = serverName;
        }

        @Override
        public abstract Void call();

        protected AdminProtos.AdminService.BlockingInterface getRsAdmin() throws IOException {
            AdminProtos.AdminService.BlockingInterface admin = RSProcedureDispatcher.this.master.getServerManager().getRsAdmin(this.serverName);
            if (admin == null) {
                throw new IOException("Attempting to send OPEN RPC to server " + this.getServerName() + " failed because no RPC connection found to this server");
            }
            return admin;
        }

        protected ServerName getServerName() {
            return this.serverName;
        }

        protected boolean scheduleForRetry(IOException e) {
            boolean retry;
            boolean hold = e instanceof ServerNotRunningYetException;
            if (hold) {
                LOG.warn((Object)String.format("waiting a little before trying on the same server=%s try=%d", this.serverName, this.numberOfAttemptsSoFar), (Throwable)e);
                long now = EnvironmentEdgeManager.currentTime();
                if (now < this.getMaxWaitTime()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("server is not yet up; waiting up to %dms", this.getMaxWaitTime() - now), (Throwable)e);
                    }
                    RSProcedureDispatcher.this.submitTask(this, 100L, TimeUnit.MILLISECONDS);
                    return true;
                }
                LOG.warn((Object)String.format("server %s is not up for a while; try a new one", this.serverName), (Throwable)e);
                return false;
            }
            boolean bl = retry = !hold && e instanceof SocketTimeoutException && RSProcedureDispatcher.this.master.getServerManager().isServerOnline(this.serverName);
            if (retry) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Retrying to same RegionServer %s because: %s", this.serverName, e.getMessage()), (Throwable)e);
                }
                RSProcedureDispatcher.this.submitTask(this);
                return true;
            }
            LOG.warn((Object)String.format("Failed dispatch to server=%s try=%d", this.serverName, this.numberOfAttemptsSoFar), (Throwable)e);
            return false;
        }

        private long getMaxWaitTime() {
            if (this.maxWaitTime < 0L) {
                this.maxWaitTime = EnvironmentEdgeManager.currentTime() + RSProcedureDispatcher.this.rsStartupWaitTime;
            }
            return this.maxWaitTime;
        }

        protected IOException unwrapException(IOException e) {
            if (e instanceof RemoteException) {
                e = ((RemoteException)e).unwrapRemoteException();
            }
            return e;
        }
    }
}

