/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;

public class RecoverMetaProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.RecoverMetaState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(RecoverMetaProcedure.class);
    private ServerName failedMetaServer;
    private boolean shouldSplitWal;
    private int replicaId;
    private final ProcedurePrepareLatch syncLatch;
    private HMaster master;

    public RecoverMetaProcedure(ServerName failedMetaServer, boolean shouldSplitLog) {
        this(failedMetaServer, shouldSplitLog, null);
    }

    public RecoverMetaProcedure(ServerName failedMetaServer, boolean shouldSplitLog, ProcedurePrepareLatch latch) {
        this.failedMetaServer = failedMetaServer;
        this.shouldSplitWal = shouldSplitLog;
        this.replicaId = 0;
        this.syncLatch = latch;
    }

    public RecoverMetaProcedure() {
        this(null, false);
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.RecoverMetaState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        this.prepare(env);
        if (!this.isRunRequired()) {
            LOG.info((Object)(this + "; Meta already initialized. Skipping run"));
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        try {
            switch (state) {
                case RECOVER_META_SPLIT_LOGS: {
                    LOG.info((Object)("Start " + this));
                    if (this.shouldSplitWal) {
                        if (this.failedMetaServer != null) {
                            this.master.getMasterWalManager().splitMetaLog(this.failedMetaServer);
                        } else {
                            ServerName serverName = this.master.getMetaTableLocator().getMetaRegionLocation(this.master.getZooKeeper());
                            Set<ServerName> previouslyFailedServers = this.master.getMasterWalManager().getFailedServersFromLogFolders();
                            if (serverName != null && previouslyFailedServers.contains(serverName)) {
                                this.master.getMasterWalManager().splitMetaLog(serverName);
                            }
                        }
                    }
                    this.setNextState(MasterProcedureProtos.RecoverMetaState.RECOVER_META_ASSIGN_REGIONS);
                    break;
                }
                case RECOVER_META_ASSIGN_REGIONS: {
                    AssignProcedure metaAssignProcedure;
                    HRegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, this.replicaId);
                    if (this.failedMetaServer != null) {
                        LOG.info((Object)(this + "; Assigning meta with new plan. previous meta server=" + this.failedMetaServer));
                        metaAssignProcedure = this.master.getAssignmentManager().createAssignProcedure(hri, true);
                    } else {
                        ServerName metaServer = MetaTableLocator.getMetaRegionState(this.master.getZooKeeper()).getServerName();
                        LOG.info((Object)(this + "; Retaining meta assignment to server=" + metaServer));
                        metaAssignProcedure = this.master.getAssignmentManager().createAssignProcedure(hri, metaServer);
                    }
                    this.addChildProcedure(metaAssignProcedure);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException | KeeperException e) {
            LOG.warn((Object)(this + "; Failed state=" + state + ", retry " + this + "; cycles=" + this.getCycles()), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.RecoverMetaState recoverMetaState) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("unhandled state=" + recoverMetaState);
    }

    @Override
    protected MasterProcedureProtos.RecoverMetaState getState(int stateId) {
        return MasterProcedureProtos.RecoverMetaState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.RecoverMetaState recoverMetaState) {
        return recoverMetaState.getNumber();
    }

    @Override
    protected MasterProcedureProtos.RecoverMetaState getInitialState() {
        return MasterProcedureProtos.RecoverMetaState.RECOVER_META_SPLIT_LOGS;
    }

    @Override
    protected void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" failedMetaServer=");
        sb.append(this.failedMetaServer);
        sb.append(", splitWal=");
        sb.append(this.shouldSplitWal);
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.RecoverMetaStateData.Builder state = MasterProcedureProtos.RecoverMetaStateData.newBuilder().setShouldSplitWal(this.shouldSplitWal);
        if (this.failedMetaServer != null) {
            state.setFailedMetaServer(ProtobufUtil.toServerName(this.failedMetaServer));
        }
        state.setReplicaId(this.replicaId);
        serializer.serialize(state.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.RecoverMetaStateData state = serializer.deserialize(MasterProcedureProtos.RecoverMetaStateData.class);
        this.shouldSplitWal = state.hasShouldSplitWal() && state.getShouldSplitWal();
        this.failedMetaServer = state.hasFailedMetaServer() ? ProtobufUtil.toServerName(state.getFailedMetaServer()) : null;
        this.replicaId = state.hasReplicaId() ? state.getReplicaId() : 0;
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitTableExclusiveLock(this, TableName.META_TABLE_NAME)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeTableExclusiveLock(this, TableName.META_TABLE_NAME);
    }

    @Override
    protected void completionCleanup(MasterProcedureEnv env) {
        ProcedurePrepareLatch.releaseLatch(this.syncLatch, this);
    }

    @Override
    public TableName getTableName() {
        return TableName.META_TABLE_NAME;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.ENABLE;
    }

    private boolean isRunRequired() {
        return this.failedMetaServer != null || !this.master.getAssignmentManager().isMetaInitialized();
    }

    private void prepare(MasterProcedureEnv env) {
        if (this.master == null) {
            this.master = (HMaster)env.getMasterServices();
            Preconditions.checkArgument(this.master != null);
        }
    }
}

