/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class EnabledTableSnapshotHandler
extends TakeSnapshotHandler {
    private static final Log LOG = LogFactory.getLog(EnabledTableSnapshotHandler.class);
    private final ProcedureCoordinator coordinator;

    public EnabledTableSnapshotHandler(SnapshotProtos.SnapshotDescription snapshot, MasterServices master, SnapshotManager manager) {
        super(snapshot, master, manager);
        this.coordinator = manager.getCoordinator();
    }

    @Override
    public EnabledTableSnapshotHandler prepare() throws Exception {
        return (EnabledTableSnapshotHandler)super.prepare();
    }

    @Override
    protected void snapshotRegions(List<Pair<HRegionInfo, ServerName>> regions) throws HBaseSnapshotException, IOException {
        HashSet<String> regionServers = new HashSet<String>(regions.size());
        for (Pair<HRegionInfo, ServerName> region : regions) {
            HRegionInfo hRegionInfo;
            if (region == null || region.getFirst() == null || region.getSecond() == null || (hRegionInfo = region.getFirst()).isOffline() && (hRegionInfo.isSplit() || hRegionInfo.isSplitParent())) continue;
            regionServers.add(region.getSecond().toString());
        }
        Procedure proc = this.coordinator.startProcedure(this.monitor, this.snapshot.getName(), this.snapshot.toByteArray(), Lists.newArrayList(regionServers));
        if (proc == null) {
            String msg = "Failed to submit distributed procedure for snapshot '" + this.snapshot.getName() + "'";
            LOG.error((Object)msg);
            throw new HBaseSnapshotException(msg);
        }
        try {
            proc.waitForCompleted();
            LOG.info((Object)("Done waiting - online snapshot for " + this.snapshot.getName()));
            for (Pair pair : regions) {
                HRegionInfo regionInfo = (HRegionInfo)pair.getFirst();
                if (!regionInfo.isOffline() || !regionInfo.isSplit() && !regionInfo.isSplitParent()) continue;
                LOG.info((Object)("Take disabled snapshot of offline region=" + regionInfo));
                this.snapshotDisabledRegion(regionInfo);
            }
            boolean mobEnabled = MobUtils.hasMobColumns(this.htd);
            if (mobEnabled) {
                LOG.info((Object)("Taking snapshot for mob files in table " + this.htd.getTableName()));
                HRegionInfo hRegionInfo = MobUtils.getMobRegionInfo(this.htd.getTableName());
                this.snapshotMobRegion(hRegionInfo);
            }
        }
        catch (InterruptedException e) {
            ForeignException foreignException = new ForeignException("Interrupted while waiting for snapshot to finish", e);
            this.monitor.receive(foreignException);
            Thread.currentThread().interrupt();
        }
        catch (ForeignException e) {
            this.monitor.receive(e);
        }
    }

    private void snapshotMobRegion(HRegionInfo regionInfo) throws IOException {
        this.snapshotManifest.addMobRegion(regionInfo);
        this.monitor.rethrowException();
        this.status.setStatus("Completed referencing HFiles for the mob region of table: " + this.snapshotTable);
    }
}

