/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.OptionalInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DefaultMobStoreCompactor
extends DefaultCompactor {
    private static final Log LOG = LogFactory.getLog(DefaultMobStoreCompactor.class);
    private long mobSizeThreshold;
    private HMobStore mobStore;
    private final Compactor.InternalScannerFactory scannerFactory = new Compactor.InternalScannerFactory(){

        @Override
        public ScanType getScanType(CompactionRequest request) {
            return ScanType.COMPACT_RETAIN_DELETES;
        }

        @Override
        public InternalScanner createScanner(List<StoreFileScanner> scanners, ScanType scanType, Compactor.FileDetails fd, long smallestReadPoint) throws IOException {
            return new StoreScanner(DefaultMobStoreCompactor.this.store, DefaultMobStoreCompactor.this.store.getScanInfo(), OptionalInt.empty(), scanners, scanType, smallestReadPoint, fd.earliestPutTs);
        }
    };
    private final Compactor.CellSinkFactory<StoreFileWriter> writerFactory = new Compactor.CellSinkFactory<StoreFileWriter>(){

        @Override
        public StoreFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind) throws IOException {
            return DefaultMobStoreCompactor.this.store.createWriterInTmp(fd.maxKeyCount, DefaultMobStoreCompactor.this.compactionCompression, true, true, true, shouldDropBehind);
        }
    };

    public DefaultMobStoreCompactor(Configuration conf, Store store) {
        super(conf, store);
        if (!(store instanceof HMobStore)) {
            throw new IllegalArgumentException("The store " + store + " is not a HMobStore");
        }
        this.mobStore = (HMobStore)store;
        this.mobSizeThreshold = store.getColumnFamilyDescriptor().getMobThreshold();
    }

    @Override
    public List<Path> compact(CompactionRequest request, ThroughputController throughputController, User user) throws IOException {
        return this.compact(request, this.scannerFactory, this.writerFactory, throughputController, user);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean performCompaction(Compactor.FileDetails fd, InternalScanner scanner, CellSink writer, long smallestReadPoint, boolean cleanSeqId, ThroughputController throughputController, boolean major, int numofFilesToCompact) throws IOException {
        block39: {
            block37: {
                block38: {
                    bytesWrittenProgressForCloseCheck = 0L;
                    bytesWrittenProgressForLog = 0L;
                    bytesWrittenProgressForShippedCall = 0L;
                    cells = new ArrayList<Cell>();
                    closeCheckSizeLimit = HStore.getCloseCheckInterval();
                    lastMillis = 0L;
                    if (DefaultMobStoreCompactor.LOG.isDebugEnabled()) {
                        lastMillis = EnvironmentEdgeManager.currentTime();
                    }
                    compactionName = ThroughputControlUtil.getNameForThrottling(this.store, "compaction");
                    now = 0L;
                    path = MobUtils.getMobFamilyPath(this.conf, this.store.getTableName(), this.store.getColumnFamilyName());
                    fileName = null;
                    mobFileWriter = null;
                    delFileWriter = null;
                    mobCells = 0L;
                    deleteMarkersCount = 0L;
                    cellsCountCompactedToMob = 0L;
                    cellsCountCompactedFromMob = 0L;
                    cellsSizeCompactedToMob = 0L;
                    cellsSizeCompactedFromMob = 0L;
                    finished = false;
                    scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
                    throughputController.start(compactionName);
                    kvs = scanner instanceof KeyValueScanner != false ? (KeyValueScanner)scanner : null;
                    shippedCallSizeLimit = (long)numofFilesToCompact * (long)this.store.getColumnFamilyDescriptor().getBlocksize();
                    try {
                        try {
                            mobFileWriter = this.mobStore.createWriterInTmp(new Date(fd.latestPutTs), fd.maxKeyCount, this.compactionCompression, this.store.getRegionInfo().getStartKey(), true);
                            fileName = Bytes.toBytes(mobFileWriter.getPath().getName());
                        }
                        catch (IOException e) {
                            DefaultMobStoreCompactor.LOG.warn((Object)"Failed to create mob writer, we will continue the compaction by writing MOB cells directly in store files", (Throwable)e);
                        }
                        if (major) {
                            try {
                                delFileWriter = this.mobStore.createDelFileWriterInTmp(new Date(fd.latestPutTs), fd.maxKeyCount, this.compactionCompression, this.store.getRegionInfo().getStartKey());
                            }
                            catch (IOException e) {
                                DefaultMobStoreCompactor.LOG.warn((Object)"Failed to create del writer, we will continue the compaction by writing delete markers directly in store files", (Throwable)e);
                            }
                        }
                        while (true) {
                            hasMore = scanner.next(cells, scannerContext);
                            if (DefaultMobStoreCompactor.LOG.isDebugEnabled()) {
                                now = EnvironmentEdgeManager.currentTime();
                            }
lbl43:
                            // 5 sources

                            for (Cell c : cells) {
                                block36: {
                                    block42: {
                                        block43: {
                                            block41: {
                                                block40: {
                                                    if (!major || !CellUtil.isDelete(c)) break block40;
                                                    if (MobUtils.isMobReferenceCell(c) || delFileWriter == null) {
                                                        writer.append(c);
                                                        break block36;
                                                    } else {
                                                        writer.append(MobUtils.createMobRefDeleteMarker(c));
                                                        delFileWriter.append(c);
                                                        ++deleteMarkersCount;
                                                    }
                                                    break block36;
                                                }
                                                if (mobFileWriter != null && c.getTypeByte() == KeyValue.Type.Put.getCode()) break block41;
                                                writer.append(c);
                                                break block36;
                                            }
                                            if (!MobUtils.isMobReferenceCell(c)) break block42;
                                            if (!MobUtils.hasValidMobRefCellValue(c)) break block43;
                                            size = MobUtils.getMobValueLength(c);
                                            if ((long)size > this.mobSizeThreshold) {
                                                writer.append(c);
                                                break block36;
                                            } else {
                                                mobCell = this.mobStore.resolve(c, false);
                                                if (mobCell.getValueLength() != 0) {
                                                    CellUtil.setSequenceId(mobCell, c.getSequenceId());
                                                    writer.append(mobCell);
                                                    ++cellsCountCompactedFromMob;
                                                    cellsSizeCompactedFromMob += (long)mobCell.getValueLength();
                                                    break block36;
                                                } else {
                                                    writer.append(c);
                                                }
                                            }
                                            break block36;
                                        }
                                        DefaultMobStoreCompactor.LOG.warn((Object)("The value format of the KeyValue " + c + " is wrong, its length is less than " + 4));
                                        writer.append(c);
                                        break block36;
                                    }
                                    if ((long)c.getValueLength() <= this.mobSizeThreshold) {
                                        writer.append(c);
                                    } else {
                                        ++mobCells;
                                        mobFileWriter.append(c);
                                        reference = MobUtils.createMobRefCell(c, fileName, this.mobStore.getRefCellTags());
                                        writer.append(reference);
                                        ++cellsCountCompactedToMob;
                                        cellsSizeCompactedToMob += (long)c.getValueLength();
                                    }
                                }
                                len = KeyValueUtil.length(c);
                                ++this.progress.currentCompactedKVs;
                                this.progress.totalCompactedSize += (long)len;
                                bytesWrittenProgressForShippedCall += (long)len;
                                if (DefaultMobStoreCompactor.LOG.isDebugEnabled()) {
                                    bytesWrittenProgressForLog += (long)len;
                                }
                                throughputController.control(compactionName, len);
                                if (closeCheckSizeLimit > 0 && (bytesWrittenProgressForCloseCheck += (long)len) > (long)closeCheckSizeLimit) {
                                    bytesWrittenProgressForCloseCheck = 0L;
                                    if (!this.store.areWritesEnabled()) {
                                        this.progress.cancel();
                                        var48_40 = false;
                                        throughputController.finish(compactionName);
                                        if (finished || mobFileWriter == null) break block37;
                                        break block38;
                                    }
                                }
                                ** GOTO lbl-1000
                            }
                            ** GOTO lbl128
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        try {
                            this.progress.cancel();
                            throw new InterruptedIOException("Interrupted while control throughput of compacting " + compactionName);
                        }
                        catch (Throwable var49_41) {
                            throughputController.finish(compactionName);
                            if (!finished && mobFileWriter != null) {
                                this.abortWriter(mobFileWriter);
                            }
                            if (!finished && delFileWriter != null) {
                                this.abortWriter(delFileWriter);
                            }
                            throw var49_41;
                        }
                    }
                }
                this.abortWriter(mobFileWriter);
            }
            if (!finished && delFileWriter != null) {
                this.abortWriter(delFileWriter);
            }
            return var48_40;
lbl-1000:
            // 1 sources

            {
                if (kvs == null || bytesWrittenProgressForShippedCall <= shippedCallSizeLimit) ** GOTO lbl43
                ((ShipperListener)writer).beforeShipped();
                kvs.shipped();
                bytesWrittenProgressForShippedCall = 0L;
                ** GOTO lbl43
lbl128:
                // 1 sources

                if (DefaultMobStoreCompactor.LOG.isDebugEnabled() && now - lastMillis >= 60000L) {
                    DefaultMobStoreCompactor.LOG.debug((Object)("Compaction progress: " + compactionName + " " + this.progress + String.format(", rate=%.2f kB/sec", new Object[]{(double)bytesWrittenProgressForLog / 1024.0 / ((double)(now - lastMillis) / 1000.0)}) + ", throughputController is " + throughputController));
                    lastMillis = now;
                    bytesWrittenProgressForLog = 0L;
                }
                cells.clear();
                if (hasMore) ** continue;
                finished = true;
                throughputController.finish(compactionName);
                if (finished || mobFileWriter == null) break block39;
            }
            this.abortWriter(mobFileWriter);
        }
        if (!finished && delFileWriter != null) {
            this.abortWriter(delFileWriter);
        }
        if (delFileWriter != null) {
            if (deleteMarkersCount > 0L) {
                delFileWriter.appendMetadata(fd.maxSeqId, major, deleteMarkersCount);
                delFileWriter.close();
                this.mobStore.commitFile(delFileWriter.getPath(), path);
            } else {
                this.abortWriter(delFileWriter);
            }
        }
        if (mobFileWriter != null) {
            if (mobCells > 0L) {
                mobFileWriter.appendMetadata(fd.maxSeqId, major, mobCells);
                mobFileWriter.close();
                this.mobStore.commitFile(mobFileWriter.getPath(), path);
            } else {
                this.abortWriter(mobFileWriter);
            }
        }
        this.mobStore.updateCellsCountCompactedFromMob(cellsCountCompactedFromMob);
        this.mobStore.updateCellsCountCompactedToMob(cellsCountCompactedToMob);
        this.mobStore.updateCellsSizeCompactedFromMob(cellsSizeCompactedFromMob);
        this.mobStore.updateCellsSizeCompactedToMob(cellsSizeCompactedToMob);
        this.progress.complete();
        return true;
    }
}

