/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class LogMonitoring {
    public static Set<File> getActiveLogFiles() throws IOException {
        HashSet<File> ret = Sets.newHashSet();
        Enumeration e = Logger.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Appender a = (Appender)e.nextElement();
            if (!(a instanceof FileAppender)) continue;
            FileAppender fa = (FileAppender)a;
            String filename = fa.getFile();
            ret.add(new File(filename));
        }
        return ret;
    }

    public static void dumpTailOfLogs(PrintWriter out, long tailKb) throws IOException {
        Set<File> logs = LogMonitoring.getActiveLogFiles();
        for (File f : logs) {
            out.println("+++++++++++++++++++++++++++++++");
            out.println(f.getAbsolutePath());
            out.println("+++++++++++++++++++++++++++++++");
            try {
                LogMonitoring.dumpTailOfLog(f, out, tailKb);
            }
            catch (IOException ioe) {
                out.println("Unable to dump log at " + f);
                ioe.printStackTrace(out);
            }
            out.println("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void dumpTailOfLog(File f, PrintWriter out, long tailKb) throws IOException {
        FileInputStream fis;
        block4: {
            fis = new FileInputStream(f);
            BufferedReader r = null;
            try {
                String line;
                FileChannel channel = fis.getChannel();
                channel.position(Math.max(0L, channel.size() - tailKb * 1024L));
                r = new BufferedReader(new InputStreamReader(fis));
                r.readLine();
                while ((line = r.readLine()) != null) {
                    out.println(line);
                }
                if (r == null) break block4;
            }
            catch (Throwable throwable) {
                if (r != null) {
                    IOUtils.closeStream(r);
                }
                IOUtils.closeStream(fis);
                throw throwable;
            }
            IOUtils.closeStream(r);
        }
        IOUtils.closeStream(fis);
    }
}

