/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreTracker;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFormat;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureWALFile
implements Comparable<ProcedureWALFile> {
    private static final Log LOG = LogFactory.getLog(ProcedureWALFile.class);
    private ProcedureProtos.ProcedureWALHeader header;
    private FSDataInputStream stream;
    private FileSystem fs;
    private Path logFile;
    private long startPos;
    private long minProcId;
    private long maxProcId;
    private long logSize;
    private long timestamp;
    private final ProcedureStoreTracker tracker = new ProcedureStoreTracker();

    public ProcedureStoreTracker getTracker() {
        return this.tracker;
    }

    public ProcedureWALFile(FileSystem fs, FileStatus logStatus) {
        this.fs = fs;
        this.logFile = logStatus.getPath();
        this.logSize = logStatus.getLen();
        this.timestamp = logStatus.getModificationTime();
        this.tracker.setPartialFlag(true);
    }

    public ProcedureWALFile(FileSystem fs, Path logFile, ProcedureProtos.ProcedureWALHeader header, long startPos, long timestamp) {
        this.fs = fs;
        this.header = header;
        this.logFile = logFile;
        this.startPos = startPos;
        this.logSize = startPos;
        this.timestamp = timestamp;
        this.tracker.setPartialFlag(true);
    }

    public void open() throws IOException {
        if (this.stream == null) {
            this.stream = this.fs.open(this.logFile);
        }
        if (this.header == null) {
            this.header = ProcedureWALFormat.readHeader(this.stream);
            this.startPos = this.stream.getPos();
        } else {
            this.stream.seek(this.startPos);
        }
    }

    public ProcedureProtos.ProcedureWALTrailer readTrailer() throws IOException {
        try {
            ProcedureProtos.ProcedureWALTrailer procedureWALTrailer = ProcedureWALFormat.readTrailer(this.stream, this.startPos, this.logSize);
            return procedureWALTrailer;
        }
        finally {
            this.stream.seek(this.startPos);
        }
    }

    public void readTracker() throws IOException {
        ProcedureProtos.ProcedureWALTrailer trailer = this.readTrailer();
        try {
            this.stream.seek(trailer.getTrackerPos());
            ProcedureProtos.ProcedureStoreTracker trackerProtoBuf = ProcedureProtos.ProcedureStoreTracker.parseDelimitedFrom(this.stream);
            this.tracker.resetToProto(trackerProtoBuf);
        }
        finally {
            this.stream.seek(this.startPos);
        }
    }

    public void updateLocalTracker(ProcedureStoreTracker tracker) {
        this.tracker.resetTo(tracker);
    }

    public void close() {
        if (this.stream == null) {
            return;
        }
        try {
            this.stream.close();
        }
        catch (IOException e) {
            LOG.warn((Object)("unable to close the wal file: " + this.logFile), (Throwable)e);
        }
        finally {
            this.stream = null;
        }
    }

    public FSDataInputStream getStream() {
        return this.stream;
    }

    public ProcedureProtos.ProcedureWALHeader getHeader() {
        return this.header;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isCompacted() {
        return this.header.getType() == 1;
    }

    public long getLogId() {
        return this.header.getLogId();
    }

    public long getSize() {
        return this.logSize;
    }

    void addToSize(long size) {
        this.logSize += size;
    }

    public void removeFile(Path walArchiveDir) throws IOException {
        this.close();
        boolean archived = false;
        if (walArchiveDir != null) {
            Path archivedFile = new Path(walArchiveDir, this.logFile.getName());
            LOG.info((Object)("ARCHIVED (TODO: FILES ARE NOT PURGED FROM ARCHIVE!) " + this.logFile + " to " + archivedFile));
            if (!this.fs.rename(this.logFile, archivedFile)) {
                LOG.warn((Object)("Failed archive of " + this.logFile + ", deleting"));
            } else {
                archived = true;
            }
        }
        if (!archived && !this.fs.delete(this.logFile, false)) {
            LOG.warn((Object)("Failed delete of " + this.logFile));
        }
    }

    public void setProcIds(long minId, long maxId) {
        this.minProcId = minId;
        this.maxProcId = maxId;
    }

    public long getMinProcId() {
        return this.minProcId;
    }

    public long getMaxProcId() {
        return this.maxProcId;
    }

    @Override
    public int compareTo(ProcedureWALFile other) {
        long diff = this.header.getLogId() - other.header.getLogId();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcedureWALFile)) {
            return false;
        }
        return this.compareTo((ProcedureWALFile)o) == 0;
    }

    public int hashCode() {
        return this.logFile.hashCode();
    }

    public String toString() {
        return this.logFile.toString();
    }
}

