/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionStateListener;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.namespace.NamespaceAuditor;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterQuotaManager
implements RegionStateListener {
    private static final Log LOG = LogFactory.getLog(MasterQuotaManager.class);
    private static final Map<HRegionInfo, Long> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private final MasterServices masterServices;
    private NamedLock<String> namespaceLocks;
    private NamedLock<TableName> tableLocks;
    private NamedLock<String> userLocks;
    private boolean initialized = false;
    private NamespaceAuditor namespaceQuotaManager;
    private ConcurrentHashMap<HRegionInfo, SizeSnapshotWithTimestamp> regionSizes;

    public MasterQuotaManager(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    public void start() throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.masterServices.getConfiguration())) {
            LOG.info((Object)"Quota support disabled");
            return;
        }
        if (!MetaTableAccessor.tableExists(this.masterServices.getConnection(), QuotaUtil.QUOTA_TABLE_NAME)) {
            LOG.info((Object)"Quota table not found. Creating...");
            this.createQuotaTable();
        }
        LOG.info((Object)"Initializing quota support");
        this.namespaceLocks = new NamedLock();
        this.tableLocks = new NamedLock();
        this.userLocks = new NamedLock();
        this.regionSizes = new ConcurrentHashMap();
        this.namespaceQuotaManager = new NamespaceAuditor(this.masterServices);
        this.namespaceQuotaManager.start();
        this.initialized = true;
    }

    public void stop() {
    }

    public boolean isQuotaInitialized() {
        return this.initialized && this.namespaceQuotaManager.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterProtos.SetQuotaResponse setQuota(MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.checkQuotaSupport();
        if (req.hasUserName()) {
            this.userLocks.lock(req.getUserName());
            try {
                if (req.hasTableName()) {
                    this.setUserQuota(req.getUserName(), ProtobufUtil.toTableName(req.getTableName()), req);
                }
                if (req.hasNamespace()) {
                    this.setUserQuota(req.getUserName(), req.getNamespace(), req);
                }
                this.setUserQuota(req.getUserName(), req);
            }
            finally {
                this.userLocks.unlock(req.getUserName());
            }
        } else if (req.hasTableName()) {
            TableName table = ProtobufUtil.toTableName(req.getTableName());
            this.tableLocks.lock(table);
            try {
                this.setTableQuota(table, req);
            }
            finally {
                this.tableLocks.unlock(table);
            }
        } else if (req.hasNamespace()) {
            this.namespaceLocks.lock(req.getNamespace());
            try {
                this.setNamespaceQuota(req.getNamespace(), req);
            }
            finally {
                this.namespaceLocks.unlock(req.getNamespace());
            }
        } else {
            throw new DoNotRetryIOException(new UnsupportedOperationException("a user, a table or a namespace must be specified"));
        }
        return MasterProtos.SetQuotaResponse.newBuilder().build();
    }

    public void setUserQuota(final String userName, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetUserQuota(userName, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetUserQuota(userName, quotas);
            }
        });
    }

    public void setUserQuota(final String userName, final TableName table, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, table);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, table, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, table);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetUserQuota(userName, table, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetUserQuota(userName, table, quotas);
            }
        });
    }

    public void setUserQuota(final String userName, final String namespace, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, namespace);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, namespace, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, namespace);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetUserQuota(userName, namespace, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetUserQuota(userName, namespace, quotas);
            }
        });
    }

    public void setTableQuota(final TableName table, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getTableQuota(MasterQuotaManager.this.masterServices.getConnection(), table);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addTableQuota(MasterQuotaManager.this.masterServices.getConnection(), table, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteTableQuota(MasterQuotaManager.this.masterServices.getConnection(), table);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetTableQuota(table, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetTableQuota(table, quotas);
            }
        });
    }

    public void setNamespaceQuota(final String namespace, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getNamespaceQuota(MasterQuotaManager.this.masterServices.getConnection(), namespace);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addNamespaceQuota(MasterQuotaManager.this.masterServices.getConnection(), namespace, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteNamespaceQuota(MasterQuotaManager.this.masterServices.getConnection(), namespace);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetNamespaceQuota(namespace, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetNamespaceQuota(namespace, quotas);
            }
        });
    }

    public void setNamespaceQuota(NamespaceDescriptor desc) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.addNamespace(desc);
        }
    }

    public void removeNamespaceQuota(String namespace) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.deleteNamespace(namespace);
        }
    }

    private void setQuota(MasterProtos.SetQuotaRequest req, SetQuotaOperations quotaOps) throws IOException, InterruptedException {
        QuotaProtos.Quotas.Builder builder;
        if (req.hasRemoveAll() && req.getRemoveAll()) {
            quotaOps.preApply(null);
            quotaOps.delete();
            quotaOps.postApply(null);
            return;
        }
        QuotaProtos.Quotas quotas = quotaOps.fetch();
        quotaOps.preApply(quotas);
        QuotaProtos.Quotas.Builder builder2 = builder = quotas != null ? quotas.toBuilder() : QuotaProtos.Quotas.newBuilder();
        if (req.hasThrottle()) {
            this.applyThrottle(builder, req.getThrottle());
        }
        if (req.hasBypassGlobals()) {
            this.applyBypassGlobals(builder, req.getBypassGlobals());
        }
        if (req.hasSpaceLimit()) {
            this.applySpaceLimit(builder, req.getSpaceLimit());
        }
        if (QuotaUtil.isEmptyQuota(quotas = builder.build())) {
            quotaOps.delete();
        } else {
            quotaOps.update(quotas);
        }
        quotaOps.postApply(quotas);
    }

    public void checkNamespaceTableAndRegionQuota(TableName tName, int regions) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.checkQuotaToCreateTable(tName, regions);
        }
    }

    public void checkAndUpdateNamespaceRegionQuota(TableName tName, int regions) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.checkQuotaToUpdateRegion(tName, regions);
        }
    }

    public int getRegionCountOfTable(TableName tName) throws IOException {
        if (this.initialized) {
            return this.namespaceQuotaManager.getRegionCountOfTable(tName);
        }
        return -1;
    }

    @Override
    public void onRegionMerged(HRegionInfo mergedRegion) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.updateQuotaForRegionMerge(mergedRegion);
        }
    }

    @Override
    public void onRegionSplit(HRegionInfo hri) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.checkQuotaToSplitRegion(hri);
        }
    }

    public void removeTableFromNamespaceQuota(TableName tName) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.removeFromNamespaceUsage(tName);
        }
    }

    public NamespaceAuditor getNamespaceQuotaManager() {
        return this.namespaceQuotaManager;
    }

    private void applyThrottle(QuotaProtos.Quotas.Builder quotas, QuotaProtos.ThrottleRequest req) throws IOException {
        if (req.hasType() && (req.hasTimedQuota() || quotas.hasThrottle())) {
            if (req.hasTimedQuota()) {
                this.validateTimedQuota(req.getTimedQuota());
            }
            QuotaProtos.Throttle.Builder throttle = quotas.hasThrottle() ? quotas.getThrottle().toBuilder() : QuotaProtos.Throttle.newBuilder();
            switch (req.getType()) {
                case REQUEST_NUMBER: {
                    if (req.hasTimedQuota()) {
                        throttle.setReqNum(req.getTimedQuota());
                        break;
                    }
                    throttle.clearReqNum();
                    break;
                }
                case REQUEST_SIZE: {
                    if (req.hasTimedQuota()) {
                        throttle.setReqSize(req.getTimedQuota());
                        break;
                    }
                    throttle.clearReqSize();
                    break;
                }
                case WRITE_NUMBER: {
                    if (req.hasTimedQuota()) {
                        throttle.setWriteNum(req.getTimedQuota());
                        break;
                    }
                    throttle.clearWriteNum();
                    break;
                }
                case WRITE_SIZE: {
                    if (req.hasTimedQuota()) {
                        throttle.setWriteSize(req.getTimedQuota());
                        break;
                    }
                    throttle.clearWriteSize();
                    break;
                }
                case READ_NUMBER: {
                    if (req.hasTimedQuota()) {
                        throttle.setReadNum(req.getTimedQuota());
                        break;
                    }
                    throttle.clearReqNum();
                    break;
                }
                case READ_SIZE: {
                    if (req.hasTimedQuota()) {
                        throttle.setReadSize(req.getTimedQuota());
                        break;
                    }
                    throttle.clearReadSize();
                }
            }
            quotas.setThrottle(throttle.build());
        } else {
            quotas.clearThrottle();
        }
    }

    private void applyBypassGlobals(QuotaProtos.Quotas.Builder quotas, boolean bypassGlobals) {
        if (bypassGlobals) {
            quotas.setBypassGlobals(bypassGlobals);
        } else {
            quotas.clearBypassGlobals();
        }
    }

    void applySpaceLimit(QuotaProtos.Quotas.Builder quotas, QuotaProtos.SpaceLimitRequest req) {
        if (req.hasQuota()) {
            QuotaProtos.SpaceQuota spaceQuota = req.getQuota();
            if (spaceQuota.getRemove()) {
                quotas.setSpace(QuotaProtos.SpaceQuota.getDefaultInstance());
            } else {
                this.applySpaceQuota(quotas, req.getQuota());
            }
        }
    }

    void applySpaceQuota(QuotaProtos.Quotas.Builder quotas, QuotaProtos.SpaceQuota quota) {
        QuotaProtos.SpaceQuota.Builder builder = quotas.hasSpace() ? quotas.getSpace().toBuilder() : QuotaProtos.SpaceQuota.newBuilder();
        quotas.setSpace(builder.mergeFrom(quota).build());
    }

    private void validateTimedQuota(QuotaProtos.TimedQuota timedQuota) throws IOException {
        if (timedQuota.getSoftLimit() < 1L) {
            throw new DoNotRetryIOException(new UnsupportedOperationException("The throttle limit must be greater then 0, got " + timedQuota.getSoftLimit()));
        }
    }

    private void checkQuotaSupport() throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.masterServices.getConfiguration())) {
            throw new DoNotRetryIOException(new UnsupportedOperationException("quota support disabled"));
        }
        if (!this.initialized) {
            long maxWaitTime = this.masterServices.getConfiguration().getLong("hbase.master.wait.for.quota.manager.init", 30000L);
            long startTime = EnvironmentEdgeManager.currentTime();
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while waiting for Quota Manager to be initialized.");
                    break;
                }
            } while (!this.initialized && EnvironmentEdgeManager.currentTime() - startTime < maxWaitTime);
            if (!this.initialized) {
                throw new IOException("Quota manager is uninitialized, please retry later.");
            }
        }
    }

    private void createQuotaTable() throws IOException {
        this.masterServices.createSystemTable(QuotaUtil.QUOTA_TABLE_DESC);
    }

    @Override
    public void onRegionSplitReverted(HRegionInfo hri) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.removeRegionFromNamespaceUsage(hri);
        }
    }

    @VisibleForTesting
    void initializeRegionSizes() {
        assert (this.regionSizes == null);
        this.regionSizes = new ConcurrentHashMap();
    }

    public void addRegionSize(HRegionInfo hri, long size, long time) {
        if (this.regionSizes == null) {
            return;
        }
        this.regionSizes.put(hri, new SizeSnapshotWithTimestamp(size, time));
    }

    public Map<HRegionInfo, Long> snapshotRegionSizes() {
        if (this.regionSizes == null) {
            return EMPTY_MAP;
        }
        HashMap<HRegionInfo, Long> copy = new HashMap<HRegionInfo, Long>();
        for (Map.Entry<HRegionInfo, SizeSnapshotWithTimestamp> entry : this.regionSizes.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().getSize());
        }
        return copy;
    }

    int pruneEntriesOlderThan(long timeToPruneBefore) {
        if (this.regionSizes == null) {
            return 0;
        }
        int numEntriesRemoved = 0;
        Iterator<Map.Entry<HRegionInfo, SizeSnapshotWithTimestamp>> iterator = this.regionSizes.entrySet().iterator();
        while (iterator.hasNext()) {
            long currentEntryTime = iterator.next().getValue().getTime();
            if (currentEntryTime >= timeToPruneBefore) continue;
            iterator.remove();
            ++numEntriesRemoved;
        }
        return numEntriesRemoved;
    }

    private static class SizeSnapshotWithTimestamp {
        private final long size;
        private final long time;

        public SizeSnapshotWithTimestamp(long size, long time) {
            this.size = size;
            this.time = time;
        }

        public long getSize() {
            return this.size;
        }

        public long getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (o instanceof SizeSnapshotWithTimestamp) {
                SizeSnapshotWithTimestamp other = (SizeSnapshotWithTimestamp)o;
                return this.size == other.size && this.time == other.time;
            }
            return false;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            return hcb.append(this.size).append(this.time).toHashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("SizeSnapshotWithTimestamp={size=").append(this.size).append("B, ");
            sb.append("time=").append(this.time).append("}");
            return sb.toString();
        }
    }

    private static class NamedLock<T> {
        private HashSet<T> locks = new HashSet();

        private NamedLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(T name) throws InterruptedException {
            HashSet<T> hashSet = this.locks;
            synchronized (hashSet) {
                while (this.locks.contains(name)) {
                    this.locks.wait();
                }
                this.locks.add(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(T name) {
            HashSet<T> hashSet = this.locks;
            synchronized (hashSet) {
                this.locks.remove(name);
                this.locks.notifyAll();
            }
        }
    }

    private static interface SetQuotaOperations {
        public QuotaProtos.Quotas fetch() throws IOException;

        public void delete() throws IOException;

        public void update(QuotaProtos.Quotas var1) throws IOException;

        public void preApply(QuotaProtos.Quotas var1) throws IOException;

        public void postApply(QuotaProtos.Quotas var1) throws IOException;
    }
}

