/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterSpaceQuotaObserver
implements MasterObserver {
    public static final String REMOVE_QUOTA_ON_TABLE_DELETE = "hbase.quota.remove.on.table.delete";
    public static final boolean REMOVE_QUOTA_ON_TABLE_DELETE_DEFAULT = true;
    private CoprocessorEnvironment cpEnv;
    private Configuration conf;
    private boolean quotasEnabled = false;

    @Override
    public void start(CoprocessorEnvironment ctx) throws IOException {
        this.cpEnv = ctx;
        this.conf = this.cpEnv.getConfiguration();
        this.quotasEnabled = QuotaUtil.isQuotaEnabled(this.conf);
    }

    @Override
    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (!this.quotasEnabled) {
            return;
        }
        MasterServices master = ctx.getEnvironment().getMasterServices();
        Connection conn = master.getConnection();
        QuotaProtos.Quotas quotas = QuotaUtil.getTableQuota(master.getConnection(), tableName);
        if (quotas != null && quotas.hasSpace()) {
            QuotaSettings settings = QuotaSettingsFactory.removeTableSpaceLimit(tableName);
            try (Admin admin = conn.getAdmin();){
                admin.setQuota(settings);
            }
        }
    }

    @Override
    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (!this.quotasEnabled) {
            return;
        }
        MasterServices master = ctx.getEnvironment().getMasterServices();
        Connection conn = master.getConnection();
        QuotaProtos.Quotas quotas = QuotaUtil.getNamespaceQuota(master.getConnection(), namespace);
        if (quotas != null && quotas.hasSpace()) {
            QuotaSettings settings = QuotaSettingsFactory.removeNamespaceSpaceLimit(namespace);
            try (Admin admin = conn.getAdmin();){
                admin.setQuota(settings);
            }
        }
    }
}

