/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.ByteBufferChunkCell;
import org.apache.hadoop.hbase.regionserver.CellFlatMap;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CellChunkMap
extends CellFlatMap {
    private final Chunk[] chunks;
    private final int numOfCellsInsideChunk;
    public static final int SIZEOF_CELL_REP = 20;

    public CellChunkMap(Comparator<? super Cell> comparator, Chunk[] chunks, int min, int max, boolean descending) {
        super(comparator, min, max, descending);
        this.chunks = chunks;
        this.numOfCellsInsideChunk = (ChunkCreator.getInstance().getChunkSize() - 4) / 20;
    }

    @Override
    protected CellFlatMap createSubCellFlatMap(int min, int max, boolean descending) {
        return new CellChunkMap(this.comparator(), this.chunks, min, max, descending);
    }

    @Override
    protected Cell getCell(int i) {
        int chunkIndex = i / this.numOfCellsInsideChunk;
        ByteBuffer block = this.chunks[chunkIndex].getData();
        int j = i - chunkIndex * this.numOfCellsInsideChunk;
        int offsetInBytes = 4 + j * 20;
        int chunkId = ByteBufferUtils.toInt(block, offsetInBytes);
        Chunk chunk = ChunkCreator.getInstance().getChunk(chunkId);
        if (chunk == null) assert (false);
        int offsetOfCell = ByteBufferUtils.toInt(block, offsetInBytes + 4);
        int lengthOfCell = ByteBufferUtils.toInt(block, offsetInBytes + 8);
        long cellSeqID = ByteBufferUtils.toLong(block, offsetInBytes + 12);
        ByteBuffer buf = chunk.getData();
        if (buf == null) assert (false);
        return new ByteBufferChunkCell(buf, offsetOfCell, lengthOfCell, cellSeqID);
    }
}

