/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.SplitRequest;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.throttle.CompactionThroughputControllerFactory;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.StealJobQueue;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompactSplit
implements PropagatingConfigurationObserver {
    private static final Log LOG = LogFactory.getLog(CompactSplit.class);
    public static final String LARGE_COMPACTION_THREADS = "hbase.regionserver.thread.compaction.large";
    public static final int LARGE_COMPACTION_THREADS_DEFAULT = 1;
    public static final String SMALL_COMPACTION_THREADS = "hbase.regionserver.thread.compaction.small";
    public static final int SMALL_COMPACTION_THREADS_DEFAULT = 1;
    public static final String SPLIT_THREADS = "hbase.regionserver.thread.split";
    public static final int SPLIT_THREADS_DEFAULT = 1;
    public static final String REGION_SERVER_REGION_SPLIT_LIMIT = "hbase.regionserver.regionSplitLimit";
    public static final int DEFAULT_REGION_SERVER_REGION_SPLIT_LIMIT = 1000;
    private final HRegionServer server;
    private final Configuration conf;
    private final ThreadPoolExecutor longCompactions;
    private final ThreadPoolExecutor shortCompactions;
    private final ThreadPoolExecutor splits;
    private volatile ThroughputController compactionThroughputController;
    private int regionSplitLimit;
    private static final Comparator<Runnable> COMPARATOR = new Comparator<Runnable>(){

        @Override
        private int compare(CompactionRequest r1, CompactionRequest r2) {
            if (r1 == r2) {
                return 0;
            }
            int cmp = Integer.compare(r1.getPriority(), r2.getPriority());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Long.compare(r1.getSelectionNanoTime(), r2.getSelectionNanoTime());
            if (cmp != 0) {
                return cmp;
            }
            return System.identityHashCode(r1) - System.identityHashCode(r2);
        }

        @Override
        public int compare(Runnable r1, Runnable r2) {
            if (r1 instanceof CompactionRunner) {
                if (!(r2 instanceof CompactionRunner)) {
                    return -1;
                }
            } else {
                if (r2 instanceof CompactionRunner) {
                    return 1;
                }
                return System.identityHashCode(r1) - System.identityHashCode(r2);
            }
            CompactionRunner o1 = (CompactionRunner)r1;
            CompactionRunner o2 = (CompactionRunner)r2;
            int cmp = Integer.compare(o1.queuedPriority, o2.queuedPriority);
            if (cmp != 0) {
                return cmp;
            }
            Optional c1 = o1.compaction;
            Optional c2 = o2.compaction;
            if (c1.isPresent()) {
                return c2.isPresent() ? this.compare(((CompactionContext)c1.get()).getRequest(), ((CompactionContext)c2.get()).getRequest()) : -1;
            }
            return c2.isPresent() ? 1 : 0;
        }
    };

    CompactSplit(HRegionServer server) {
        this.server = server;
        this.conf = server.getConfiguration();
        this.regionSplitLimit = this.conf.getInt(REGION_SERVER_REGION_SPLIT_LIMIT, 1000);
        int largeThreads = Math.max(1, this.conf.getInt(LARGE_COMPACTION_THREADS, 1));
        int smallThreads = this.conf.getInt(SMALL_COMPACTION_THREADS, 1);
        int splitThreads = this.conf.getInt(SPLIT_THREADS, 1);
        Preconditions.checkArgument(largeThreads > 0 && smallThreads > 0);
        final String n = Thread.currentThread().getName();
        StealJobQueue<Runnable> stealJobQueue = new StealJobQueue<Runnable>(COMPARATOR);
        this.longCompactions = new ThreadPoolExecutor(largeThreads, largeThreads, 60L, TimeUnit.SECONDS, stealJobQueue, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = n + "-longCompactions-" + System.currentTimeMillis();
                return new Thread(r, name);
            }
        });
        this.longCompactions.setRejectedExecutionHandler(new Rejection());
        this.longCompactions.prestartAllCoreThreads();
        this.shortCompactions = new ThreadPoolExecutor(smallThreads, smallThreads, 60L, TimeUnit.SECONDS, stealJobQueue.getStealFromQueue(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = n + "-shortCompactions-" + System.currentTimeMillis();
                return new Thread(r, name);
            }
        });
        this.shortCompactions.setRejectedExecutionHandler(new Rejection());
        this.splits = (ThreadPoolExecutor)Executors.newFixedThreadPool(splitThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = n + "-splits-" + System.currentTimeMillis();
                return new Thread(r, name);
            }
        });
        this.compactionThroughputController = CompactionThroughputControllerFactory.create(server, this.conf);
    }

    public String toString() {
        return "compaction_queue=(" + this.longCompactions.getQueue().size() + ":" + this.shortCompactions.getQueue().size() + "), split_queue=" + this.splits.getQueue().size();
    }

    public String dumpQueue() {
        StringBuffer queueLists = new StringBuffer();
        queueLists.append("Compaction/Split Queue dump:\n");
        queueLists.append("  LargeCompation Queue:\n");
        BlockingQueue<Runnable> lq = this.longCompactions.getQueue();
        Iterator it = lq.iterator();
        while (it.hasNext()) {
            queueLists.append("    " + ((Runnable)it.next()).toString());
            queueLists.append("\n");
        }
        if (this.shortCompactions != null) {
            queueLists.append("\n");
            queueLists.append("  SmallCompation Queue:\n");
            lq = this.shortCompactions.getQueue();
            it = lq.iterator();
            while (it.hasNext()) {
                queueLists.append("    " + ((Runnable)it.next()).toString());
                queueLists.append("\n");
            }
        }
        queueLists.append("\n");
        queueLists.append("  Split Queue:\n");
        lq = this.splits.getQueue();
        it = lq.iterator();
        while (it.hasNext()) {
            queueLists.append("    " + ((Runnable)it.next()).toString());
            queueLists.append("\n");
        }
        return queueLists.toString();
    }

    public synchronized boolean requestSplit(Region r) {
        byte[] midKey;
        if (this.shouldSplitRegion() && ((HRegion)r).getCompactPriority() >= 1 && (midKey = ((HRegion)r).checkSplit()) != null) {
            this.requestSplit(r, midKey);
            return true;
        }
        return false;
    }

    public synchronized void requestSplit(Region r, byte[] midKey) {
        this.requestSplit(r, midKey, null);
    }

    public synchronized void requestSplit(Region r, byte[] midKey, User user) {
        if (midKey == null) {
            LOG.debug((Object)("Region " + r.getRegionInfo().getRegionNameAsString() + " not splittable because midkey=null"));
            if (((HRegion)r).shouldForceSplit()) {
                ((HRegion)r).clearSplit();
            }
            return;
        }
        try {
            this.splits.execute(new SplitRequest(r, midKey, this.server, user));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Splitting " + r + ", " + this));
            }
        }
        catch (RejectedExecutionException ree) {
            LOG.info((Object)("Could not execute split for " + r), (Throwable)ree);
        }
    }

    public synchronized void requestCompaction(HRegion region, String why, int priority, CompactionLifeCycleTracker tracker, User user) throws IOException {
        this.requestCompactionInternal(region, why, priority, true, tracker, user);
    }

    public synchronized void requestCompaction(HRegion region, HStore store, String why, int priority, CompactionLifeCycleTracker tracker, User user) throws IOException {
        this.requestCompactionInternal(region, store, why, priority, true, tracker, user);
    }

    private void requestCompactionInternal(HRegion region, String why, int priority, boolean selectNow, CompactionLifeCycleTracker tracker, User user) throws IOException {
        for (HStore store : region.stores.values()) {
            this.requestCompactionInternal(region, store, why, priority, selectNow, tracker, user);
        }
    }

    private void requestCompactionInternal(HRegion region, HStore store, String why, int priority, boolean selectNow, CompactionLifeCycleTracker tracker, User user) throws IOException {
        RegionServerSpaceQuotaManager spaceQuotaManager;
        Optional<Object> compaction;
        if (this.server.isStopped() || region.getTableDescriptor() != null && !region.getTableDescriptor().isCompactionEnabled()) {
            return;
        }
        if (selectNow) {
            compaction = this.selectCompaction(region, store, priority, tracker, user);
            if (!compaction.isPresent()) {
                return;
            }
        } else {
            compaction = Optional.empty();
        }
        if ((spaceQuotaManager = this.server.getRegionServerSpaceQuotaManager()) != null && spaceQuotaManager.areCompactionsDisabled(region.getTableDescriptor().getTableName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignoring compaction request for " + region + " as an active space quota violation  policy disallows compactions."));
            }
            return;
        }
        ThreadPoolExecutor pool = selectNow ? (store.throttleCompaction(((CompactionContext)compaction.get()).getRequest().getSize()) ? this.longCompactions : this.shortCompactions) : this.shortCompactions;
        pool.execute(new CompactionRunner(store, region, compaction, pool, user));
        region.incrementCompactionsQueuedCount();
        if (LOG.isDebugEnabled()) {
            String type = pool == this.shortCompactions ? "Small " : "Large ";
            LOG.debug((Object)(type + "Compaction requested: " + (selectNow ? compaction.toString() : "system") + (why != null && !why.isEmpty() ? "; Because: " + why : "") + "; " + this));
        }
    }

    public synchronized void requestSystemCompaction(HRegion region, String why) throws IOException {
        this.requestCompactionInternal(region, why, Integer.MIN_VALUE, false, CompactionLifeCycleTracker.DUMMY, null);
    }

    public synchronized void requestSystemCompaction(HRegion region, HStore store, String why) throws IOException {
        this.requestCompactionInternal(region, store, why, Integer.MIN_VALUE, false, CompactionLifeCycleTracker.DUMMY, null);
    }

    private Optional<CompactionContext> selectCompaction(HRegion region, HStore store, int priority, CompactionLifeCycleTracker tracker, User user) throws IOException {
        Optional<CompactionContext> compaction = store.requestCompaction(priority, tracker, user);
        if (!compaction.isPresent() && LOG.isDebugEnabled() && region.getRegionInfo() != null) {
            LOG.debug((Object)("Not compacting " + region.getRegionInfo().getRegionNameAsString() + " because compaction request was cancelled"));
        }
        return compaction;
    }

    void interruptIfNecessary() {
        this.splits.shutdown();
        this.longCompactions.shutdown();
        this.shortCompactions.shutdown();
    }

    private void waitFor(ThreadPoolExecutor t, String name) {
        boolean done = false;
        while (!done) {
            try {
                done = t.awaitTermination(60L, TimeUnit.SECONDS);
                LOG.info((Object)("Waiting for " + name + " to finish..."));
                if (done) continue;
                t.shutdownNow();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Interrupted waiting for " + name + " to finish..."));
            }
        }
    }

    void join() {
        this.waitFor(this.splits, "Split Thread");
        this.waitFor(this.longCompactions, "Large Compaction Thread");
        this.waitFor(this.shortCompactions, "Small Compaction Thread");
    }

    public int getCompactionQueueSize() {
        return this.longCompactions.getQueue().size() + this.shortCompactions.getQueue().size();
    }

    public int getLargeCompactionQueueSize() {
        return this.longCompactions.getQueue().size();
    }

    public int getSmallCompactionQueueSize() {
        return this.shortCompactions.getQueue().size();
    }

    public int getSplitQueueSize() {
        return this.splits.getQueue().size();
    }

    private boolean shouldSplitRegion() {
        if ((double)this.server.getNumberOfOnlineRegions() > 0.9 * (double)this.regionSplitLimit) {
            LOG.warn((Object)("Total number of regions is approaching the upper limit " + this.regionSplitLimit + ". Please consider taking a look at http://hbase.apache.org/book.html#ops.regionmgt"));
        }
        return this.regionSplitLimit > this.server.getNumberOfOnlineRegions();
    }

    public int getRegionSplitLimit() {
        return this.regionSplitLimit;
    }

    @Override
    public void onConfigurationChange(Configuration newConf) {
        ThroughputController old;
        int largeThreads = Math.max(1, newConf.getInt(LARGE_COMPACTION_THREADS, 1));
        if (this.longCompactions.getCorePoolSize() != largeThreads) {
            LOG.info((Object)("Changing the value of hbase.regionserver.thread.compaction.large from " + this.longCompactions.getCorePoolSize() + " to " + largeThreads));
            if (this.longCompactions.getCorePoolSize() < largeThreads) {
                this.longCompactions.setMaximumPoolSize(largeThreads);
                this.longCompactions.setCorePoolSize(largeThreads);
            } else {
                this.longCompactions.setCorePoolSize(largeThreads);
                this.longCompactions.setMaximumPoolSize(largeThreads);
            }
        }
        int smallThreads = newConf.getInt(SMALL_COMPACTION_THREADS, 1);
        if (this.shortCompactions.getCorePoolSize() != smallThreads) {
            LOG.info((Object)("Changing the value of hbase.regionserver.thread.compaction.small from " + this.shortCompactions.getCorePoolSize() + " to " + smallThreads));
            if (this.shortCompactions.getCorePoolSize() < smallThreads) {
                this.shortCompactions.setMaximumPoolSize(smallThreads);
                this.shortCompactions.setCorePoolSize(smallThreads);
            } else {
                this.shortCompactions.setCorePoolSize(smallThreads);
                this.shortCompactions.setMaximumPoolSize(smallThreads);
            }
        }
        int splitThreads = newConf.getInt(SPLIT_THREADS, 1);
        if (this.splits.getCorePoolSize() != splitThreads) {
            LOG.info((Object)("Changing the value of hbase.regionserver.thread.split from " + this.splits.getCorePoolSize() + " to " + splitThreads));
            if (this.splits.getCorePoolSize() < splitThreads) {
                this.splits.setMaximumPoolSize(splitThreads);
                this.splits.setCorePoolSize(splitThreads);
            } else {
                this.splits.setCorePoolSize(splitThreads);
                this.splits.setMaximumPoolSize(splitThreads);
            }
        }
        if ((old = this.compactionThroughputController) != null) {
            old.stop("configuration change");
        }
        this.compactionThroughputController = CompactionThroughputControllerFactory.create(this.server, newConf);
        this.conf.reloadConfiguration();
    }

    protected int getSmallCompactionThreadNum() {
        return this.shortCompactions.getCorePoolSize();
    }

    protected int getLargeCompactionThreadNum() {
        return this.longCompactions.getCorePoolSize();
    }

    protected int getSplitThreadNum() {
        return this.splits.getCorePoolSize();
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
    }

    @VisibleForTesting
    public ThroughputController getCompactionThroughputController() {
        return this.compactionThroughputController;
    }

    @VisibleForTesting
    void shutdownLongCompactions() {
        this.longCompactions.shutdown();
    }

    public void clearLongCompactionsQueue() {
        this.longCompactions.getQueue().clear();
    }

    public void clearShortCompactionsQueue() {
        this.shortCompactions.getQueue().clear();
    }

    private static class Rejection
    implements RejectedExecutionHandler {
        private Rejection() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor pool) {
            if (runnable instanceof CompactionRunner) {
                CompactionRunner runner = (CompactionRunner)runnable;
                LOG.debug((Object)("Compaction Rejected: " + runner));
                runner.compaction.ifPresent(c -> runner.store.cancelRequestedCompaction((CompactionContext)c));
            }
        }
    }

    private final class CompactionRunner
    implements Runnable {
        private final HStore store;
        private final HRegion region;
        private final Optional<CompactionContext> compaction;
        private int queuedPriority;
        private ThreadPoolExecutor parent;
        private User user;
        private long time;

        public CompactionRunner(HStore store, HRegion region, Optional<CompactionContext> compaction, ThreadPoolExecutor parent, User user) {
            this.store = store;
            this.region = region;
            this.compaction = compaction;
            this.queuedPriority = compaction.isPresent() ? compaction.get().getRequest().getPriority() : store.getCompactPriority();
            this.parent = parent;
            this.user = user;
            this.time = System.currentTimeMillis();
        }

        public String toString() {
            return this.compaction.map(c -> "Request = " + c.getRequest()).orElse("regionName = " + this.region.toString() + ", storeName = " + this.store.toString() + ", priority = " + this.queuedPriority + ", time = " + this.time);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCompaction(User user) {
            CompactionContext c;
            if (!this.compaction.isPresent()) {
                ThreadPoolExecutor pool;
                Optional selected;
                int oldPriority = this.queuedPriority;
                this.queuedPriority = this.store.getCompactPriority();
                if (this.queuedPriority > oldPriority) {
                    this.parent.execute(this);
                    return;
                }
                try {
                    selected = CompactSplit.this.selectCompaction(this.region, this.store, this.queuedPriority, CompactionLifeCycleTracker.DUMMY, user);
                }
                catch (IOException ex) {
                    LOG.error((Object)("Compaction selection failed " + this), (Throwable)ex);
                    CompactSplit.this.server.checkFileSystem();
                    this.region.decrementCompactionsQueuedCount();
                    return;
                }
                if (!selected.isPresent()) {
                    this.region.decrementCompactionsQueuedCount();
                    return;
                }
                c = (CompactionContext)selected.get();
                assert (c.hasSelection());
                ThreadPoolExecutor threadPoolExecutor = pool = this.store.throttleCompaction(c.getRequest().getSize()) ? CompactSplit.this.longCompactions : CompactSplit.this.shortCompactions;
                if (this.parent == CompactSplit.this.shortCompactions && pool == CompactSplit.this.longCompactions) {
                    this.store.cancelRequestedCompaction(c);
                    this.parent = pool;
                    this.parent.execute(this);
                    return;
                }
            } else {
                c = this.compaction.get();
            }
            assert (c != null);
            c.getRequest().getTracker().beforeExecute(this.store);
            try {
                long start = EnvironmentEdgeManager.currentTime();
                boolean completed = this.region.compact(c, this.store, CompactSplit.this.compactionThroughputController, user);
                long now = EnvironmentEdgeManager.currentTime();
                LOG.info((Object)((completed ? "Completed" : "Aborted") + " compaction: " + this + "; duration=" + StringUtils.formatTimeDiff(now, start)));
                if (completed) {
                    if (this.store.getCompactPriority() <= 0) {
                        CompactSplit.this.requestSystemCompaction(this.region, this.store, "Recursive enqueue");
                    } else {
                        CompactSplit.this.requestSplit(this.region);
                    }
                }
            }
            catch (IOException ex) {
                IOException remoteEx = ex instanceof RemoteException ? ((RemoteException)ex).unwrapRemoteException() : ex;
                LOG.error((Object)("Compaction failed " + this), (Throwable)remoteEx);
                if (remoteEx != ex) {
                    LOG.info((Object)("Compaction failed at original callstack: " + this.formatStackTrace(ex)));
                }
                this.region.reportCompactionRequestFailure();
                CompactSplit.this.server.checkFileSystem();
            }
            catch (Exception ex) {
                LOG.error((Object)("Compaction failed " + this), (Throwable)ex);
                this.region.reportCompactionRequestFailure();
                CompactSplit.this.server.checkFileSystem();
            }
            finally {
                c.getRequest().getTracker().afterExecute(this.store);
                this.region.decrementCompactionsQueuedCount();
                LOG.debug((Object)("CompactSplitThread Status: " + CompactSplit.this));
            }
        }

        @Override
        public void run() {
            Preconditions.checkNotNull(CompactSplit.this.server);
            if (CompactSplit.this.server.isStopped() || this.region.getTableDescriptor() != null && !this.region.getTableDescriptor().isCompactionEnabled()) {
                this.region.decrementCompactionsQueuedCount();
                return;
            }
            this.doCompaction(this.user);
        }

        private String formatStackTrace(Exception ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }
    }
}

