/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischargeHandler;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompactedHFilesDischarger
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(CompactedHFilesDischarger.class);
    private RegionServerServices regionServerServices;
    @VisibleForTesting
    private boolean useExecutor = true;

    public CompactedHFilesDischarger(int period, Stoppable stopper, RegionServerServices regionServerServices) {
        super("CompactedHFilesCleaner", stopper, period);
        this.regionServerServices = regionServerServices;
    }

    @VisibleForTesting
    public CompactedHFilesDischarger(int period, Stoppable stopper, RegionServerServices regionServerServices, boolean useExecutor) {
        this(period, stopper, regionServerServices);
        this.useExecutor = useExecutor;
    }

    @VisibleForTesting
    boolean setUseExecutor(boolean useExecutor) {
        boolean oldSetting = this.useExecutor;
        this.useExecutor = useExecutor;
        return oldSetting;
    }

    @Override
    public void chore() {
        if (this.regionServerServices == null) {
            return;
        }
        List<Region> onlineRegions = this.regionServerServices.getOnlineRegions();
        if (onlineRegions == null) {
            return;
        }
        for (Region region : onlineRegions) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Started compacted hfiles cleaner on " + region.getRegionInfo()));
            }
            for (Store store : region.getStores()) {
                try {
                    if (this.useExecutor && this.regionServerServices != null) {
                        CompactedHFilesDischargeHandler handler = new CompactedHFilesDischargeHandler(this.regionServerServices, EventType.RS_COMPACTED_FILES_DISCHARGER, (HStore)store);
                        this.regionServerServices.getExecutorService().submit(handler);
                    } else {
                        store.closeAndArchiveCompactedFiles();
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Completed archiving the compacted files for the region " + region.getRegionInfo() + " under the store " + store.getColumnFamilyName()));
                }
                catch (Exception e) {
                    LOG.error((Object)("Exception while trying to close and archive the compacted store files of the store  " + store.getColumnFamilyName() + " in the region " + region.getRegionInfo()), (Throwable)e);
                }
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Completed the compacted hfiles cleaner for the region " + region.getRegionInfo()));
        }
    }
}

