/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MemstoreSize;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DefaultMemStore
extends AbstractMemStore {
    private static final Log LOG = LogFactory.getLog(DefaultMemStore.class);
    public static final long DEEP_OVERHEAD = ClassSize.align(AbstractMemStore.DEEP_OVERHEAD);
    public static final long FIXED_OVERHEAD = ClassSize.align(AbstractMemStore.FIXED_OVERHEAD);

    public DefaultMemStore() {
        this(HBaseConfiguration.create(), CellComparator.COMPARATOR);
    }

    public DefaultMemStore(Configuration conf, CellComparator c) {
        super(conf, c);
    }

    @Override
    public MemStoreSnapshot snapshot() {
        if (!this.snapshot.isEmpty()) {
            LOG.warn((Object)"Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else {
            this.snapshotId = EnvironmentEdgeManager.currentTime();
            if (!this.active.isEmpty()) {
                ImmutableSegment immutableSegment;
                this.snapshot = immutableSegment = SegmentFactory.instance().createImmutableSegment(this.active);
                this.resetActive();
            }
        }
        return new MemStoreSnapshot(this.snapshotId, this.snapshot);
    }

    @Override
    public MemstoreSize getFlushableSize() {
        MemstoreSize snapshotSize = this.getSnapshotSize();
        return snapshotSize.getDataSize() > 0L ? snapshotSize : new MemstoreSize(this.keySize(), this.heapSize());
    }

    @Override
    protected long keySize() {
        return this.active.keySize();
    }

    @Override
    protected long heapSize() {
        return this.active.heapSize();
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPt) throws IOException {
        ArrayList<KeyValueScanner> list = new ArrayList<KeyValueScanner>();
        long order = this.snapshot.getNumOfSegments();
        order = DefaultMemStore.addToScanners(this.active, readPt, order, list);
        DefaultMemStore.addToScanners(this.snapshot.getAllSegments(), readPt, order, list);
        return list;
    }

    @Override
    protected List<Segment> getSegments() throws IOException {
        ArrayList<Segment> list = new ArrayList<Segment>(2);
        list.add(this.active);
        list.add(this.snapshot);
        return list;
    }

    Cell getNextRow(Cell cell) {
        return this.getLowest(this.getNextRow(cell, this.active.getCellSet()), this.getNextRow(cell, this.snapshot.getCellSet()));
    }

    @Override
    public void updateLowestUnflushedSequenceIdInWAL(boolean onlyIfMoreRecent) {
    }

    @Override
    public MemstoreSize size() {
        return new MemstoreSize(this.active.keySize(), this.active.heapSize());
    }

    @Override
    protected void checkActiveSize() {
    }

    @Override
    public long preFlushSeqIDEstimation() {
        return -1L;
    }

    @Override
    public boolean isSloppy() {
        return false;
    }

    public static void main(String[] args) {
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        DefaultMemStore memstore1 = new DefaultMemStore();
        int count = 10000;
        byte[] fam = Bytes.toBytes("col");
        byte[] qf = Bytes.toBytes("umn");
        byte[] empty = new byte[]{};
        MemstoreSize memstoreSize = new MemstoreSize();
        for (i = 0; i < 10000; ++i) {
            memstore1.add(new KeyValue(Bytes.toBytes(i), fam, qf, (long)i, empty), memstoreSize);
        }
        LOG.info((Object)("memstore1 estimated size=" + (memstoreSize.getDataSize() + memstoreSize.getHeapSize())));
        for (i = 0; i < 10000; ++i) {
            memstore1.add(new KeyValue(Bytes.toBytes(i), fam, qf, (long)i, empty), memstoreSize);
        }
        LOG.info((Object)("memstore1 estimated size (2nd loading of same data)=" + (memstoreSize.getDataSize() + memstoreSize.getHeapSize())));
        DefaultMemStore memstore2 = new DefaultMemStore();
        memstoreSize = new MemstoreSize();
        for (int i2 = 0; i2 < 10000; ++i2) {
            memstore2.add(new KeyValue(Bytes.toBytes(i2), fam, qf, (long)i2, new byte[i2]), memstoreSize);
        }
        LOG.info((Object)("memstore2 estimated size=" + (memstoreSize.getDataSize() + memstoreSize.getHeapSize())));
        int seconds = 30;
        LOG.info((Object)"Waiting 30 seconds while heap dump is taken");
        LOG.info((Object)"Exiting.");
    }
}

