/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class DefaultStoreFileManager
implements StoreFileManager {
    private static final Log LOG = LogFactory.getLog(DefaultStoreFileManager.class);
    private final CellComparator kvComparator;
    private final CompactionConfiguration comConf;
    private final int blockingFileCount;
    private final Comparator<StoreFile> storeFileComparator;
    private volatile ImmutableList<StoreFile> storefiles = null;
    private volatile List<StoreFile> compactedfiles = null;

    public DefaultStoreFileManager(CellComparator kvComparator, Comparator<StoreFile> storeFileComparator, Configuration conf, CompactionConfiguration comConf) {
        this.kvComparator = kvComparator;
        this.storeFileComparator = storeFileComparator;
        this.comConf = comConf;
        this.blockingFileCount = conf.getInt("hbase.hstore.blockingStoreFiles", 10);
    }

    @Override
    public void loadFiles(List<StoreFile> storeFiles) {
        this.sortAndSetStoreFiles(storeFiles);
    }

    @Override
    public final Collection<StoreFile> getStorefiles() {
        return this.storefiles;
    }

    @Override
    public Collection<StoreFile> getCompactedfiles() {
        return this.compactedfiles;
    }

    @Override
    public void insertNewFiles(Collection<StoreFile> sfs) throws IOException {
        ArrayList<StoreFile> newFiles = new ArrayList<StoreFile>(this.storefiles);
        newFiles.addAll(sfs);
        this.sortAndSetStoreFiles(newFiles);
    }

    @Override
    public ImmutableCollection<StoreFile> clearFiles() {
        ImmutableList<StoreFile> result = this.storefiles;
        this.storefiles = ImmutableList.of();
        return result;
    }

    @Override
    public Collection<StoreFile> clearCompactedFiles() {
        List<StoreFile> result = this.compactedfiles;
        this.compactedfiles = new ArrayList<StoreFile>();
        return result;
    }

    @Override
    public final int getStorefileCount() {
        return this.storefiles.size();
    }

    @Override
    public final int getCompactedFilesCount() {
        if (this.compactedfiles == null) {
            return 0;
        }
        return this.compactedfiles.size();
    }

    @Override
    public void addCompactionResults(Collection<StoreFile> newCompactedfiles, Collection<StoreFile> results) {
        ArrayList<StoreFile> newStoreFiles = Lists.newArrayList(this.storefiles);
        newStoreFiles.removeAll(newCompactedfiles);
        if (!results.isEmpty()) {
            newStoreFiles.addAll(results);
        }
        this.sortAndSetStoreFiles(newStoreFiles);
        ArrayList<StoreFile> updatedCompactedfiles = null;
        if (this.compactedfiles != null) {
            updatedCompactedfiles = new ArrayList<StoreFile>(this.compactedfiles);
            updatedCompactedfiles.addAll(newCompactedfiles);
        } else {
            updatedCompactedfiles = new ArrayList<StoreFile>(newCompactedfiles);
        }
        this.markCompactedAway(newCompactedfiles);
        this.compactedfiles = this.sortCompactedfiles(updatedCompactedfiles);
    }

    private void markCompactedAway(Collection<StoreFile> compactedFiles) {
        for (StoreFile file : compactedFiles) {
            file.markCompactedAway();
        }
    }

    @Override
    public void removeCompactedFiles(Collection<StoreFile> removedCompactedfiles) throws IOException {
        ArrayList<StoreFile> updatedCompactedfiles = null;
        if (this.compactedfiles != null) {
            updatedCompactedfiles = new ArrayList<StoreFile>(this.compactedfiles);
            updatedCompactedfiles.removeAll(removedCompactedfiles);
            this.compactedfiles = this.sortCompactedfiles(updatedCompactedfiles);
        }
    }

    @Override
    public final Iterator<StoreFile> getCandidateFilesForRowKeyBefore(KeyValue targetKey) {
        return new ArrayList<StoreFile>(Lists.reverse(this.storefiles)).iterator();
    }

    @Override
    public Iterator<StoreFile> updateCandidateFilesForRowKeyBefore(Iterator<StoreFile> candidateFiles, KeyValue targetKey, Cell candidate) {
        return candidateFiles;
    }

    @Override
    public final byte[] getSplitPoint() throws IOException {
        ImmutableList<StoreFile> storefiles = this.storefiles;
        if (storefiles.isEmpty()) {
            return null;
        }
        Optional<StoreFile> largestFile = StoreUtils.getLargestFile(storefiles);
        return largestFile.isPresent() ? (byte[])StoreUtils.getFileSplitPoint(largestFile.get(), this.kvComparator).orElse(null) : null;
    }

    @Override
    public final Collection<StoreFile> getFilesForScan(byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow) {
        return this.getStorefiles();
    }

    @Override
    public int getStoreCompactionPriority() {
        int priority = this.blockingFileCount - this.storefiles.size();
        return priority == 1 ? priority + 1 : priority;
    }

    @Override
    public Collection<StoreFile> getUnneededFiles(long maxTs, List<StoreFile> filesCompacting) {
        ArrayList<StoreFile> expiredStoreFiles = null;
        ImmutableList<StoreFile> files = this.storefiles;
        for (int i = 0; i < files.size() - 1; ++i) {
            StoreFile sf = (StoreFile)files.get(i);
            long fileTs = sf.getReader().getMaxTimestamp();
            if (fileTs >= maxTs || filesCompacting.contains(sf)) continue;
            LOG.info((Object)("Found an expired store file: " + sf.getPath() + " whose maxTimeStamp is " + fileTs + ", which is below " + maxTs));
            if (expiredStoreFiles == null) {
                expiredStoreFiles = new ArrayList<StoreFile>();
            }
            expiredStoreFiles.add(sf);
        }
        return expiredStoreFiles;
    }

    private void sortAndSetStoreFiles(List<StoreFile> storeFiles) {
        Collections.sort(storeFiles, this.storeFileComparator);
        this.storefiles = ImmutableList.copyOf(storeFiles);
    }

    private List<StoreFile> sortCompactedfiles(List<StoreFile> storefiles) {
        Collections.sort(storefiles, this.storeFileComparator);
        return new ArrayList<StoreFile>(storefiles);
    }

    @Override
    public double getCompactionPressure() {
        int minFilesToCompact;
        int storefileCount = this.getStorefileCount();
        if (storefileCount <= (minFilesToCompact = this.comConf.getMinFilesToCompact())) {
            return 0.0;
        }
        return (double)(storefileCount - minFilesToCompact) / (double)(this.blockingFileCount - minFilesToCompact);
    }

    @Override
    public Comparator<StoreFile> getStoreFileComparator() {
        return this.storeFileComparator;
    }
}

