/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DefaultStoreFlusher
extends StoreFlusher {
    private static final Log LOG = LogFactory.getLog(DefaultStoreFlusher.class);
    private final Object flushLock = new Object();

    public DefaultStoreFlusher(Configuration conf, Store store) {
        super(conf, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushId, MonitoredTask status, ThroughputController throughputController) throws IOException {
        StoreFileWriter writer;
        ArrayList<Path> result = new ArrayList<Path>();
        int cellsCount = snapshot.getCellsCount();
        if (cellsCount == 0) {
            return result;
        }
        long smallestReadPoint = this.store.getSmallestReadPoint();
        InternalScanner scanner = this.createScanner(snapshot.getScanners(), smallestReadPoint);
        if (scanner == null) {
            return result;
        }
        try {
            Object object = this.flushLock;
            synchronized (object) {
                status.setStatus("Flushing " + this.store + ": creating writer");
                writer = this.store.createWriterInTmp(cellsCount, this.store.getColumnFamilyDescriptor().getCompressionType(), false, true, snapshot.isTagsPresent(), false, snapshot.getTimeRangeTracker());
                IOException e = null;
                try {
                    this.performFlush(scanner, writer, smallestReadPoint, throughputController);
                }
                catch (IOException ioe) {
                    e = ioe;
                    throw ioe;
                }
                finally {
                    if (e != null) {
                        writer.close();
                    } else {
                        this.finalizeWriter(writer, cacheFlushId, status);
                    }
                }
            }
        }
        finally {
            scanner.close();
        }
        LOG.info((Object)("Flushed, sequenceid=" + cacheFlushId + ", memsize=" + StringUtils.TraditionalBinaryPrefix.long2String(snapshot.getDataSize(), "", 1) + ", hasBloomFilter=" + writer.hasGeneralBloom() + ", into tmp file " + writer.getPath()));
        result.add(writer.getPath());
        return result;
    }
}

