/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.FlushPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public abstract class FlushLargeStoresPolicy
extends FlushPolicy {
    private static final Log LOG = LogFactory.getLog(FlushLargeStoresPolicy.class);
    public static final String HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND = "hbase.hregion.percolumnfamilyflush.size.lower.bound";
    public static final String HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN = "hbase.hregion.percolumnfamilyflush.size.lower.bound.min";
    public static final long DEFAULT_HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN = 0x1000000L;
    protected long flushSizeLowerBound = -1L;

    protected long getFlushSizeLowerBound(HRegion region) {
        String flushedSizeLowerBoundString;
        int familyNumber = region.getTableDescriptor().getColumnFamilyCount();
        long flushSizeLowerBound = region.getMemstoreFlushSize() / (long)familyNumber;
        long minimumLowerBound = this.getConf().getLong(HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN, 0x1000000L);
        if (minimumLowerBound > flushSizeLowerBound) {
            flushSizeLowerBound = minimumLowerBound;
        }
        if ((flushedSizeLowerBoundString = region.getTableDescriptor().getValue(HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No hbase.hregion.percolumnfamilyflush.size.lower.bound set in description of table " + region.getTableDescriptor().getTableName() + ", use config (" + flushSizeLowerBound + ") instead"));
            }
        } else {
            try {
                flushSizeLowerBound = Long.parseLong(flushedSizeLowerBoundString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)("Number format exception when parsing hbase.hregion.percolumnfamilyflush.size.lower.bound for table " + region.getTableDescriptor().getTableName() + ":" + flushedSizeLowerBoundString + ". " + nfe + ", use config (" + flushSizeLowerBound + ") instead"));
            }
        }
        return flushSizeLowerBound;
    }

    protected boolean shouldFlush(HStore store) {
        if (store.getSizeOfMemStore().getDataSize() > this.flushSizeLowerBound) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Flush Column Family " + store.getColumnFamilyName() + " of " + this.region.getRegionInfo().getEncodedName() + " because memstoreSize=" + store.getSizeOfMemStore().getDataSize() + " > lower bound=" + this.flushSizeLowerBound));
            }
            return true;
        }
        return false;
    }
}

