/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.FailedArchiveException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.InvalidHFileException;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MemstoreSize;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ReversedStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ProtocolStringList;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HStore
implements Store {
    public static final String MEMSTORE_CLASS_NAME = "hbase.regionserver.memstore.class";
    public static final String COMPACTCHECKER_INTERVAL_MULTIPLIER_KEY = "hbase.server.compactchecker.interval.multiplier";
    public static final String BLOCKING_STOREFILES_KEY = "hbase.hstore.blockingStoreFiles";
    public static final String BLOCK_STORAGE_POLICY_KEY = "hbase.hstore.block.storage.policy";
    public static final String DEFAULT_BLOCK_STORAGE_POLICY = "HOT";
    public static final int DEFAULT_COMPACTCHECKER_INTERVAL_MULTIPLIER = 1000;
    public static final int DEFAULT_BLOCKING_STOREFILE_COUNT = 10;
    private static final Log LOG = LogFactory.getLog(HStore.class);
    protected final MemStore memstore;
    protected final HRegion region;
    private final ColumnFamilyDescriptor family;
    private final HRegionFileSystem fs;
    protected Configuration conf;
    protected CacheConfig cacheConf;
    private long lastCompactSize = 0L;
    volatile boolean forceMajor = false;
    static int closeCheckInterval = 0;
    private volatile long storeSize = 0L;
    private volatile long totalUncompressedBytes = 0L;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final ReentrantLock archiveLock = new ReentrantLock();
    private final boolean verifyBulkLoads;
    private ScanInfo scanInfo;
    final List<StoreFile> filesCompacting = Lists.newArrayList();
    private final Set<ChangedReadersObserver> changedReaderObservers = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final int blocksize;
    private HFileDataBlockEncoder dataBlockEncoder;
    protected ChecksumType checksumType;
    protected int bytesPerChecksum;
    protected final CellComparator comparator;
    final StoreEngine<?, ?, ?, ?> storeEngine;
    private static final AtomicBoolean offPeakCompactionTracker = new AtomicBoolean();
    private volatile OffPeakHours offPeakHours;
    private static final int DEFAULT_FLUSH_RETRIES_NUMBER = 10;
    private int flushRetriesNumber;
    private int pauseTime;
    private long blockingFileCount;
    private int compactionCheckMultiplier;
    protected Encryption.Context cryptoContext = Encryption.Context.NONE;
    private volatile long flushedCellsCount = 0L;
    private volatile long compactedCellsCount = 0L;
    private volatile long majorCompactedCellsCount = 0L;
    private volatile long flushedCellsSize = 0L;
    private volatile long flushedOutputFileSize = 0L;
    private volatile long compactedCellsSize = 0L;
    private volatile long majorCompactedCellsSize = 0L;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 17 * ClassSize.REFERENCE + 88 + 20 + 2);
    public static final long DEEP_OVERHEAD = ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)ClassSize.REENTRANT_LOCK + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)ClassSize.OBJECT + ScanInfo.FIXED_OVERHEAD);

    protected HStore(HRegion region, ColumnFamilyDescriptor family, Configuration confParam) throws IOException {
        String className;
        this.fs = region.getRegionFileSystem();
        this.fs.createStoreDir(family.getNameAsString());
        this.region = region;
        this.family = family;
        this.conf = new CompoundConfiguration().add(confParam).addBytesMap(region.getTableDescriptor().getValues()).addStringMap(family.getConfiguration()).addBytesMap(family.getValues());
        this.blocksize = family.getBlocksize();
        String policyName = family.getStoragePolicy();
        if (null == policyName) {
            policyName = this.conf.get(BLOCK_STORAGE_POLICY_KEY, DEFAULT_BLOCK_STORAGE_POLICY);
        }
        this.fs.setStoragePolicy(family.getNameAsString(), policyName.trim());
        this.dataBlockEncoder = new HFileDataBlockEncoderImpl(family.getDataBlockEncoding());
        this.comparator = region.getCellComparator();
        long timeToPurgeDeletes = Math.max(this.conf.getLong("hbase.hstore.time.to.purge.deletes", 0L), 0L);
        LOG.trace((Object)("Time to purge deletes set to " + timeToPurgeDeletes + "ms in store " + this));
        long ttl = HStore.determineTTLFromFamily(family);
        this.scanInfo = new ScanInfo(this.conf, family, ttl, timeToPurgeDeletes, this.comparator);
        MemoryCompactionPolicy inMemoryCompaction = family.getInMemoryCompaction();
        if (inMemoryCompaction == null) {
            inMemoryCompaction = MemoryCompactionPolicy.valueOf(this.conf.get("hbase.hregion.compacting.memstore.type", CompactingMemStore.COMPACTING_MEMSTORE_TYPE_DEFAULT));
        }
        switch (inMemoryCompaction) {
            case BASIC: 
            case EAGER: {
                Class<CompactingMemStore> clz = this.conf.getClass(MEMSTORE_CLASS_NAME, CompactingMemStore.class, CompactingMemStore.class);
                className = clz.getName();
                this.memstore = ReflectionUtils.newInstance(clz, new Object[]{this.conf, this.comparator, this, this.getHRegion().getRegionServicesForStores(), inMemoryCompaction});
                break;
            }
            default: {
                className = DefaultMemStore.class.getName();
                this.memstore = (MemStore)ReflectionUtils.instantiateWithCustomCtor(className, new Class[]{Configuration.class, CellComparator.class}, new Object[]{this.conf, this.comparator});
            }
        }
        LOG.info((Object)("Memstore class name is " + className));
        this.offPeakHours = OffPeakHours.getInstance(this.conf);
        this.createCacheConf(family);
        this.verifyBulkLoads = this.conf.getBoolean("hbase.hstore.bulkload.verify", false);
        this.blockingFileCount = this.conf.getInt(BLOCKING_STOREFILES_KEY, 10);
        this.compactionCheckMultiplier = this.conf.getInt(COMPACTCHECKER_INTERVAL_MULTIPLIER_KEY, 1000);
        if (this.compactionCheckMultiplier <= 0) {
            LOG.error((Object)"Compaction check period multiplier must be positive, setting default: 1000");
            this.compactionCheckMultiplier = 1000;
        }
        if (closeCheckInterval == 0) {
            closeCheckInterval = this.conf.getInt("hbase.hstore.close.check.interval", 10000000);
        }
        this.storeEngine = this.createStoreEngine(this, this.conf, this.comparator);
        this.storeEngine.getStoreFileManager().loadFiles(this.loadStoreFiles());
        this.checksumType = HStore.getChecksumType(this.conf);
        this.bytesPerChecksum = HStore.getBytesPerChecksum(this.conf);
        this.flushRetriesNumber = this.conf.getInt("hbase.hstore.flush.retries.number", 10);
        this.pauseTime = this.conf.getInt("hbase.server.pause", 1000);
        if (this.flushRetriesNumber <= 0) {
            throw new IllegalArgumentException("hbase.hstore.flush.retries.number must be > 0, not " + this.flushRetriesNumber);
        }
        this.cryptoContext = EncryptionUtil.createEncryptionContext(this.conf, family);
    }

    protected void createCacheConf(ColumnFamilyDescriptor family) {
        this.cacheConf = new CacheConfig(this.conf, family);
    }

    protected StoreEngine<?, ?, ?, ?> createStoreEngine(Store store, Configuration conf, CellComparator kvComparator) throws IOException {
        return StoreEngine.create(store, conf, this.comparator);
    }

    public static long determineTTLFromFamily(ColumnFamilyDescriptor family) {
        long ttl = family.getTimeToLive();
        ttl = ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : (ttl == -1L ? Long.MAX_VALUE : (ttl *= 1000L));
        return ttl;
    }

    @Override
    public String getColumnFamilyName() {
        return this.family.getNameAsString();
    }

    @Override
    public TableName getTableName() {
        return this.getRegionInfo().getTable();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs.getFileSystem();
    }

    public HRegionFileSystem getRegionFileSystem() {
        return this.fs;
    }

    @Override
    public long getStoreFileTtl() {
        return this.scanInfo.getMinVersions() == 0 ? this.scanInfo.getTtl() : Long.MAX_VALUE;
    }

    @Override
    public long getMemstoreFlushSize() {
        return this.region.memstoreFlushSize;
    }

    @Override
    @Deprecated
    public long getFlushableSize() {
        MemstoreSize size = this.getSizeToFlush();
        return size.getHeapSize();
    }

    @Override
    public MemstoreSize getSizeToFlush() {
        return this.memstore.getFlushableSize();
    }

    @Override
    @Deprecated
    public long getSnapshotSize() {
        MemstoreSize size = this.getSizeOfSnapshot();
        return size.getHeapSize();
    }

    @Override
    public MemstoreSize getSizeOfSnapshot() {
        return this.memstore.getSnapshotSize();
    }

    @Override
    public long getCompactionCheckMultiplier() {
        return this.compactionCheckMultiplier;
    }

    @Override
    public long getBlockingFileCount() {
        return this.blockingFileCount;
    }

    public static int getBytesPerChecksum(Configuration conf) {
        return conf.getInt("hbase.hstore.bytes.per.checksum", 16384);
    }

    public static ChecksumType getChecksumType(Configuration conf) {
        String checksumName = conf.get("hbase.hstore.checksum.algorithm");
        if (checksumName == null) {
            return ChecksumType.getDefaultChecksumType();
        }
        return ChecksumType.nameToType(checksumName);
    }

    public static int getCloseCheckInterval() {
        return closeCheckInterval;
    }

    @Override
    public ColumnFamilyDescriptor getColumnFamilyDescriptor() {
        return this.family;
    }

    @Override
    public long getMaxSequenceId() {
        return StoreUtils.getMaxSequenceIdInList(this.getStorefiles());
    }

    @Override
    public long getMaxMemstoreTS() {
        return StoreUtils.getMaxMemstoreTSInList(this.getStorefiles());
    }

    @Deprecated
    public static Path getStoreHomedir(Path tabledir, HRegionInfo hri, byte[] family) {
        return HStore.getStoreHomedir(tabledir, hri.getEncodedName(), family);
    }

    @Deprecated
    public static Path getStoreHomedir(Path tabledir, String encodedName, byte[] family) {
        return new Path(tabledir, new Path(encodedName, Bytes.toString(family)));
    }

    @Override
    public HFileDataBlockEncoder getDataBlockEncoder() {
        return this.dataBlockEncoder;
    }

    void setDataBlockEncoderInTest(HFileDataBlockEncoder blockEncoder) {
        this.dataBlockEncoder = blockEncoder;
    }

    private List<StoreFile> loadStoreFiles() throws IOException {
        Collection<StoreFileInfo> files = this.fs.getStoreFiles(this.getColumnFamilyName());
        return this.openStoreFiles(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StoreFile> openStoreFiles(Collection<StoreFileInfo> files) throws IOException {
        if (files == null || files.isEmpty()) {
            return new ArrayList<StoreFile>();
        }
        ThreadPoolExecutor storeFileOpenerThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileOpenerThread-" + this.getColumnFamilyName());
        ExecutorCompletionService<StoreFile> completionService = new ExecutorCompletionService<StoreFile>(storeFileOpenerThreadPool);
        int totalValidStoreFile = 0;
        for (final StoreFileInfo storeFileInfo : files) {
            completionService.submit(new Callable<StoreFile>(){

                @Override
                public StoreFile call() throws IOException {
                    StoreFile storeFile = HStore.this.createStoreFileAndReader(storeFileInfo);
                    return storeFile;
                }
            });
            ++totalValidStoreFile;
        }
        ArrayList<StoreFile> results = new ArrayList<StoreFile>(files.size());
        IOException ioe = null;
        try {
            for (int i = 0; i < totalValidStoreFile; ++i) {
                try {
                    Future future = completionService.take();
                    StoreFile storeFile = (StoreFile)future.get();
                    if (storeFile == null) continue;
                    long length = storeFile.getReader().length();
                    this.storeSize += length;
                    this.totalUncompressedBytes += storeFile.getReader().getTotalUncompressedBytes();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("loaded " + storeFile.toStringDetailed()));
                    }
                    results.add(storeFile);
                    continue;
                }
                catch (InterruptedException e) {
                    if (ioe != null) continue;
                    ioe = new InterruptedIOException(e.getMessage());
                    continue;
                }
                catch (ExecutionException e) {
                    if (ioe != null) continue;
                    ioe = new IOException(e.getCause());
                }
            }
        }
        finally {
            storeFileOpenerThreadPool.shutdownNow();
        }
        if (ioe != null) {
            boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
            for (StoreFile file : results) {
                try {
                    if (file == null) continue;
                    file.closeReader(evictOnClose);
                }
                catch (IOException e) {
                    LOG.warn((Object)e.getMessage());
                }
            }
            throw ioe;
        }
        return results;
    }

    @Override
    public void refreshStoreFiles() throws IOException {
        Collection<StoreFileInfo> newFiles = this.fs.getStoreFiles(this.getColumnFamilyName());
        this.refreshStoreFilesInternal(newFiles);
    }

    @Override
    public void refreshStoreFiles(Collection<String> newFiles) throws IOException {
        ArrayList<StoreFileInfo> storeFiles = new ArrayList<StoreFileInfo>(newFiles.size());
        for (String file : newFiles) {
            storeFiles.add(this.fs.getStoreFileInfo(this.getColumnFamilyName(), file));
        }
        this.refreshStoreFilesInternal(storeFiles);
    }

    private void refreshStoreFilesInternal(Collection<StoreFileInfo> newFiles) throws IOException {
        StoreFileManager sfm = this.storeEngine.getStoreFileManager();
        Collection<StoreFile> currentFiles = sfm.getStorefiles();
        Collection<StoreFile> compactedFiles = sfm.getCompactedfiles();
        if (currentFiles == null) {
            currentFiles = Collections.emptySet();
        }
        if (newFiles == null) {
            newFiles = Collections.emptySet();
        }
        if (compactedFiles == null) {
            compactedFiles = Collections.emptySet();
        }
        HashMap<StoreFileInfo, StoreFile> currentFilesSet = new HashMap<StoreFileInfo, StoreFile>(currentFiles.size());
        for (StoreFile storeFile : currentFiles) {
            currentFilesSet.put(storeFile.getFileInfo(), storeFile);
        }
        HashMap<StoreFileInfo, StoreFile> compactedFilesSet = new HashMap<StoreFileInfo, StoreFile>(compactedFiles.size());
        for (StoreFile sf : compactedFiles) {
            compactedFilesSet.put(sf.getFileInfo(), sf);
        }
        HashSet<StoreFileInfo> hashSet = new HashSet<StoreFileInfo>(newFiles);
        Sets.SetView<StoreFileInfo> setView = Sets.difference(hashSet, compactedFilesSet.keySet());
        Sets.SetView<StoreFileInfo> toBeAddedFiles = Sets.difference(setView, currentFilesSet.keySet());
        Sets.SetView<StoreFileInfo> toBeRemovedFiles = Sets.difference(currentFilesSet.keySet(), setView);
        if (toBeAddedFiles.isEmpty() && toBeRemovedFiles.isEmpty()) {
            return;
        }
        LOG.info((Object)("Refreshing store files for region " + this.getRegionInfo().getRegionNameAsString() + " files to add: " + toBeAddedFiles + " files to remove: " + toBeRemovedFiles));
        HashSet<StoreFile> toBeRemovedStoreFiles = new HashSet<StoreFile>(toBeRemovedFiles.size());
        for (StoreFileInfo sfi : toBeRemovedFiles) {
            toBeRemovedStoreFiles.add((StoreFile)currentFilesSet.get(sfi));
        }
        List<StoreFile> openedFiles = this.openStoreFiles(toBeAddedFiles);
        this.replaceStoreFiles(toBeRemovedStoreFiles, openedFiles);
        if (!toBeAddedFiles.isEmpty()) {
            this.region.getMVCC().advanceTo(this.getMaxSequenceId());
        }
        this.completeCompaction(toBeRemovedStoreFiles);
    }

    private StoreFile createStoreFileAndReader(Path p) throws IOException {
        StoreFileInfo info = new StoreFileInfo(this.conf, this.getFileSystem(), p);
        return this.createStoreFileAndReader(info);
    }

    private StoreFile createStoreFileAndReader(StoreFileInfo info) throws IOException {
        info.setRegionCoprocessorHost(this.region.getCoprocessorHost());
        HStoreFile storeFile = new HStoreFile(this.getFileSystem(), info, this.conf, this.cacheConf, this.family.getBloomFilterType(), this.isPrimaryReplicaStore());
        storeFile.initReader();
        return storeFile;
    }

    public void startReplayingFromWAL() {
        this.memstore.startReplayingFromWAL();
    }

    public void stopReplayingFromWAL() {
        this.memstore.stopReplayingFromWAL();
    }

    public void add(Cell cell, MemstoreSize memstoreSize) {
        this.lock.readLock().lock();
        try {
            this.memstore.add(cell, memstoreSize);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void add(Iterable<Cell> cells, MemstoreSize memstoreSize) {
        this.lock.readLock().lock();
        try {
            this.memstore.add(cells, memstoreSize);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public long timeOfOldestEdit() {
        return this.memstore.timeOfOldestEdit();
    }

    @Override
    public Collection<StoreFile> getStorefiles() {
        return this.storeEngine.getStoreFileManager().getStorefiles();
    }

    @Override
    public Collection<StoreFile> getCompactedFiles() {
        return this.storeEngine.getStoreFileManager().getCompactedfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertBulkLoadHFileOk(Path srcPath) throws IOException {
        try (Closeable reader = null;){
            LOG.info((Object)("Validating hfile at " + srcPath + " for inclusion in store " + this + " region " + this.getRegionInfo().getRegionNameAsString()));
            reader = HFile.createReader(srcPath.getFileSystem(this.conf), srcPath, this.cacheConf, this.isPrimaryReplicaStore(), this.conf);
            reader.loadFileInfo();
            byte[] firstKey = reader.getFirstRowKey();
            Preconditions.checkState(firstKey != null, "First key can not be null");
            Cell lk = reader.getLastKey();
            Preconditions.checkState(lk != null, "Last key can not be null");
            byte[] lastKey = CellUtil.cloneRow(lk);
            LOG.debug((Object)("HFile bounds: first=" + Bytes.toStringBinary(firstKey) + " last=" + Bytes.toStringBinary(lastKey)));
            LOG.debug((Object)("Region bounds: first=" + Bytes.toStringBinary(this.getRegionInfo().getStartKey()) + " last=" + Bytes.toStringBinary(this.getRegionInfo().getEndKey())));
            if (!this.getRegionInfo().containsRange(firstKey, lastKey)) {
                throw new WrongRegionException("Bulk load file " + srcPath.toString() + " does not fit inside region " + this.getRegionInfo().getRegionNameAsString());
            }
            if (reader.length() > this.conf.getLong("hbase.hregion.max.filesize", 0x280000000L)) {
                LOG.warn((Object)("Trying to bulk load hfile " + srcPath.toString() + " with size: " + reader.length() + " bytes can be problematic as it may lead to oversplitting."));
            }
            if (this.verifyBulkLoads) {
                long verificationStartTime = EnvironmentEdgeManager.currentTime();
                LOG.info((Object)("Full verification started for bulk load hfile: " + srcPath.toString()));
                Cell prevCell = null;
                HFileScanner scanner = reader.getScanner(false, false, false);
                scanner.seekTo();
                do {
                    Cell cell = scanner.getCell();
                    if (prevCell != null) {
                        if (this.comparator.compareRows(prevCell, cell) > 0) {
                            throw new InvalidHFileException("Previous row is greater than current row: path=" + srcPath + " previous=" + CellUtil.getCellKeyAsString(prevCell) + " current=" + CellUtil.getCellKeyAsString(cell));
                        }
                        if (CellComparator.compareFamilies(prevCell, cell) != 0) {
                            throw new InvalidHFileException("Previous key had different family compared to current key: path=" + srcPath + " previous=" + Bytes.toStringBinary(prevCell.getFamilyArray(), prevCell.getFamilyOffset(), prevCell.getFamilyLength()) + " current=" + Bytes.toStringBinary(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()));
                        }
                    }
                    prevCell = cell;
                } while (scanner.next());
                LOG.info((Object)("Full verification complete for bulk load hfile: " + srcPath.toString() + " took " + (EnvironmentEdgeManager.currentTime() - verificationStartTime) + " ms"));
            }
        }
    }

    public Pair<Path, Path> preBulkLoadHFile(String srcPathStr, long seqNum) throws IOException {
        Path srcPath = new Path(srcPathStr);
        return this.fs.bulkLoadStoreFile(this.getColumnFamilyName(), srcPath, seqNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path bulkLoadHFile(byte[] family, String srcPathStr, Path dstPath) throws IOException {
        Path srcPath = new Path(srcPathStr);
        try {
            this.fs.commitStoreFile(srcPath, dstPath);
        }
        finally {
            if (this.getCoprocessorHost() != null) {
                this.getCoprocessorHost().postCommitStoreFile(family, srcPath, dstPath);
            }
        }
        LOG.info((Object)("Loaded HFile " + srcPath + " into store '" + this.getColumnFamilyName() + "' as " + dstPath + " - updating store file list."));
        StoreFile sf = this.createStoreFileAndReader(dstPath);
        this.bulkLoadHFile(sf);
        LOG.info((Object)("Successfully loaded store file " + srcPath + " into store " + this + " (new location: " + dstPath + ")"));
        return dstPath;
    }

    public void bulkLoadHFile(StoreFileInfo fileInfo) throws IOException {
        StoreFile sf = this.createStoreFileAndReader(fileInfo);
        this.bulkLoadHFile(sf);
    }

    private void bulkLoadHFile(StoreFile sf) throws IOException {
        StoreFileReader r = sf.getReader();
        this.storeSize += r.length();
        this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().insertNewFiles(Lists.newArrayList(sf));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        LOG.info((Object)("Loaded HFile " + sf.getFileInfo() + " into store '" + this.getColumnFamilyName()));
        if (LOG.isTraceEnabled()) {
            String traceMessage = "BULK LOAD time,size,store size,store files [" + EnvironmentEdgeManager.currentTime() + "," + r.length() + "," + this.storeSize + "," + this.storeEngine.getStoreFileManager().getStorefileCount() + "]";
            LOG.trace((Object)traceMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableCollection<StoreFile> close() throws IOException {
        this.archiveLock.lock();
        this.lock.writeLock().lock();
        try {
            ImmutableCollection<StoreFile> result = this.storeEngine.getStoreFileManager().clearFiles();
            Collection<StoreFile> compactedfiles = this.storeEngine.getStoreFileManager().clearCompactedFiles();
            if (compactedfiles != null && !compactedfiles.isEmpty()) {
                this.removeCompactedfiles(compactedfiles);
            }
            if (!result.isEmpty()) {
                ThreadPoolExecutor storeFileCloserThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileCloserThread-" + this.getColumnFamilyName());
                ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(storeFileCloserThreadPool);
                for (final StoreFile f : result) {
                    completionService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws IOException {
                            boolean evictOnClose = HStore.this.cacheConf != null ? HStore.this.cacheConf.shouldEvictOnClose() : true;
                            f.closeReader(evictOnClose);
                            return null;
                        }
                    });
                }
                IOException ioe = null;
                try {
                    for (int i = 0; i < result.size(); ++i) {
                        try {
                            Future future = completionService.take();
                            future.get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            if (ioe != null) continue;
                            ioe = new InterruptedIOException();
                            ioe.initCause(e);
                            continue;
                        }
                        catch (ExecutionException e) {
                            if (ioe != null) continue;
                            ioe = new IOException(e.getCause());
                        }
                    }
                }
                finally {
                    storeFileCloserThreadPool.shutdownNow();
                }
                if (ioe != null) {
                    throw ioe;
                }
            }
            LOG.info((Object)("Closed " + this));
            ImmutableCollection<StoreFile> immutableCollection = result;
            return immutableCollection;
        }
        finally {
            this.lock.writeLock().unlock();
            this.archiveLock.unlock();
        }
    }

    void snapshot() {
        this.lock.writeLock().lock();
        try {
            this.memstore.snapshot();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected List<Path> flushCache(long logCacheFlushId, MemStoreSnapshot snapshot, MonitoredTask status, ThroughputController throughputController) throws IOException {
        StoreFlusher flusher = this.storeEngine.getStoreFlusher();
        IOException lastException = null;
        for (int i = 0; i < this.flushRetriesNumber; ++i) {
            try {
                List<Path> pathNames = flusher.flushSnapshot(snapshot, logCacheFlushId, status, throughputController);
                Path lastPathName = null;
                try {
                    Iterator<Path> iterator = pathNames.iterator();
                    while (iterator.hasNext()) {
                        Path pathName;
                        lastPathName = pathName = iterator.next();
                        this.validateStoreFile(pathName);
                    }
                    return pathNames;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed validating store file " + lastPathName + ", retrying num=" + i), (Throwable)e);
                    lastException = e instanceof IOException ? (IOException)e : new IOException(e);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed flushing store file, retrying num=" + i), (Throwable)e);
                lastException = e;
            }
            if (lastException == null || i >= this.flushRetriesNumber - 1) continue;
            try {
                Thread.sleep(this.pauseTime);
                continue;
            }
            catch (InterruptedException e) {
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(e);
                throw iie;
            }
        }
        throw lastException;
    }

    private StoreFile commitFile(Path path, long logCacheFlushId, MonitoredTask status) throws IOException {
        Path dstPath = this.fs.commitStoreFile(this.getColumnFamilyName(), path);
        status.setStatus("Flushing " + this + ": reopening flushed file");
        StoreFile sf = this.createStoreFileAndReader(dstPath);
        StoreFileReader r = sf.getReader();
        this.storeSize += r.length();
        this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Added " + sf + ", entries=" + r.getEntries() + ", sequenceid=" + logCacheFlushId + ", filesize=" + StringUtils.TraditionalBinaryPrefix.long2String(r.length(), "", 1)));
        }
        return sf;
    }

    @Override
    public StoreFileWriter createWriterInTmp(long maxKeyCount, Compression.Algorithm compression, boolean isCompaction, boolean includeMVCCReadpoint, boolean includesTag) throws IOException {
        return this.createWriterInTmp(maxKeyCount, compression, isCompaction, includeMVCCReadpoint, includesTag, false);
    }

    @Override
    public StoreFileWriter createWriterInTmp(long maxKeyCount, Compression.Algorithm compression, boolean isCompaction, boolean includeMVCCReadpoint, boolean includesTag, boolean shouldDropBehind) throws IOException {
        return this.createWriterInTmp(maxKeyCount, compression, isCompaction, includeMVCCReadpoint, includesTag, shouldDropBehind, null);
    }

    @Override
    public StoreFileWriter createWriterInTmp(long maxKeyCount, Compression.Algorithm compression, boolean isCompaction, boolean includeMVCCReadpoint, boolean includesTag, boolean shouldDropBehind, TimeRangeTracker trt) throws IOException {
        CacheConfig writerCacheConf;
        if (isCompaction) {
            writerCacheConf = new CacheConfig(this.cacheConf);
            writerCacheConf.setCacheDataOnWrite(false);
        } else {
            writerCacheConf = this.cacheConf;
        }
        InetSocketAddress[] favoredNodes = null;
        if (this.region.getRegionServerServices() != null) {
            favoredNodes = this.region.getRegionServerServices().getFavoredNodesForRegion(this.region.getRegionInfo().getEncodedName());
        }
        HFileContext hFileContext = this.createFileContext(compression, includeMVCCReadpoint, includesTag, this.cryptoContext);
        Path familyTempDir = new Path(this.fs.getTempDir(), this.family.getNameAsString());
        StoreFileWriter.Builder builder = new StoreFileWriter.Builder(this.conf, writerCacheConf, this.getFileSystem()).withOutputDir(familyTempDir).withComparator(this.comparator).withBloomType(this.family.getBloomFilterType()).withMaxKeyCount(maxKeyCount).withFavoredNodes(favoredNodes).withFileContext(hFileContext).withShouldDropCacheBehind(shouldDropBehind);
        if (trt != null) {
            builder.withTimeRangeTracker(trt);
        }
        return builder.build();
    }

    private HFileContext createFileContext(Compression.Algorithm compression, boolean includeMVCCReadpoint, boolean includesTag, Encryption.Context cryptoContext) {
        if (compression == null) {
            compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        HFileContext hFileContext = new HFileContextBuilder().withIncludesMvcc(includeMVCCReadpoint).withIncludesTags(includesTag).withCompression(compression).withCompressTags(this.family.isCompressTags()).withChecksumType(this.checksumType).withBytesPerCheckSum(this.bytesPerChecksum).withBlockSize(this.blocksize).withHBaseCheckSum(true).withDataBlockEncoding(this.family.getDataBlockEncoding()).withEncryptionContext(cryptoContext).withCreateTime(EnvironmentEdgeManager.currentTime()).build();
        return hFileContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStorefiles(List<StoreFile> sfs, long snapshotId) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().insertNewFiles(sfs);
            if (snapshotId > 0L) {
                this.memstore.clearSnapshot(snapshotId);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.notifyChangedReadersObservers(sfs);
        if (LOG.isTraceEnabled()) {
            long totalSize = 0L;
            for (StoreFile sf : sfs) {
                totalSize += sf.getReader().length();
            }
            String traceMessage = "FLUSH time,count,size,store size,store files [" + EnvironmentEdgeManager.currentTime() + "," + sfs.size() + "," + totalSize + "," + this.storeSize + "," + this.storeEngine.getStoreFileManager().getStorefileCount() + "]";
            LOG.trace((Object)traceMessage);
        }
        return this.needsCompaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChangedReadersObservers(List<StoreFile> sfs) throws IOException {
        for (ChangedReadersObserver o : this.changedReaderObservers) {
            List<KeyValueScanner> memStoreScanners;
            this.lock.readLock().lock();
            try {
                memStoreScanners = this.memstore.getScanners(o.getReadPoint());
            }
            finally {
                this.lock.readLock().unlock();
            }
            o.updateReaders(sfs, memStoreScanners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<KeyValueScanner> getScanners(boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt) throws IOException {
        List<KeyValueScanner> memStoreScanners;
        Collection<StoreFile> storeFilesToScan;
        this.lock.readLock().lock();
        try {
            storeFilesToScan = this.storeEngine.getStoreFileManager().getFilesForScan(startRow, includeStartRow, stopRow, includeStopRow);
            memStoreScanners = this.memstore.getScanners(readPt);
        }
        finally {
            this.lock.readLock().unlock();
        }
        List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(storeFilesToScan, cacheBlocks, usePread, isCompaction, false, matcher, readPt);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(sfScanners.size() + 1);
        scanners.addAll(sfScanners);
        scanners.addAll(memStoreScanners);
        return scanners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<KeyValueScanner> getScanners(List<StoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
        List<KeyValueScanner> memStoreScanners = null;
        if (includeMemstoreScanner) {
            this.lock.readLock().lock();
            try {
                memStoreScanners = this.memstore.getScanners(readPt);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(files, cacheBlocks, usePread, isCompaction, false, matcher, readPt);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(sfScanners.size() + 1);
        scanners.addAll(sfScanners);
        if (memStoreScanners != null) {
            scanners.addAll(memStoreScanners);
        }
        return scanners;
    }

    @Override
    public void addChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.add(o);
    }

    @Override
    public void deleteChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.remove(o);
    }

    @Override
    public List<StoreFile> compact(CompactionContext compaction, ThroughputController throughputController) throws IOException {
        return this.compact(compaction, throughputController, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoreFile> compact(CompactionContext compaction, ThroughputController throughputController, User user) throws IOException {
        assert (compaction != null);
        List<StoreFile> sfs = null;
        CompactionRequest cr = compaction.getRequest();
        try {
            long compactionStartTime = EnvironmentEdgeManager.currentTime();
            assert (compaction.hasSelection());
            Collection<StoreFile> filesToCompact = cr.getFiles();
            assert (!filesToCompact.isEmpty());
            List<StoreFile> list = this.filesCompacting;
            synchronized (list) {
                Preconditions.checkArgument(this.filesCompacting.containsAll(filesToCompact));
            }
            LOG.info((Object)("Starting compaction of " + filesToCompact + " into tmpdir=" + this.fs.getTempDir() + ", totalSize=" + StringUtils.TraditionalBinaryPrefix.long2String(cr.getSize(), "", 1)));
            List<Path> newFiles = compaction.compact(throughputController, user);
            long outputBytes = 0L;
            if (!this.conf.getBoolean("hbase.hstore.compaction.complete", true)) {
                LOG.warn((Object)"hbase.hstore.compaction.complete is set to false");
                sfs = new ArrayList<StoreFile>(newFiles.size());
                boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
                for (Path newFile : newFiles) {
                    StoreFile sf = this.createStoreFileAndReader(newFile);
                    sf.closeReader(evictOnClose);
                    sfs.add(sf);
                }
                List<StoreFile> list2 = sfs;
                return list2;
            }
            sfs = this.moveCompatedFilesIntoPlace(cr, newFiles, user);
            this.writeCompactionWalRecord(filesToCompact, sfs);
            this.replaceStoreFiles(filesToCompact, sfs);
            if (cr.isMajor()) {
                this.majorCompactedCellsCount += this.getCompactionProgress().totalCompactingKVs;
                this.majorCompactedCellsSize += this.getCompactionProgress().totalCompactedSize;
            } else {
                this.compactedCellsCount += this.getCompactionProgress().totalCompactingKVs;
                this.compactedCellsSize += this.getCompactionProgress().totalCompactedSize;
            }
            for (StoreFile sf : sfs) {
                outputBytes += sf.getReader().length();
            }
            this.completeCompaction(filesToCompact);
            long now = EnvironmentEdgeManager.currentTime();
            if (this.region.getRegionServerServices() != null && this.region.getRegionServerServices().getMetrics() != null) {
                this.region.getRegionServerServices().getMetrics().updateCompaction(cr.isMajor(), now - compactionStartTime, cr.getFiles().size(), newFiles.size(), cr.getSize(), outputBytes);
            }
            this.logCompactionEndMessage(cr, sfs, now, compactionStartTime);
            List<StoreFile> list3 = sfs;
            return list3;
        }
        finally {
            this.finishCompactionRequest(cr);
        }
    }

    private List<StoreFile> moveCompatedFilesIntoPlace(CompactionRequest cr, List<Path> newFiles, User user) throws IOException {
        ArrayList<StoreFile> sfs = new ArrayList<StoreFile>(newFiles.size());
        for (Path newFile : newFiles) {
            assert (newFile != null);
            StoreFile sf = this.moveFileIntoPlace(newFile);
            if (this.getCoprocessorHost() != null) {
                this.getCoprocessorHost().postCompact(this, sf, cr.getTracker(), user);
            }
            assert (sf != null);
            sfs.add(sf);
        }
        return sfs;
    }

    StoreFile moveFileIntoPlace(Path newFile) throws IOException {
        this.validateStoreFile(newFile);
        Path destPath = this.fs.commitStoreFile(this.getColumnFamilyName(), newFile);
        return this.createStoreFileAndReader(destPath);
    }

    private void writeCompactionWalRecord(Collection<StoreFile> filesCompacted, Collection<StoreFile> newFiles) throws IOException {
        if (this.region.getWAL() == null) {
            return;
        }
        ArrayList<Path> inputPaths = new ArrayList<Path>(filesCompacted.size());
        for (StoreFile storeFile : filesCompacted) {
            inputPaths.add(storeFile.getPath());
        }
        ArrayList<Path> outputPaths = new ArrayList<Path>(newFiles.size());
        for (StoreFile f : newFiles) {
            outputPaths.add(f.getPath());
        }
        HRegionInfo hRegionInfo = this.region.getRegionInfo();
        WALProtos.CompactionDescriptor compactionDescriptor = ProtobufUtil.toCompactionDescriptor(hRegionInfo, this.family.getName(), inputPaths, outputPaths, this.fs.getStoreDir(this.getColumnFamilyDescriptor().getNameAsString()));
        WALUtil.writeCompactionMarker(this.region.getWAL(), this.region.getReplicationScope(), this.region.getRegionInfo(), compactionDescriptor, this.region.getMVCC());
    }

    @VisibleForTesting
    void replaceStoreFiles(Collection<StoreFile> compactedFiles, Collection<StoreFile> result) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().addCompactionResults(compactedFiles, result);
            this.filesCompacting.removeAll(compactedFiles);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void logCompactionEndMessage(CompactionRequest cr, List<StoreFile> sfs, long now, long compactionStartTime) {
        StringBuilder message = new StringBuilder("Completed" + (cr.isMajor() ? " major" : "") + " compaction of " + cr.getFiles().size() + (cr.isAllFiles() ? " (all)" : "") + " file(s) in " + this + " of " + this.getRegionInfo().getShortNameToLog() + " into ");
        if (sfs.isEmpty()) {
            message.append("none, ");
        } else {
            for (StoreFile sf : sfs) {
                message.append(sf.getPath().getName());
                message.append("(size=");
                message.append(StringUtils.TraditionalBinaryPrefix.long2String(sf.getReader().length(), "", 1));
                message.append("), ");
            }
        }
        message.append("total size for store is ").append(StringUtils.TraditionalBinaryPrefix.long2String(this.storeSize, "", 1)).append(". This selection was in queue for ").append(StringUtils.formatTimeDiff(compactionStartTime, cr.getSelectionTime())).append(", and took ").append(StringUtils.formatTimeDiff(now, compactionStartTime)).append(" to execute.");
        LOG.info((Object)message.toString());
        if (LOG.isTraceEnabled()) {
            int fileCount = this.storeEngine.getStoreFileManager().getStorefileCount();
            long resultSize = 0L;
            for (StoreFile sf : sfs) {
                resultSize += sf.getReader().length();
            }
            String traceMessage = "COMPACTION start,end,size out,files in,files out,store size,store files [" + compactionStartTime + "," + now + "," + resultSize + "," + cr.getFiles().size() + "," + sfs.size() + "," + this.storeSize + "," + fileCount + "]";
            LOG.trace((Object)traceMessage);
        }
    }

    public void replayCompactionMarker(WALProtos.CompactionDescriptor compaction, boolean pickCompactionFiles, boolean removeFiles) throws IOException {
        LOG.debug((Object)"Completing compaction from the WAL marker");
        ProtocolStringList compactionInputs = compaction.getCompactionInputList();
        ArrayList<String> compactionOutputs = Lists.newArrayList(compaction.getCompactionOutputList());
        String familyName = this.getColumnFamilyName();
        ArrayList<String> inputFiles = new ArrayList<String>(compactionInputs.size());
        for (Object compactionInput : compactionInputs) {
            Path inputPath = this.fs.getStoreFilePath(familyName, (String)compactionInput);
            inputFiles.add(inputPath.getName());
        }
        ArrayList<StoreFile> inputStoreFiles = new ArrayList<StoreFile>(compactionInputs.size());
        for (StoreFile sf : this.getStorefiles()) {
            if (!inputFiles.contains(sf.getPath().getName())) continue;
            inputStoreFiles.add(sf);
        }
        ArrayList<StoreFile> outputStoreFiles = new ArrayList<StoreFile>(compactionOutputs.size());
        if (pickCompactionFiles) {
            for (StoreFile sf : this.getStorefiles()) {
                compactionOutputs.remove(sf.getPath().getName());
            }
            for (String compactionOutput : compactionOutputs) {
                StoreFileInfo storeFileInfo = this.fs.getStoreFileInfo(this.getColumnFamilyName(), compactionOutput);
                StoreFile storeFile = this.createStoreFileAndReader(storeFileInfo);
                outputStoreFiles.add(storeFile);
            }
        }
        if (!inputStoreFiles.isEmpty() || !outputStoreFiles.isEmpty()) {
            LOG.info((Object)("Replaying compaction marker, replacing input files: " + inputStoreFiles + " with output files : " + outputStoreFiles));
            this.replaceStoreFiles(inputStoreFiles, outputStoreFiles);
            this.completeCompaction(inputStoreFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactRecentForTestingAssumingDefaultPolicy(int N) throws IOException {
        boolean isMajor;
        List<StoreFile> filesToCompact;
        List<StoreFile> list;
        this.lock.readLock().lock();
        try {
            list = this.filesCompacting;
            synchronized (list) {
                int count;
                filesToCompact = Lists.newArrayList(this.storeEngine.getStoreFileManager().getStorefiles());
                if (!this.filesCompacting.isEmpty()) {
                    StoreFile last = this.filesCompacting.get(this.filesCompacting.size() - 1);
                    int idx = filesToCompact.indexOf(last);
                    Preconditions.checkArgument(idx != -1);
                    filesToCompact.subList(0, idx + 1).clear();
                }
                if (N > (count = filesToCompact.size())) {
                    throw new RuntimeException("Not enough files");
                }
                isMajor = (filesToCompact = filesToCompact.subList(count - N, count)).size() == this.storeEngine.getStoreFileManager().getStorefileCount();
                this.filesCompacting.addAll(filesToCompact);
                Collections.sort(this.filesCompacting, this.storeEngine.getStoreFileManager().getStoreFileComparator());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            List<Path> newFiles = ((DefaultCompactor)this.storeEngine.getCompactor()).compactForTesting(filesToCompact, isMajor);
            for (Path newFile : newFiles) {
                StoreFile sf = this.moveFileIntoPlace(newFile);
                if (this.getCoprocessorHost() != null) {
                    this.getCoprocessorHost().postCompact(this, sf, null, null);
                }
                this.replaceStoreFiles(filesToCompact, Lists.newArrayList(sf));
                this.completeCompaction(filesToCompact);
            }
        }
        finally {
            list = this.filesCompacting;
            synchronized (list) {
                this.filesCompacting.removeAll(filesToCompact);
            }
        }
    }

    @Override
    public boolean hasReferences() {
        return StoreUtils.hasReferences(this.storeEngine.getStoreFileManager().getStorefiles());
    }

    @Override
    public CompactionProgress getCompactionProgress() {
        return this.storeEngine.getCompactor().getProgress();
    }

    @Override
    public boolean isMajorCompaction() throws IOException {
        for (StoreFile sf : this.storeEngine.getStoreFileManager().getStorefiles()) {
            if (sf.getReader() != null) continue;
            LOG.debug((Object)("StoreFile " + sf + " has null Reader"));
            return false;
        }
        return this.storeEngine.getCompactionPolicy().shouldPerformMajorCompaction(this.storeEngine.getStoreFileManager().getStorefiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<CompactionContext> requestCompaction(int priority, CompactionLifeCycleTracker tracker, User user) throws IOException {
        if (!this.areWritesEnabled()) {
            return Optional.empty();
        }
        this.removeUnneededFiles();
        CompactionContext compaction = this.storeEngine.createCompaction();
        CompactionRequest request = null;
        this.lock.readLock().lock();
        try {
            List<StoreFile> list = this.filesCompacting;
            synchronized (list) {
                Collection<StoreFile> selectedFiles;
                block18: {
                    if (this.getCoprocessorHost() != null) {
                        List<StoreFile> candidatesForCoproc = compaction.preSelect(this.filesCompacting);
                        boolean override = false;
                        override = this.getCoprocessorHost().preCompactSelection(this, candidatesForCoproc, tracker, user);
                        if (override) {
                            compaction.forceSelect(new CompactionRequest(candidatesForCoproc));
                        }
                    }
                    if (!compaction.hasSelection()) {
                        boolean isUserCompaction = priority == 1;
                        boolean mayUseOffPeak = this.offPeakHours.isOffPeakHour() && offPeakCompactionTracker.compareAndSet(false, true);
                        try {
                            compaction.select(this.filesCompacting, isUserCompaction, mayUseOffPeak, this.forceMajor && this.filesCompacting.isEmpty());
                        }
                        catch (IOException e) {
                            if (mayUseOffPeak) {
                                offPeakCompactionTracker.set(false);
                            }
                            throw e;
                        }
                        assert (compaction.hasSelection());
                        if (mayUseOffPeak && !compaction.getRequest().isOffPeak()) {
                            offPeakCompactionTracker.set(false);
                        }
                    }
                    if (this.getCoprocessorHost() != null) {
                        this.getCoprocessorHost().postCompactSelection(this, ImmutableList.copyOf(compaction.getRequest().getFiles()), tracker, user);
                    }
                    if (!(selectedFiles = (request = compaction.getRequest()).getFiles()).isEmpty()) break block18;
                    Optional<CompactionContext> optional = Optional.empty();
                    return optional;
                }
                this.addToCompactingFiles(selectedFiles);
                this.forceMajor = this.forceMajor && !request.isMajor();
                request.setPriority(priority != Integer.MIN_VALUE ? priority : this.getCompactPriority());
                request.setDescription(this.getRegionInfo().getRegionNameAsString(), this.getColumnFamilyName());
                request.setTracker(tracker);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " - " + this.getColumnFamilyName() + ": Initiating " + (request.isMajor() ? "major" : "minor") + " compaction" + (request.isAllFiles() ? " (all files)" : "")));
        this.region.reportCompactionRequestStart(request.isMajor());
        return Optional.of(compaction);
    }

    private void addToCompactingFiles(Collection<StoreFile> filesToAdd) {
        if (filesToAdd == null) {
            return;
        }
        if (!Collections.disjoint(this.filesCompacting, filesToAdd)) {
            Preconditions.checkArgument(false, "%s overlaps with %s", filesToAdd, this.filesCompacting);
        }
        this.filesCompacting.addAll(filesToAdd);
        Collections.sort(this.filesCompacting, this.storeEngine.getStoreFileManager().getStoreFileComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnneededFiles() throws IOException {
        if (!this.conf.getBoolean("hbase.store.delete.expired.storefile", true)) {
            return;
        }
        if (this.getColumnFamilyDescriptor().getMinVersions() > 0) {
            LOG.debug((Object)("Skipping expired store file removal due to min version being " + this.getColumnFamilyDescriptor().getMinVersions()));
            return;
        }
        this.lock.readLock().lock();
        Collection<StoreFile> delSfs = null;
        try {
            List<StoreFile> list = this.filesCompacting;
            synchronized (list) {
                long cfTtl = this.getStoreFileTtl();
                if (cfTtl != Long.MAX_VALUE) {
                    delSfs = this.storeEngine.getStoreFileManager().getUnneededFiles(EnvironmentEdgeManager.currentTime() - cfTtl, this.filesCompacting);
                    this.addToCompactingFiles(delSfs);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (delSfs == null || delSfs.isEmpty()) {
            return;
        }
        ArrayList<StoreFile> newFiles = new ArrayList<StoreFile>();
        this.writeCompactionWalRecord(delSfs, newFiles);
        this.replaceStoreFiles(delSfs, newFiles);
        this.completeCompaction(delSfs);
        LOG.info((Object)("Completed removal of " + delSfs.size() + " unnecessary (expired) file(s) in " + this + " of " + this.getRegionInfo().getRegionNameAsString() + "; total size for store is " + StringUtils.TraditionalBinaryPrefix.long2String(this.storeSize, "", 1)));
    }

    @Override
    public void cancelRequestedCompaction(CompactionContext compaction) {
        this.finishCompactionRequest(compaction.getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCompactionRequest(CompactionRequest cr) {
        this.region.reportCompactionRequestEnd(cr.isMajor(), cr.getFiles().size(), cr.getSize());
        if (cr.isOffPeak()) {
            offPeakCompactionTracker.set(false);
            cr.setOffPeak(false);
        }
        List<StoreFile> list = this.filesCompacting;
        synchronized (list) {
            this.filesCompacting.removeAll(cr.getFiles());
        }
    }

    private void validateStoreFile(Path path) throws IOException {
        StoreFile storeFile = null;
        try {
            storeFile = this.createStoreFileAndReader(path);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to open store file : " + path + ", keeping it in tmp location"), (Throwable)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeReader(false);
            }
        }
    }

    @VisibleForTesting
    protected void completeCompaction(Collection<StoreFile> compactedFiles) throws IOException {
        this.storeSize = 0L;
        this.totalUncompressedBytes = 0L;
        for (StoreFile hsf : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = hsf.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + hsf + " has a null Reader"));
                continue;
            }
            this.storeSize += r.length();
            this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        }
    }

    int versionsToReturn(int wantedVersions) {
        if (wantedVersions <= 0) {
            throw new IllegalArgumentException("Number of versions must be > 0");
        }
        int maxVersions = this.family.getMaxVersions();
        return wantedVersions > maxVersions ? maxVersions : wantedVersions;
    }

    @Override
    public boolean canSplit() {
        this.lock.readLock().lock();
        try {
            boolean result;
            boolean bl = result = !this.hasReferences();
            if (!result && LOG.isTraceEnabled()) {
                LOG.trace((Object)("Not splittable; has references: " + this));
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public byte[] getSplitPoint() {
        this.lock.readLock().lock();
        try {
            assert (!this.getRegionInfo().isMetaRegion());
            if (this.hasReferences()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Not splittable; has references: " + this));
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = this.storeEngine.getStoreFileManager().getSplitPoint();
            return byArray;
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed getting store size for " + this), (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    @Override
    public long getLastCompactSize() {
        return this.lastCompactSize;
    }

    @Override
    public long getSize() {
        return this.storeSize;
    }

    @Override
    public void triggerMajorCompaction() {
        this.forceMajor = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueScanner getScanner(Scan scan, NavigableSet<byte[]> targetCols, long readPt) throws IOException {
        this.lock.readLock().lock();
        try {
            KeyValueScanner scanner = null;
            if (this.getCoprocessorHost() != null) {
                scanner = this.getCoprocessorHost().preStoreScannerOpen(this, scan, targetCols, readPt);
            }
            KeyValueScanner keyValueScanner = scanner = this.createScanner(scan, targetCols, readPt, scanner);
            return keyValueScanner;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected KeyValueScanner createScanner(Scan scan, NavigableSet<byte[]> targetCols, long readPt, KeyValueScanner scanner) throws IOException {
        if (scanner == null) {
            scanner = scan.isReversed() ? new ReversedStoreScanner(this, this.getScanInfo(), scan, targetCols, readPt) : new StoreScanner(this, this.getScanInfo(), scan, targetCols, readPt);
        }
        return scanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<KeyValueScanner> recreateScanners(List<KeyValueScanner> currentFileScanners, boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
        this.lock.readLock().lock();
        try {
            Object object;
            HashMap<String, StoreFile> name2File = new HashMap<String, StoreFile>(this.getStorefilesCount() + this.getCompactedFilesCount());
            for (StoreFile file : this.getStorefiles()) {
                name2File.put(file.getFileInfo().getActiveFileName(), file);
            }
            if (this.getCompactedFiles() != null) {
                for (StoreFile file : this.getCompactedFiles()) {
                    name2File.put(file.getFileInfo().getActiveFileName(), file);
                }
            }
            ArrayList<StoreFile> filesToReopen = new ArrayList<StoreFile>();
            for (KeyValueScanner kvs : currentFileScanners) {
                assert (kvs.isFileScanner());
                if (kvs.peek() == null) continue;
                filesToReopen.add((StoreFile)name2File.get(kvs.getFilePath().getName()));
            }
            if (filesToReopen.isEmpty()) {
                object = null;
                return object;
            }
            object = this.getScanners(filesToReopen, cacheBlocks, false, false, matcher, startRow, includeStartRow, stopRow, includeStopRow, readPt, false);
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.getColumnFamilyName();
    }

    @Override
    public int getStorefilesCount() {
        return this.storeEngine.getStoreFileManager().getStorefileCount();
    }

    @Override
    public int getCompactedFilesCount() {
        return this.storeEngine.getStoreFileManager().getCompactedFilesCount();
    }

    @Override
    public long getMaxStoreFileAge() {
        long earliestTS = Long.MAX_VALUE;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            if (!s.isHFile()) continue;
            long createdTS = s.getFileInfo().getCreatedTimestamp();
            earliestTS = createdTS < earliestTS ? createdTS : earliestTS;
        }
        long now = EnvironmentEdgeManager.currentTime();
        return now - earliestTS;
    }

    @Override
    public long getMinStoreFileAge() {
        long latestTS = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            if (!s.isHFile()) continue;
            long createdTS = s.getFileInfo().getCreatedTimestamp();
            latestTS = createdTS > latestTS ? createdTS : latestTS;
        }
        long now = EnvironmentEdgeManager.currentTime();
        return now - latestTS;
    }

    @Override
    public long getAvgStoreFileAge() {
        long sum = 0L;
        long count = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            if (!s.isHFile()) continue;
            sum += s.getFileInfo().getCreatedTimestamp();
            ++count;
        }
        if (count == 0L) {
            return 0L;
        }
        long avgTS = sum / count;
        long now = EnvironmentEdgeManager.currentTime();
        return now - avgTS;
    }

    @Override
    public long getNumReferenceFiles() {
        long numRefFiles = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            if (!s.isReference()) continue;
            ++numRefFiles;
        }
        return numRefFiles;
    }

    @Override
    public long getNumHFiles() {
        long numHFiles = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            if (!s.isHFile()) continue;
            ++numHFiles;
        }
        return numHFiles;
    }

    @Override
    public long getStoreSizeUncompressed() {
        return this.totalUncompressedBytes;
    }

    @Override
    public long getStorefilesSize() {
        return this.getStorefilesSize(storeFile -> true);
    }

    @Override
    public long getHFilesSize() {
        return this.getStorefilesSize(storeFile -> storeFile.isHFile());
    }

    private long getStorefilesSize(Predicate<StoreFile> predicate) {
        long size = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            if (!predicate.test(s)) continue;
            size += r.length();
        }
        return size;
    }

    @Override
    public long getStorefilesIndexSize() {
        long size = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            size += r.indexSize();
        }
        return size;
    }

    @Override
    public long getTotalStaticIndexSize() {
        long size = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = s.getReader();
            if (r == null) continue;
            size += r.getUncompressedDataIndexSize();
        }
        return size;
    }

    @Override
    public long getTotalStaticBloomSize() {
        long size = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = s.getReader();
            if (r == null) continue;
            size += r.getTotalBloomSize();
        }
        return size;
    }

    @Override
    @Deprecated
    public long getMemStoreSize() {
        MemstoreSize size = this.getSizeOfMemStore();
        return size.getHeapSize();
    }

    @Override
    public MemstoreSize getSizeOfMemStore() {
        return this.memstore.size();
    }

    @Override
    public int getCompactPriority() {
        int priority = this.storeEngine.getStoreFileManager().getStoreCompactionPriority();
        if (priority == 1) {
            LOG.warn((Object)"Compaction priority is USER despite there being no user compaction");
        }
        return priority;
    }

    @Override
    public boolean throttleCompaction(long compactionSize) {
        return this.storeEngine.getCompactionPolicy().throttleCompaction(compactionSize);
    }

    public HRegion getHRegion() {
        return this.region;
    }

    @Override
    public RegionCoprocessorHost getCoprocessorHost() {
        return this.region.getCoprocessorHost();
    }

    @Override
    public HRegionInfo getRegionInfo() {
        return this.fs.getRegionInfo();
    }

    @Override
    public boolean areWritesEnabled() {
        return this.region.areWritesEnabled();
    }

    @Override
    public long getSmallestReadPoint() {
        return this.region.getSmallestReadPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsert(Iterable<Cell> cells, long readpoint, MemstoreSize memstoreSize) throws IOException {
        this.lock.readLock().lock();
        try {
            this.memstore.upsert(cells, readpoint, memstoreSize);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public StoreFlushContext createFlushContext(long cacheFlushId) {
        return new StoreFlusherImpl(cacheFlushId);
    }

    @Override
    public boolean needsCompaction() {
        return this.storeEngine.needsCompaction(this.filesCompacting);
    }

    @Override
    public CacheConfig getCacheConfig() {
        return this.cacheConf;
    }

    @Override
    public long heapSize() {
        MemstoreSize memstoreSize = this.memstore.size();
        return DEEP_OVERHEAD + memstoreSize.getHeapSize();
    }

    @Override
    public CellComparator getComparator() {
        return this.comparator;
    }

    @Override
    public ScanInfo getScanInfo() {
        return this.scanInfo;
    }

    void setScanInfo(ScanInfo scanInfo) {
        this.scanInfo = scanInfo;
    }

    @Override
    public boolean hasTooManyStoreFiles() {
        return (long)this.getStorefilesCount() > this.blockingFileCount;
    }

    @Override
    public long getFlushedCellsCount() {
        return this.flushedCellsCount;
    }

    @Override
    public long getFlushedCellsSize() {
        return this.flushedCellsSize;
    }

    @Override
    public long getFlushedOutputFileSize() {
        return this.flushedOutputFileSize;
    }

    @Override
    public long getCompactedCellsCount() {
        return this.compactedCellsCount;
    }

    @Override
    public long getCompactedCellsSize() {
        return this.compactedCellsSize;
    }

    @Override
    public long getMajorCompactedCellsCount() {
        return this.majorCompactedCellsCount;
    }

    @Override
    public long getMajorCompactedCellsSize() {
        return this.majorCompactedCellsSize;
    }

    @VisibleForTesting
    public StoreEngine<?, ?, ?, ?> getStoreEngine() {
        return this.storeEngine;
    }

    protected OffPeakHours getOffPeakHours() {
        return this.offPeakHours;
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.conf = new CompoundConfiguration().add(conf).addBytesMap(this.family.getValues());
        ((CompactionPolicy)this.storeEngine.compactionPolicy).setConf(conf);
        this.offPeakHours = OffPeakHours.getInstance(conf);
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
    }

    @Override
    public double getCompactionPressure() {
        return this.storeEngine.getStoreFileManager().getCompactionPressure();
    }

    @Override
    public boolean isPrimaryReplicaStore() {
        return this.getRegionInfo().getReplicaId() == 0;
    }

    public void preSnapshotOperation() {
        this.archiveLock.lock();
    }

    public void postSnapshotOperation() {
        this.archiveLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeAndArchiveCompactedFiles() throws IOException {
        this.archiveLock.lock();
        try {
            this.lock.readLock().lock();
            ArrayList<StoreFile> copyCompactedfiles = null;
            try {
                Collection<StoreFile> compactedfiles = this.getStoreEngine().getStoreFileManager().getCompactedfiles();
                if (compactedfiles != null && compactedfiles.size() != 0) {
                    copyCompactedfiles = new ArrayList<StoreFile>(compactedfiles);
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"No compacted files to archive");
                    return;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (copyCompactedfiles != null && !copyCompactedfiles.isEmpty()) {
                this.removeCompactedfiles(copyCompactedfiles);
            }
        }
        finally {
            this.archiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCompactedfiles(Collection<StoreFile> compactedfiles) throws IOException {
        ArrayList<StoreFile> filesToRemove = new ArrayList<StoreFile>(compactedfiles.size());
        Iterator<StoreFile> iterator = compactedfiles.iterator();
        while (iterator.hasNext()) {
            StoreFile file;
            StoreFile storeFile = file = iterator.next();
            synchronized (storeFile) {
                try {
                    StoreFileReader r = file.getReader();
                    if (r == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("The file " + file + " was closed but still not archived."));
                        }
                        filesToRemove.add(file);
                        continue;
                    }
                    if (file.isCompactedAway() && !file.isReferencedInReads()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Closing and archiving the file " + file.getPath()));
                        }
                        r.close(true);
                        filesToRemove.add(file);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Exception while trying to close the compacted store file " + file.getPath().getName()));
                }
            }
        }
        if (this.isPrimaryReplicaStore() && !filesToRemove.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Moving the files " + filesToRemove + " to archive"));
            }
            try {
                this.fs.removeStoreFiles(this.getColumnFamilyDescriptor().getNameAsString(), filesToRemove);
            }
            catch (FailedArchiveException fae) {
                Collection<Path> failedFiles = fae.getFailedFiles();
                Iterator iter = filesToRemove.iterator();
                while (iter.hasNext()) {
                    if (!failedFiles.contains(((StoreFile)iter.next()).getPath())) continue;
                    iter.remove();
                }
                if (!filesToRemove.isEmpty()) {
                    this.clearCompactedfiles(filesToRemove);
                }
                throw fae;
            }
        }
        if (!filesToRemove.isEmpty()) {
            this.clearCompactedfiles(filesToRemove);
        }
    }

    public Long preFlushSeqIDEstimation() {
        return this.memstore.preFlushSeqIDEstimation();
    }

    @Override
    public boolean isSloppyMemstore() {
        return this.memstore.isSloppy();
    }

    private void clearCompactedfiles(List<StoreFile> filesToRemove) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Clearing the compacted file " + filesToRemove + " from this store"));
        }
        try {
            this.lock.writeLock().lock();
            this.getStoreEngine().getStoreFileManager().removeCompactedFiles(filesToRemove);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private final class StoreFlusherImpl
    implements StoreFlushContext {
        private long cacheFlushSeqNum;
        private MemStoreSnapshot snapshot;
        private List<Path> tempFiles;
        private List<Path> committedFiles;
        private long cacheFlushCount;
        private long cacheFlushSize;
        private long outputFileSize;

        private StoreFlusherImpl(long cacheFlushSeqNum) {
            this.cacheFlushSeqNum = cacheFlushSeqNum;
        }

        @Override
        public void prepare() {
            this.snapshot = HStore.this.memstore.snapshot();
            this.cacheFlushCount = this.snapshot.getCellsCount();
            this.cacheFlushSize = this.snapshot.getDataSize();
            this.committedFiles = new ArrayList<Path>(1);
        }

        @Override
        public void flushCache(MonitoredTask status) throws IOException {
            RegionServerServices rsService = HStore.this.region.getRegionServerServices();
            ThroughputController throughputController = rsService == null ? null : rsService.getFlushThroughputController();
            this.tempFiles = HStore.this.flushCache(this.cacheFlushSeqNum, this.snapshot, status, throughputController);
        }

        @Override
        public boolean commit(MonitoredTask status) throws IOException {
            if (this.tempFiles == null || this.tempFiles.isEmpty()) {
                return false;
            }
            ArrayList<StoreFile> storeFiles = new ArrayList<StoreFile>(this.tempFiles.size());
            for (Path storeFilePath : this.tempFiles) {
                try {
                    StoreFile sf = HStore.this.commitFile(storeFilePath, this.cacheFlushSeqNum, status);
                    this.outputFileSize += sf.getReader().length();
                    storeFiles.add(sf);
                }
                catch (IOException ex) {
                    LOG.error((Object)("Failed to commit store file " + storeFilePath), (Throwable)ex);
                    for (StoreFile sf : storeFiles) {
                        Path pathToDelete = sf.getPath();
                        try {
                            sf.deleteReader();
                        }
                        catch (IOException deleteEx) {
                            LOG.fatal((Object)("Failed to delete store file we committed, halting " + pathToDelete), (Throwable)ex);
                            Runtime.getRuntime().halt(1);
                        }
                    }
                    throw new IOException("Failed to commit the flush", ex);
                }
            }
            for (StoreFile sf : storeFiles) {
                if (HStore.this.getCoprocessorHost() != null) {
                    HStore.this.getCoprocessorHost().postFlush(HStore.this, sf);
                }
                this.committedFiles.add(sf.getPath());
            }
            Object object = HStore.this;
            ((HStore)object).flushedCellsCount = ((HStore)object).flushedCellsCount + this.cacheFlushCount;
            object = HStore.this;
            ((HStore)object).flushedCellsSize = ((HStore)object).flushedCellsSize + this.cacheFlushSize;
            object = HStore.this;
            ((HStore)object).flushedOutputFileSize = ((HStore)object).flushedOutputFileSize + this.outputFileSize;
            return HStore.this.updateStorefiles(storeFiles, this.snapshot.getId());
        }

        @Override
        public long getOutputFileSize() {
            return this.outputFileSize;
        }

        @Override
        public List<Path> getCommittedFiles() {
            return this.committedFiles;
        }

        @Override
        public void replayFlush(List<String> fileNames, boolean dropMemstoreSnapshot) throws IOException {
            ArrayList<StoreFile> storeFiles = new ArrayList<StoreFile>(fileNames.size());
            for (String file : fileNames) {
                StoreFileInfo storeFileInfo = HStore.this.fs.getStoreFileInfo(HStore.this.getColumnFamilyName(), file);
                StoreFile storeFile = HStore.this.createStoreFileAndReader(storeFileInfo);
                storeFiles.add(storeFile);
                HStore hStore = HStore.this;
                hStore.storeSize = hStore.storeSize + storeFile.getReader().length();
                hStore = HStore.this;
                hStore.totalUncompressedBytes = hStore.totalUncompressedBytes + storeFile.getReader().getTotalUncompressedBytes();
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("Region: " + HStore.this.getRegionInfo().getEncodedName() + " added " + storeFile + ", entries=" + storeFile.getReader().getEntries() + ", sequenceid=" + storeFile.getReader().getSequenceID() + ", filesize=" + StringUtils.TraditionalBinaryPrefix.long2String(storeFile.getReader().length(), "", 1)));
            }
            long snapshotId = -1L;
            if (dropMemstoreSnapshot && this.snapshot != null) {
                snapshotId = this.snapshot.getId();
            }
            HStore.this.updateStorefiles(storeFiles, snapshotId);
        }

        @Override
        public void abort() throws IOException {
            if (this.snapshot == null) {
                return;
            }
            HStore.this.updateStorefiles(new ArrayList(0), this.snapshot.getId());
        }
    }
}

