/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HStoreFile
implements StoreFile {
    private static final Log LOG = LogFactory.getLog((String)HStoreFile.class.getName());
    private static final boolean DEFAULT_STORE_FILE_READER_NO_READAHEAD = false;
    private final StoreFileInfo fileInfo;
    private final FileSystem fs;
    private final CacheConfig cacheConf;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final boolean noReadahead;
    private final boolean primaryReplica;
    private volatile boolean compactedAway = false;
    private long sequenceid = -1L;
    private long maxMemstoreTS = -1L;
    private Cell firstKey;
    private Cell lastKey;
    private Comparator<Cell> comparator;
    private AtomicBoolean majorCompaction = null;
    private boolean excludeFromMinorCompaction = false;
    private Map<byte[], byte[]> metadataMap;
    private volatile StoreFileReader reader;
    private final BloomType cfBloomType;

    @Override
    public CacheConfig getCacheConf() {
        return this.cacheConf;
    }

    @Override
    public Cell getFirstKey() {
        return this.firstKey;
    }

    @Override
    public Cell getLastKey() {
        return this.lastKey;
    }

    @Override
    public Comparator<Cell> getComparator() {
        return this.comparator;
    }

    @Override
    public long getMaxMemstoreTS() {
        return this.maxMemstoreTS;
    }

    @Deprecated
    public HStoreFile(FileSystem fs, Path p, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType) throws IOException {
        this(fs, new StoreFileInfo(conf, fs, p), conf, cacheConf, cfBloomType);
    }

    public HStoreFile(FileSystem fs, Path p, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType, boolean primaryReplica) throws IOException {
        this(fs, new StoreFileInfo(conf, fs, p), conf, cacheConf, cfBloomType, primaryReplica);
    }

    @Deprecated
    public HStoreFile(FileSystem fs, StoreFileInfo fileInfo, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType) throws IOException {
        this(fs, fileInfo, conf, cacheConf, cfBloomType, true);
    }

    public HStoreFile(FileSystem fs, StoreFileInfo fileInfo, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType, boolean primaryReplica) {
        this.fs = fs;
        this.fileInfo = fileInfo;
        this.cacheConf = cacheConf;
        this.noReadahead = conf.getBoolean("hbase.store.reader.no-readahead", false);
        if (BloomFilterFactory.isGeneralBloomEnabled(conf)) {
            this.cfBloomType = cfBloomType;
        } else {
            LOG.info((Object)("Ignoring bloom filter check for file " + this.getPath() + ": cfBloomType=" + (Object)((Object)cfBloomType) + " (disabled in config)"));
            this.cfBloomType = BloomType.NONE;
        }
        this.primaryReplica = primaryReplica;
    }

    @Override
    public StoreFileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public Path getPath() {
        return this.fileInfo.getPath();
    }

    @Override
    public Path getQualifiedPath() {
        return this.fileInfo.getPath().makeQualified(this.fs.getUri(), this.fs.getWorkingDirectory());
    }

    @Override
    public boolean isReference() {
        return this.fileInfo.isReference();
    }

    @Override
    public boolean isHFile() {
        return StoreFileInfo.isHFile(this.fileInfo.getPath());
    }

    @Override
    public boolean isMajorCompactionResult() {
        if (this.majorCompaction == null) {
            throw new NullPointerException("This has not been set yet");
        }
        return this.majorCompaction.get();
    }

    @Override
    public boolean excludeFromMinorCompaction() {
        return this.excludeFromMinorCompaction;
    }

    @Override
    public long getMaxSequenceId() {
        return this.sequenceid;
    }

    @Override
    public long getModificationTimeStamp() throws IOException {
        return this.fileInfo.getModificationTime();
    }

    @Override
    public byte[] getMetadataValue(byte[] key) {
        return this.metadataMap.get(key);
    }

    @Override
    public boolean isBulkLoadResult() {
        boolean bulkLoadedHFile = false;
        String fileName = this.getPath().getName();
        int startPos = fileName.indexOf("SeqId_");
        if (startPos != -1) {
            bulkLoadedHFile = true;
        }
        return bulkLoadedHFile || this.metadataMap != null && this.metadataMap.containsKey(BULKLOAD_TIME_KEY);
    }

    @Override
    public boolean isCompactedAway() {
        return this.compactedAway;
    }

    @VisibleForTesting
    public int getRefCount() {
        return this.refCount.get();
    }

    @Override
    public boolean isReferencedInReads() {
        int rc = this.refCount.get();
        assert (rc >= 0);
        return rc > 0;
    }

    @Override
    public OptionalLong getBulkLoadTimestamp() {
        byte[] bulkLoadTimestamp = this.metadataMap.get(BULKLOAD_TIME_KEY);
        return bulkLoadTimestamp == null ? OptionalLong.empty() : OptionalLong.of(Bytes.toLong(bulkLoadTimestamp));
    }

    @Override
    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        return this.fileInfo.getHDFSBlockDistribution();
    }

    private void open() throws IOException {
        if (this.reader != null) {
            throw new IllegalAccessError("Already open");
        }
        this.reader = this.fileInfo.open(this.fs, this.cacheConf, false, this.noReadahead ? 0L : -1L, this.primaryReplica, this.refCount, true);
        this.metadataMap = Collections.unmodifiableMap(this.reader.loadFileInfo());
        byte[] b = this.metadataMap.get(MAX_SEQ_ID_KEY);
        if (b != null) {
            this.sequenceid = Bytes.toLong(b);
            if (this.fileInfo.isTopReference()) {
                ++this.sequenceid;
            }
        }
        if (this.isBulkLoadResult()) {
            boolean skipResetSeqId;
            String fileName = this.getPath().getName();
            int startPos = fileName.lastIndexOf("SeqId_");
            if (startPos != -1) {
                this.sequenceid = Long.parseLong(fileName.substring(startPos + 6, fileName.indexOf(95, startPos + 6)));
                if (this.fileInfo.isTopReference()) {
                    ++this.sequenceid;
                }
            }
            if (skipResetSeqId = this.isSkipResetSeqId(this.metadataMap.get(SKIP_RESET_SEQ_ID))) {
                ++this.sequenceid;
            }
            this.reader.setSkipResetSeqId(skipResetSeqId);
            this.reader.setBulkLoaded(true);
        }
        this.reader.setSequenceID(this.sequenceid);
        b = this.metadataMap.get(HFile.Writer.MAX_MEMSTORE_TS_KEY);
        if (b != null) {
            this.maxMemstoreTS = Bytes.toLong(b);
        }
        if ((b = this.metadataMap.get(MAJOR_COMPACTION_KEY)) != null) {
            boolean mc = Bytes.toBoolean(b);
            if (this.majorCompaction == null) {
                this.majorCompaction = new AtomicBoolean(mc);
            } else {
                this.majorCompaction.set(mc);
            }
        } else {
            this.majorCompaction = new AtomicBoolean(false);
        }
        b = this.metadataMap.get(EXCLUDE_FROM_MINOR_COMPACTION_KEY);
        this.excludeFromMinorCompaction = b != null && Bytes.toBoolean(b);
        BloomType hfileBloomType = this.reader.getBloomFilterType();
        if (this.cfBloomType != BloomType.NONE) {
            this.reader.loadBloomfilter(BlockType.GENERAL_BLOOM_META);
            if (hfileBloomType != this.cfBloomType) {
                LOG.info((Object)("HFile Bloom filter type for " + this.reader.getHFileReader().getName() + ": " + (Object)((Object)hfileBloomType) + ", but " + (Object)((Object)this.cfBloomType) + " specified in column family configuration"));
            }
        } else if (hfileBloomType != BloomType.NONE) {
            LOG.info((Object)("Bloom filter turned off by CF config for " + this.reader.getHFileReader().getName()));
        }
        this.reader.loadBloomfilter(BlockType.DELETE_FAMILY_BLOOM_META);
        try {
            this.reader.timeRange = TimeRangeTracker.getTimeRange(this.metadataMap.get(TIMERANGE_KEY));
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Error reading timestamp range data from meta -- proceeding without", (Throwable)e);
            this.reader.timeRange = null;
        }
        this.firstKey = this.reader.getFirstKey();
        this.lastKey = this.reader.getLastKey();
        this.comparator = this.reader.getComparator();
    }

    @Override
    public void initReader() throws IOException {
        if (this.reader == null) {
            try {
                this.open();
            }
            catch (Exception e) {
                try {
                    boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
                    this.closeReader(evictOnClose);
                }
                catch (IOException ee) {
                    LOG.warn((Object)"failed to close reader", (Throwable)ee);
                }
                throw e;
            }
        }
    }

    private StoreFileReader createStreamReader(boolean canUseDropBehind) throws IOException {
        this.initReader();
        StoreFileReader reader = this.fileInfo.open(this.fs, this.cacheConf, canUseDropBehind, -1L, this.primaryReplica, this.refCount, false);
        reader.copyFields(this.reader);
        return reader;
    }

    @Override
    public StoreFileScanner getPreadScanner(boolean cacheBlocks, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) {
        return this.getReader().getStoreFileScanner(cacheBlocks, true, false, readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    @Override
    public StoreFileScanner getStreamScanner(boolean canUseDropBehind, boolean cacheBlocks, boolean isCompaction, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) throws IOException {
        return this.createStreamReader(canUseDropBehind).getStoreFileScanner(cacheBlocks, false, isCompaction, readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    @Override
    public StoreFileReader getReader() {
        return this.reader;
    }

    @Override
    public synchronized void closeReader(boolean evictOnClose) throws IOException {
        if (this.reader != null) {
            this.reader.close(evictOnClose);
            this.reader = null;
        }
    }

    @Override
    public void markCompactedAway() {
        this.compactedAway = true;
    }

    @Override
    public void deleteReader() throws IOException {
        boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
        this.closeReader(evictOnClose);
        this.fs.delete(this.getPath(), true);
    }

    public String toString() {
        return this.fileInfo.toString();
    }

    @Override
    public String toStringDetailed() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPath().toString());
        sb.append(", isReference=").append(this.isReference());
        sb.append(", isBulkLoadResult=").append(this.isBulkLoadResult());
        if (this.isBulkLoadResult()) {
            sb.append(", bulkLoadTS=");
            OptionalLong bulkLoadTS = this.getBulkLoadTimestamp();
            if (bulkLoadTS.isPresent()) {
                sb.append(bulkLoadTS.getAsLong());
            } else {
                sb.append("NotPresent");
            }
        } else {
            sb.append(", seqid=").append(this.getMaxSequenceId());
        }
        sb.append(", majorCompaction=").append(this.isMajorCompactionResult());
        return sb.toString();
    }

    private boolean isSkipResetSeqId(byte[] skipResetSeqId) {
        if (skipResetSeqId != null && skipResetSeqId.length == 1) {
            return Bytes.toBoolean(skipResetSeqId);
        }
        return false;
    }

    @Override
    public OptionalLong getMinimumTimestamp() {
        TimeRange tr = this.getReader().timeRange;
        return tr != null ? OptionalLong.of(tr.getMin()) : OptionalLong.empty();
    }

    @Override
    public OptionalLong getMaximumTimestamp() {
        TimeRange tr = this.getReader().timeRange;
        return tr != null ? OptionalLong.of(tr.getMax()) : OptionalLong.empty();
    }
}

