/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.CellArrayMap;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemstoreSize;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ImmutableSegment
extends Segment {
    private static final long DEEP_OVERHEAD = Segment.DEEP_OVERHEAD + (long)(2 * ClassSize.REFERENCE) + (long)ClassSize.TIMERANGE;
    public static final long DEEP_OVERHEAD_CSLM = DEEP_OVERHEAD + (long)ClassSize.CONCURRENT_SKIPLISTMAP;
    public static final long DEEP_OVERHEAD_CAM = DEEP_OVERHEAD + (long)ClassSize.CELL_ARRAY_MAP;
    private final TimeRange timeRange;
    private Type type = Type.SKIPLIST_MAP_BASED;

    private boolean isFlat() {
        return this.type != Type.SKIPLIST_MAP_BASED;
    }

    protected ImmutableSegment(CellComparator comparator) {
        super(comparator);
        this.timeRange = null;
    }

    protected ImmutableSegment(Segment segment) {
        super(segment);
        this.type = Type.SKIPLIST_MAP_BASED;
        this.timeRange = this.timeRangeTracker == null ? null : this.timeRangeTracker.toTimeRange();
    }

    protected ImmutableSegment(CellComparator comparator, MemStoreSegmentsIterator iterator, MemStoreLAB memStoreLAB, int numOfCells, Type type, boolean merge) {
        super(null, comparator, memStoreLAB);
        this.type = type;
        CellSet cs = this.createCellArrayMapSet(numOfCells, iterator, merge);
        this.setCellSet(null, cs);
        this.timeRange = this.timeRangeTracker == null ? null : this.timeRangeTracker.toTimeRange();
    }

    protected ImmutableSegment(CellComparator comparator, MemStoreSegmentsIterator iterator, MemStoreLAB memStoreLAB) {
        super(new CellSet(comparator), comparator, memStoreLAB);
        this.type = Type.SKIPLIST_MAP_BASED;
        while (iterator.hasNext()) {
            Cell c = (Cell)iterator.next();
            Cell newKV = this.maybeCloneWithAllocator(c);
            boolean usedMSLAB = newKV != c;
            this.internalAdd(newKV, usedMSLAB, null);
        }
        this.timeRange = this.timeRangeTracker == null ? null : this.timeRangeTracker.toTimeRange();
    }

    @Override
    public boolean shouldSeek(TimeRange tr, long oldestUnexpiredTS) {
        return this.timeRange.includesTimeRange(tr) && this.timeRange.getMax() >= oldestUnexpiredTS;
    }

    @Override
    public long getMinTimestamp() {
        return this.timeRange.getMin();
    }

    public int getNumOfSegments() {
        return 1;
    }

    public List<Segment> getAllSegments() {
        ArrayList<Segment> res = new ArrayList<Segment>(Arrays.asList(this));
        return res;
    }

    public boolean flatten(MemstoreSize memstoreSize) {
        if (this.isFlat()) {
            return false;
        }
        CellSet oldCellSet = this.getCellSet();
        int numOfCells = this.getCellsCount();
        CellSet newCellSet = this.recreateCellArrayMapSet(numOfCells);
        this.type = Type.ARRAY_MAP_BASED;
        this.setCellSet(oldCellSet, newCellSet);
        long newSegmentSizeDelta = -(numOfCells * ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY);
        this.incSize(0L, newSegmentSizeDelta += (long)(numOfCells * ClassSize.CELL_ARRAY_MAP_ENTRY));
        if (memstoreSize != null) {
            memstoreSize.incMemstoreSize(0L, newSegmentSizeDelta);
        }
        return true;
    }

    private CellSet createCellArrayMapSet(int numOfCells, MemStoreSegmentsIterator iterator, boolean merge) {
        Cell[] cells = new Cell[numOfCells];
        int i = 0;
        while (iterator.hasNext()) {
            Cell c = (Cell)iterator.next();
            cells[i] = merge ? c : this.maybeCloneWithAllocator(c);
            boolean useMSLAB = this.getMemStoreLAB() != null;
            this.updateMetaInfo(c, true, useMSLAB, null);
            ++i;
        }
        CellArrayMap cam = new CellArrayMap(this.getComparator(), cells, 0, i, false);
        return new CellSet(cam);
    }

    @Override
    protected long heapSizeChange(Cell cell, boolean succ) {
        if (succ) {
            switch (this.type) {
                case SKIPLIST_MAP_BASED: {
                    return super.heapSizeChange(cell, succ);
                }
                case ARRAY_MAP_BASED: {
                    return ClassSize.align((long)ClassSize.CELL_ARRAY_MAP_ENTRY + CellUtil.estimatedHeapSizeOf(cell));
                }
            }
        }
        return 0L;
    }

    private CellSet recreateCellArrayMapSet(int numOfCells) {
        Cell[] cells = new Cell[numOfCells];
        int idx = 0;
        try (KeyValueScanner segmentScanner = this.getScanner(Long.MAX_VALUE);){
            Cell curCell;
            while ((curCell = segmentScanner.next()) != null) {
                cells[idx++] = curCell;
            }
        }
        CellArrayMap cam = new CellArrayMap(this.getComparator(), cells, 0, idx, false);
        return new CellSet(cam);
    }

    public static enum Type {
        SKIPLIST_MAP_BASED,
        ARRAY_MAP_BASED;

    }
}

