/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MemstoreSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface MemStore {
    public MemStoreSnapshot snapshot();

    public void clearSnapshot(long var1) throws UnexpectedStateException;

    public MemstoreSize getFlushableSize();

    public MemstoreSize getSnapshotSize();

    public void add(Cell var1, MemstoreSize var2);

    public void add(Iterable<Cell> var1, MemstoreSize var2);

    public long timeOfOldestEdit();

    public void upsert(Iterable<Cell> var1, long var2, MemstoreSize var4);

    public List<KeyValueScanner> getScanners(long var1) throws IOException;

    public MemstoreSize size();

    public long preFlushSeqIDEstimation();

    public boolean isSloppy();

    default public void startReplayingFromWAL() {
    }

    default public void stopReplayingFromWAL() {
    }
}

