/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MemStoreCompactorSegmentsIterator
extends MemStoreSegmentsIterator {
    private List<Cell> kvs = new ArrayList<Cell>();
    private boolean hasMore;
    private Iterator<Cell> kvsIterator;
    private StoreScanner compactingScanner;

    public MemStoreCompactorSegmentsIterator(List<ImmutableSegment> segments, CellComparator comparator, int compactionKVMax, Store store) throws IOException {
        super(compactionKVMax);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
        int order = segments.size();
        AbstractMemStore.addToScanners(segments, Integer.MAX_VALUE, (long)order, scanners);
        this.compactingScanner = this.createScanner(store, scanners);
        this.hasMore = this.compactingScanner.next(this.kvs, this.scannerContext);
        if (!this.kvs.isEmpty()) {
            this.kvsIterator = this.kvs.iterator();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.kvsIterator == null) {
            return false;
        }
        if (!this.kvsIterator.hasNext() && !this.refillKVS()) {
            return false;
        }
        return this.kvsIterator.hasNext();
    }

    @Override
    public Cell next() {
        if (this.kvsIterator == null) {
            return null;
        }
        if (!this.kvsIterator.hasNext() && !this.refillKVS()) {
            return null;
        }
        return !this.hasMore ? null : this.kvsIterator.next();
    }

    @Override
    public void close() {
        this.compactingScanner.close();
        this.compactingScanner = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private StoreScanner createScanner(Store store, List<KeyValueScanner> scanners) throws IOException {
        return new StoreScanner(store, store.getScanInfo(), OptionalInt.of(Integer.MAX_VALUE), scanners, ScanType.COMPACT_RETAIN_DELETES, store.getSmallestReadPoint(), Long.MIN_VALUE);
    }

    private boolean refillKVS() {
        this.kvs.clear();
        if (!this.hasMore) {
            return false;
        }
        try {
            this.hasMore = this.compactingScanner.next(this.kvs, this.scannerContext);
        }
        catch (IOException ie) {
            throw new IllegalStateException(ie);
        }
        if (!this.kvs.isEmpty()) {
            this.kvsIterator = this.kvs.iterator();
            return true;
        }
        if (this.hasMore) {
            return this.refillKVS();
        }
        return this.hasMore;
    }
}

