/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MemstoreSize {
    private long dataSize;
    private long heapSize;
    private final boolean isEmpty;

    public MemstoreSize() {
        this.dataSize = 0L;
        this.heapSize = 0L;
        this.isEmpty = false;
    }

    public MemstoreSize(boolean isEmpty) {
        this.dataSize = 0L;
        this.heapSize = 0L;
        this.isEmpty = isEmpty;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public MemstoreSize(long dataSize, long heapSize) {
        this.dataSize = dataSize;
        this.heapSize = heapSize;
        this.isEmpty = false;
    }

    public void incMemstoreSize(long dataSizeDelta, long heapSizeDelta) {
        this.dataSize += dataSizeDelta;
        this.heapSize += heapSizeDelta;
    }

    public void incMemstoreSize(MemstoreSize delta) {
        this.dataSize += delta.dataSize;
        this.heapSize += delta.heapSize;
    }

    public void decMemstoreSize(long dataSizeDelta, long heapSizeDelta) {
        this.dataSize -= dataSizeDelta;
        this.heapSize -= heapSizeDelta;
    }

    public void decMemstoreSize(MemstoreSize delta) {
        this.dataSize -= delta.dataSize;
        this.heapSize -= delta.heapSize;
    }

    public long getDataSize() {
        return this.isEmpty ? 0L : this.dataSize;
    }

    public long getHeapSize() {
        return this.isEmpty ? 0L : this.heapSize;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MemstoreSize)) {
            return false;
        }
        MemstoreSize other = (MemstoreSize)obj;
        return this.dataSize == other.dataSize && this.heapSize == other.heapSize;
    }

    public int hashCode() {
        long h = 13L * this.dataSize;
        return (int)(h += 14L * this.heapSize);
    }

    public String toString() {
        return "dataSize=" + this.dataSize + " , heapSize=" + this.heapSize;
    }
}

