/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsRegionServer {
    private MetricsRegionServerSource serverSource;
    private MetricsRegionServerWrapper regionServerWrapper;
    private MetricRegistry metricRegistry;
    private Timer bulkLoadTimer;

    public MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper) {
        this(regionServerWrapper, CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createServer(regionServerWrapper));
        this.metricRegistry = MetricRegistries.global().get(this.serverSource.getMetricRegistryInfo()).get();
        this.bulkLoadTimer = this.metricRegistry.timer("Bulkload");
    }

    MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper, MetricsRegionServerSource serverSource) {
        this.regionServerWrapper = regionServerWrapper;
        this.serverSource = serverSource;
    }

    @VisibleForTesting
    public MetricsRegionServerSource getMetricsSource() {
        return this.serverSource;
    }

    public MetricsRegionServerWrapper getRegionServerWrapper() {
        return this.regionServerWrapper;
    }

    public void updatePutBatch(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowPut();
        }
        this.serverSource.updatePutBatch(t);
    }

    public void updatePut(long t) {
        this.serverSource.updatePut(t);
    }

    public void updateDelete(long t) {
        this.serverSource.updateDelete(t);
    }

    public void updateDeleteBatch(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowDelete();
        }
        this.serverSource.updateDeleteBatch(t);
    }

    public void updateCheckAndDelete(long t) {
        this.serverSource.updateCheckAndDelete(t);
    }

    public void updateCheckAndPut(long t) {
        this.serverSource.updateCheckAndPut(t);
    }

    public void updateGet(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowGet();
        }
        this.serverSource.updateGet(t);
    }

    public void updateIncrement(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowIncrement();
        }
        this.serverSource.updateIncrement(t);
    }

    public void updateAppend(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowAppend();
        }
        this.serverSource.updateAppend(t);
    }

    public void updateReplay(long t) {
        this.serverSource.updateReplay(t);
    }

    public void updateScanSize(long scanSize) {
        this.serverSource.updateScanSize(scanSize);
    }

    public void updateScanTime(long t) {
        this.serverSource.updateScanTime(t);
    }

    public void updateSplitTime(long t) {
        this.serverSource.updateSplitTime(t);
    }

    public void incrSplitRequest() {
        this.serverSource.incrSplitRequest();
    }

    public void incrSplitSuccess() {
        this.serverSource.incrSplitSuccess();
    }

    public void updateFlush(long t, long memstoreSize, long fileSize) {
        this.serverSource.updateFlushTime(t);
        this.serverSource.updateFlushMemstoreSize(memstoreSize);
        this.serverSource.updateFlushOutputSize(fileSize);
    }

    public void updateCompaction(boolean isMajor, long t, int inputFileCount, int outputFileCount, long inputBytes, long outputBytes) {
        this.serverSource.updateCompactionTime(isMajor, t);
        this.serverSource.updateCompactionInputFileCount(isMajor, inputFileCount);
        this.serverSource.updateCompactionOutputFileCount(isMajor, outputFileCount);
        this.serverSource.updateCompactionInputSize(isMajor, inputBytes);
        this.serverSource.updateCompactionOutputSize(isMajor, outputBytes);
    }

    public void updateBulkLoad(long millis) {
        this.bulkLoadTimer.updateMillis(millis);
    }
}

