/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Iterator;
import java.util.SortedSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemstoreSize;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MutableSegment
extends Segment {
    public static final long DEEP_OVERHEAD = Segment.DEEP_OVERHEAD + (long)ClassSize.CONCURRENT_SKIPLISTMAP;

    protected MutableSegment(CellSet cellSet, CellComparator comparator, MemStoreLAB memStoreLAB) {
        super(cellSet, comparator, memStoreLAB);
    }

    public void add(Cell cell, boolean mslabUsed, MemstoreSize memstoreSize) {
        this.internalAdd(cell, mslabUsed, memstoreSize);
    }

    public void upsert(Cell cell, long readpoint, MemstoreSize memstoreSize) {
        this.internalAdd(cell, false, memstoreSize);
        Cell firstCell = CellUtil.createFirstOnRowColTS(cell, Long.MAX_VALUE);
        SortedSet<Cell> ss = this.tailSet(firstCell);
        Iterator it = ss.iterator();
        int versionsVisible = 0;
        while (it.hasNext()) {
            Cell cur = (Cell)it.next();
            if (cell == cur) continue;
            if (!CellUtil.matchingRows(cell, cur) || !CellUtil.matchingQualifier(cell, cur)) break;
            if (cur.getTypeByte() != KeyValue.Type.Put.getCode() || cur.getSequenceId() > readpoint) continue;
            if (versionsVisible >= 1) {
                int cellLen = MutableSegment.getCellLength(cur);
                long heapSize = this.heapSizeChange(cur, true);
                this.incSize(-cellLen, -heapSize);
                if (memstoreSize != null) {
                    memstoreSize.decMemstoreSize(cellLen, heapSize);
                }
                it.remove();
                continue;
            }
            ++versionsVisible;
        }
    }

    @VisibleForTesting
    Cell first() {
        return this.getCellSet().first();
    }

    @Override
    public boolean shouldSeek(TimeRange tr, long oldestUnexpiredTS) {
        return this.timeRangeTracker.includesTimeRange(tr) && this.timeRangeTracker.getMax() >= oldestUnexpiredTS;
    }

    @Override
    public long getMinTimestamp() {
        return this.timeRangeTracker.getMin();
    }
}

