/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionMergeRequest
implements Runnable {
    private static final Log LOG = LogFactory.getLog(RegionMergeRequest.class);
    private final HRegionInfo region_a;
    private final HRegionInfo region_b;
    private final HRegionServer server;
    private final boolean forcible;
    private final User user;

    RegionMergeRequest(Region a, Region b, HRegionServer hrs, boolean forcible, long masterSystemTime, User user) {
        Preconditions.checkNotNull(hrs);
        this.region_a = a.getRegionInfo();
        this.region_b = b.getRegionInfo();
        this.server = hrs;
        this.forcible = forcible;
        this.user = user;
    }

    public String toString() {
        return "MergeRequest,regions:" + this.region_a + ", " + this.region_b + ", forcible=" + this.forcible;
    }

    private void doMerge() {
        boolean success = false;
        if (this.user != null && this.user.getUGI() != null) {
            this.user.getUGI().doAs(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    RegionMergeRequest.this.requestRegionMerge();
                    return null;
                }
            });
        } else {
            this.requestRegionMerge();
        }
    }

    private void requestRegionMerge() {
        TableName table = this.region_a.getTable();
        if (!table.equals(this.region_b.getTable())) {
            LOG.error((Object)("Can't merge regions from two different tables: " + this.region_a + ", " + this.region_b));
            return;
        }
        HRegionInfo merged = new HRegionInfo(table);
        if (!this.server.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_MERGE, merged, this.region_a, this.region_b)) {
            LOG.error((Object)("Unable to ask master to merge: " + this.region_a + ", " + this.region_b));
        }
    }

    @Override
    public void run() {
        if (this.server.isStopping() || this.server.isStopped()) {
            LOG.debug((Object)("Skipping merge because server is stopping=" + this.server.isStopping() + " or stopped=" + this.server.isStopped()));
            return;
        }
        this.doMerge();
    }
}

