/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.MemoryType;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.FlushType;
import org.apache.hadoop.hbase.regionserver.MemstoreSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServerAccounting {
    private final LongAdder globalMemstoreDataSize = new LongAdder();
    private final LongAdder globalMemstoreHeapSize = new LongAdder();
    private final ConcurrentMap<byte[], MemstoreSize> replayEditsPerRegion = new ConcurrentSkipListMap<byte[], MemstoreSize>(Bytes.BYTES_COMPARATOR);
    private long globalMemStoreLimit;
    private final float globalMemStoreLimitLowMarkPercent;
    private long globalMemStoreLimitLowMark;
    private final MemoryType memType;
    private long globalOnHeapMemstoreLimit;
    private long globalOnHeapMemstoreLimitLowMark;

    public RegionServerAccounting(Configuration conf) {
        Pair<Long, MemoryType> globalMemstoreSizePair = MemorySizeUtil.getGlobalMemstoreSize(conf);
        this.globalMemStoreLimit = globalMemstoreSizePair.getFirst();
        this.memType = globalMemstoreSizePair.getSecond();
        this.globalMemStoreLimitLowMarkPercent = MemorySizeUtil.getGlobalMemStoreHeapLowerMark(conf, this.memType == MemoryType.HEAP);
        this.globalMemStoreLimitLowMark = (long)((float)this.globalMemStoreLimit * this.globalMemStoreLimitLowMarkPercent);
        this.globalOnHeapMemstoreLimit = MemorySizeUtil.getOnheapGlobalMemstoreSize(conf);
        this.globalOnHeapMemstoreLimitLowMark = (long)((float)this.globalOnHeapMemstoreLimit * this.globalMemStoreLimitLowMarkPercent);
    }

    long getGlobalMemstoreLimit() {
        return this.globalMemStoreLimit;
    }

    long getGlobalOnHeapMemstoreLimit() {
        return this.globalOnHeapMemstoreLimit;
    }

    void setGlobalMemstoreLimits(long newGlobalMemstoreLimit) {
        if (this.memType == MemoryType.HEAP) {
            this.globalMemStoreLimit = newGlobalMemstoreLimit;
            this.globalMemStoreLimitLowMark = (long)((float)this.globalMemStoreLimit * this.globalMemStoreLimitLowMarkPercent);
        } else {
            this.globalOnHeapMemstoreLimit = newGlobalMemstoreLimit;
            this.globalOnHeapMemstoreLimitLowMark = (long)((float)this.globalOnHeapMemstoreLimit * this.globalMemStoreLimitLowMarkPercent);
        }
    }

    boolean isOffheap() {
        return this.memType == MemoryType.NON_HEAP;
    }

    long getGlobalMemstoreLimitLowMark() {
        return this.globalMemStoreLimitLowMark;
    }

    float getGlobalMemstoreLimitLowMarkPercent() {
        return this.globalMemStoreLimitLowMarkPercent;
    }

    public long getGlobalMemstoreDataSize() {
        return this.globalMemstoreDataSize.sum();
    }

    public long getGlobalMemstoreHeapSize() {
        return this.globalMemstoreHeapSize.sum();
    }

    public void incGlobalMemstoreSize(MemstoreSize memStoreSize) {
        this.globalMemstoreDataSize.add(memStoreSize.getDataSize());
        this.globalMemstoreHeapSize.add(memStoreSize.getHeapSize());
    }

    public void decGlobalMemstoreSize(MemstoreSize memStoreSize) {
        this.globalMemstoreDataSize.add(-memStoreSize.getDataSize());
        this.globalMemstoreHeapSize.add(-memStoreSize.getHeapSize());
    }

    public FlushType isAboveHighWaterMark() {
        if (this.memType == MemoryType.HEAP) {
            if (this.getGlobalMemstoreHeapSize() >= this.globalMemStoreLimit) {
                return FlushType.ABOVE_ONHEAP_HIGHER_MARK;
            }
        } else {
            if (this.getGlobalMemstoreDataSize() >= this.globalMemStoreLimit) {
                return FlushType.ABOVE_OFFHEAP_HIGHER_MARK;
            }
            if (this.getGlobalMemstoreHeapSize() >= this.globalOnHeapMemstoreLimit) {
                return FlushType.ABOVE_ONHEAP_HIGHER_MARK;
            }
        }
        return FlushType.NORMAL;
    }

    public FlushType isAboveLowWaterMark() {
        if (this.memType == MemoryType.HEAP) {
            if (this.getGlobalMemstoreHeapSize() >= this.globalMemStoreLimitLowMark) {
                return FlushType.ABOVE_ONHEAP_LOWER_MARK;
            }
        } else {
            if (this.getGlobalMemstoreDataSize() >= this.globalMemStoreLimitLowMark) {
                return FlushType.ABOVE_OFFHEAP_LOWER_MARK;
            }
            if (this.getGlobalMemstoreHeapSize() >= this.globalOnHeapMemstoreLimitLowMark) {
                return FlushType.ABOVE_ONHEAP_LOWER_MARK;
            }
        }
        return FlushType.NORMAL;
    }

    public double getFlushPressure() {
        if (this.memType == MemoryType.HEAP) {
            return (double)this.getGlobalMemstoreHeapSize() * 1.0 / (double)this.globalMemStoreLimitLowMark;
        }
        return Math.max((double)this.getGlobalMemstoreDataSize() * 1.0 / (double)this.globalMemStoreLimitLowMark, (double)this.getGlobalMemstoreHeapSize() * 1.0 / (double)this.globalOnHeapMemstoreLimitLowMark);
    }

    public void addRegionReplayEditsSize(byte[] regionName, MemstoreSize memStoreSize) {
        MemstoreSize replayEdistsSize = (MemstoreSize)this.replayEditsPerRegion.get(regionName);
        if (replayEdistsSize == null) {
            replayEdistsSize = new MemstoreSize();
            this.replayEditsPerRegion.put(regionName, replayEdistsSize);
        }
        replayEdistsSize.incMemstoreSize(memStoreSize);
    }

    public void rollbackRegionReplayEditsSize(byte[] regionName) {
        MemstoreSize replayEditsSize = (MemstoreSize)this.replayEditsPerRegion.get(regionName);
        if (replayEditsSize != null) {
            this.clearRegionReplayEditsSize(regionName);
            this.decGlobalMemstoreSize(replayEditsSize);
        }
    }

    public void clearRegionReplayEditsSize(byte[] regionName) {
        this.replayEditsPerRegion.remove(regionName);
    }
}

