/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MemstoreSize;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServicesForStores {
    private static final int POOL_SIZE = 10;
    private static final ThreadPoolExecutor INMEMORY_COMPACTION_POOL = new ThreadPoolExecutor(10, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            String name = Thread.currentThread().getName() + "-inmemoryCompactions-" + System.currentTimeMillis();
            return new Thread(r, name);
        }
    });
    private final HRegion region;

    public RegionServicesForStores(HRegion region) {
        this.region = region;
    }

    public void blockUpdates() {
        this.region.blockUpdates();
    }

    public void unblockUpdates() {
        this.region.unblockUpdates();
    }

    public void addMemstoreSize(MemstoreSize size) {
        this.region.addAndGetMemstoreSize(size);
    }

    public HRegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    public WAL getWAL() {
        return this.region.getWAL();
    }

    public ThreadPoolExecutor getInMemoryCompactionPool() {
        return INMEMORY_COMPACTION_POOL;
    }

    public long getMemstoreFlushSize() {
        return this.region.getMemstoreFlushSize();
    }

    public int getNumStores() {
        return this.region.getTableDescriptor().getColumnFamilyCount();
    }

    long getMemstoreSize() {
        return this.region.getMemstoreSize();
    }
}

