/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ReversedKeyValueHeap;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ReversedRegionScannerImpl
extends HRegion.RegionScannerImpl {
    ReversedRegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
        HRegion hRegion = region;
        hRegion.getClass();
        super(scan, additionalScanners, region);
    }

    @Override
    protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
        this.storeHeap = new ReversedKeyValueHeap(scanners, this.comparator);
        if (!joinedScanners.isEmpty()) {
            this.joinedHeap = new ReversedKeyValueHeap(joinedScanners, this.comparator);
        }
    }

    @Override
    protected boolean shouldStop(Cell currentRowCell) {
        if (currentRowCell == null) {
            return true;
        }
        if (this.stopRow == null || Bytes.equals(this.stopRow, HConstants.EMPTY_START_ROW)) {
            return false;
        }
        int c = this.comparator.compareRows(currentRowCell, this.stopRow, 0, this.stopRow.length);
        return c < 0 || c == 0 && !this.includeStopRow;
    }

    @Override
    protected boolean nextRow(ScannerContext scannerContext, Cell curRowCell) throws IOException {
        assert (this.joinedContinuationRow == null) : "Trying to go to next row during joinedHeap read.";
        this.storeHeap.seekToPreviousRow(CellUtil.createFirstOnRow(curRowCell));
        this.resetFilters();
        if (this.region.getCoprocessorHost() != null) {
            return this.region.getCoprocessorHost().postScannerFilterRow(this, curRowCell);
        }
        return true;
    }
}

