/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@VisibleForTesting
public class ScanInfo {
    private byte[] family;
    private int minVersions;
    private int maxVersions;
    private long ttl;
    private KeepDeletedCells keepDeletedCells;
    private long timeToPurgeDeletes;
    private CellComparator comparator;
    private long tableMaxRowSize;
    private boolean usePread;
    private long cellsPerTimeoutCheck;
    private boolean parallelSeekEnabled;
    private final long preadMaxBytes;
    private final Configuration conf;
    private final boolean newVersionBehavior;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 8 + 32 + 4);

    public ScanInfo(Configuration conf, ColumnFamilyDescriptor family, long ttl, long timeToPurgeDeletes, CellComparator comparator) {
        this(conf, family.getName(), family.getMinVersions(), family.getMaxVersions(), ttl, family.getKeepDeletedCells(), family.getBlocksize(), timeToPurgeDeletes, comparator, family.isNewVersionBehavior());
    }

    public ScanInfo(Configuration conf, byte[] family, int minVersions, int maxVersions, long ttl, KeepDeletedCells keepDeletedCells, long blockSize, long timeToPurgeDeletes, CellComparator comparator, boolean newVersionBehavior) {
        this.family = family;
        this.minVersions = minVersions;
        this.maxVersions = maxVersions;
        this.ttl = ttl;
        this.keepDeletedCells = keepDeletedCells;
        this.timeToPurgeDeletes = timeToPurgeDeletes;
        this.comparator = comparator;
        this.tableMaxRowSize = conf.getLong("hbase.table.max.rowsize", 0x40000000L);
        this.usePread = conf.getBoolean("hbase.storescanner.use.pread", false);
        long perHeartbeat = conf.getLong("hbase.cells.scanned.per.heartbeat.check", 10000L);
        this.cellsPerTimeoutCheck = perHeartbeat > 0L ? perHeartbeat : 10000L;
        this.parallelSeekEnabled = conf.getBoolean("hbase.storescanner.parallel.seek.enable", false);
        this.preadMaxBytes = conf.getLong("hbase.storescanner.pread.max.bytes", 4L * blockSize);
        this.conf = conf;
        this.newVersionBehavior = newVersionBehavior;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    long getTableMaxRowSize() {
        return this.tableMaxRowSize;
    }

    boolean isUsePread() {
        return this.usePread;
    }

    long getCellsPerTimeoutCheck() {
        return this.cellsPerTimeoutCheck;
    }

    boolean isParallelSeekEnabled() {
        return this.parallelSeekEnabled;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public int getMinVersions() {
        return this.minVersions;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public long getTtl() {
        return this.ttl;
    }

    public KeepDeletedCells getKeepDeletedCells() {
        return this.keepDeletedCells;
    }

    public long getTimeToPurgeDeletes() {
        return this.timeToPurgeDeletes;
    }

    public CellComparator getComparator() {
        return this.comparator;
    }

    long getPreadMaxBytes() {
        return this.preadMaxBytes;
    }

    public boolean isNewVersionBehavior() {
        return this.newVersionBehavior;
    }
}

