/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.CompositeImmutableSegment;
import org.apache.hadoop.hbase.regionserver.ImmutableMemStoreLAB;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class SegmentFactory {
    private static SegmentFactory instance = new SegmentFactory();

    private SegmentFactory() {
    }

    public static SegmentFactory instance() {
        return instance;
    }

    public ImmutableSegment createImmutableSegment(Configuration conf, CellComparator comparator, MemStoreSegmentsIterator iterator) {
        return new ImmutableSegment(comparator, iterator, MemStoreLAB.newInstance(conf));
    }

    public CompositeImmutableSegment createCompositeImmutableSegment(CellComparator comparator, List<ImmutableSegment> segments) {
        return new CompositeImmutableSegment(comparator, segments);
    }

    public ImmutableSegment createImmutableSegmentByCompaction(Configuration conf, CellComparator comparator, MemStoreSegmentsIterator iterator, int numOfCells, ImmutableSegment.Type segmentType) throws IOException {
        Preconditions.checkArgument(segmentType == ImmutableSegment.Type.ARRAY_MAP_BASED, "wrong immutable segment type");
        MemStoreLAB memStoreLAB = MemStoreLAB.newInstance(conf);
        return new ImmutableSegment(comparator, iterator, memStoreLAB, numOfCells, segmentType, false);
    }

    public ImmutableSegment createImmutableSegment(CellComparator comparator) {
        MutableSegment segment = this.generateMutableSegment(null, comparator, null);
        return this.createImmutableSegment(segment);
    }

    public ImmutableSegment createImmutableSegment(MutableSegment segment) {
        return new ImmutableSegment(segment);
    }

    public MutableSegment createMutableSegment(Configuration conf, CellComparator comparator) {
        MemStoreLAB memStoreLAB = MemStoreLAB.newInstance(conf);
        return this.generateMutableSegment(conf, comparator, memStoreLAB);
    }

    public ImmutableSegment createImmutableSegmentByMerge(Configuration conf, CellComparator comparator, MemStoreSegmentsIterator iterator, int numOfCells, ImmutableSegment.Type segmentType, List<ImmutableSegment> segments) throws IOException {
        Preconditions.checkArgument(segmentType == ImmutableSegment.Type.ARRAY_MAP_BASED, "wrong immutable segment type");
        MemStoreLAB memStoreLAB = this.getMergedMemStoreLAB(conf, segments);
        return new ImmutableSegment(comparator, iterator, memStoreLAB, numOfCells, segmentType, true);
    }

    private MutableSegment generateMutableSegment(Configuration conf, CellComparator comparator, MemStoreLAB memStoreLAB) {
        CellSet set = new CellSet(comparator);
        return new MutableSegment(set, comparator, memStoreLAB);
    }

    private MemStoreLAB getMergedMemStoreLAB(Configuration conf, List<ImmutableSegment> segments) {
        ArrayList<MemStoreLAB> mslabs = new ArrayList<MemStoreLAB>();
        if (!conf.getBoolean("hbase.hregion.memstore.mslab.enabled", true)) {
            return null;
        }
        for (ImmutableSegment segment : segments) {
            mslabs.add(segment.getMemStoreLAB());
        }
        return new ImmutableMemStoreLAB(mslabs);
    }
}

