/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class SplitRequest
implements Runnable {
    private static final Log LOG = LogFactory.getLog(SplitRequest.class);
    private final HRegionInfo parent;
    private final byte[] midKey;
    private final HRegionServer server;
    private final User user;

    SplitRequest(Region region, byte[] midKey, HRegionServer hrs, User user) {
        Preconditions.checkNotNull(hrs);
        this.parent = region.getRegionInfo();
        this.midKey = midKey;
        this.server = hrs;
        this.user = user;
    }

    public String toString() {
        return "regionName=" + this.parent + ", midKey=" + Bytes.toStringBinary(this.midKey);
    }

    private void doSplitting() {
        this.server.metricsRegionServer.incrSplitRequest();
        if (this.user != null && this.user.getUGI() != null) {
            this.user.getUGI().doAs(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SplitRequest.this.requestRegionSplit();
                    return null;
                }
            });
        } else {
            this.requestRegionSplit();
        }
    }

    private void requestRegionSplit() {
        TableName table = this.parent.getTable();
        HRegionInfo hri_a = new HRegionInfo(table, this.parent.getStartKey(), this.midKey);
        HRegionInfo hri_b = new HRegionInfo(table, this.midKey, this.parent.getEndKey());
        if (!this.server.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_SPLIT, this.parent, hri_a, hri_b)) {
            LOG.error((Object)("Unable to ask master to split " + this.parent.getRegionNameAsString()));
        }
    }

    @Override
    public void run() {
        if (this.server.isStopping() || this.server.isStopped()) {
            LOG.debug((Object)("Skipping split because server is stopping=" + this.server.isStopping() + " or stopped=" + this.server.isStopped()));
            return;
        }
        this.doSplitting();
    }
}

