/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemstoreSize;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface Store
extends HeapSize,
StoreConfigInformation,
PropagatingConfigurationObserver {
    public static final int PRIORITY_USER = 1;
    public static final int NO_PRIORITY = Integer.MIN_VALUE;

    public CellComparator getComparator();

    public Collection<StoreFile> getStorefiles();

    public Collection<StoreFile> getCompactedFiles();

    public Collection<StoreFile> close() throws IOException;

    public KeyValueScanner getScanner(Scan var1, NavigableSet<byte[]> var2, long var3) throws IOException;

    default public List<KeyValueScanner> getScanners(boolean cacheBlocks, boolean isGet, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, byte[] stopRow, long readPt) throws IOException {
        return this.getScanners(cacheBlocks, usePread, isCompaction, matcher, startRow, true, stopRow, false, readPt);
    }

    public List<KeyValueScanner> getScanners(boolean var1, boolean var2, boolean var3, ScanQueryMatcher var4, byte[] var5, boolean var6, byte[] var7, boolean var8, long var9) throws IOException;

    public List<KeyValueScanner> recreateScanners(List<KeyValueScanner> var1, boolean var2, boolean var3, boolean var4, ScanQueryMatcher var5, byte[] var6, boolean var7, byte[] var8, boolean var9, long var10, boolean var12) throws IOException;

    default public List<KeyValueScanner> getScanners(List<StoreFile> files, boolean cacheBlocks, boolean isGet, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, byte[] stopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
        return this.getScanners(files, cacheBlocks, usePread, isCompaction, matcher, startRow, true, stopRow, false, readPt, includeMemstoreScanner);
    }

    public List<KeyValueScanner> getScanners(List<StoreFile> var1, boolean var2, boolean var3, boolean var4, ScanQueryMatcher var5, byte[] var6, boolean var7, byte[] var8, boolean var9, long var10, boolean var12) throws IOException;

    public ScanInfo getScanInfo();

    public long timeOfOldestEdit();

    public FileSystem getFileSystem();

    public StoreFileWriter createWriterInTmp(long var1, Compression.Algorithm var3, boolean var4, boolean var5, boolean var6) throws IOException;

    public StoreFileWriter createWriterInTmp(long var1, Compression.Algorithm var3, boolean var4, boolean var5, boolean var6, boolean var7) throws IOException;

    public StoreFileWriter createWriterInTmp(long var1, Compression.Algorithm var3, boolean var4, boolean var5, boolean var6, boolean var7, TimeRangeTracker var8) throws IOException;

    public boolean throttleCompaction(long var1);

    public CompactionProgress getCompactionProgress();

    default public Optional<CompactionContext> requestCompaction() throws IOException {
        return this.requestCompaction(Integer.MIN_VALUE, CompactionLifeCycleTracker.DUMMY, null);
    }

    public Optional<CompactionContext> requestCompaction(int var1, CompactionLifeCycleTracker var2, User var3) throws IOException;

    public void cancelRequestedCompaction(CompactionContext var1);

    @Deprecated
    public List<StoreFile> compact(CompactionContext var1, ThroughputController var2) throws IOException;

    public List<StoreFile> compact(CompactionContext var1, ThroughputController var2, User var3) throws IOException;

    public boolean isMajorCompaction() throws IOException;

    public void triggerMajorCompaction();

    public boolean needsCompaction();

    public int getCompactPriority();

    public StoreFlushContext createFlushContext(long var1);

    public boolean canSplit();

    public byte[] getSplitPoint();

    public boolean hasReferences();

    @Deprecated
    public long getMemStoreSize();

    public MemstoreSize getSizeOfMemStore();

    @Deprecated
    public long getFlushableSize();

    public MemstoreSize getSizeToFlush();

    @Deprecated
    public long getSnapshotSize();

    public MemstoreSize getSizeOfSnapshot();

    public ColumnFamilyDescriptor getColumnFamilyDescriptor();

    public long getMaxSequenceId();

    public long getMaxMemstoreTS();

    public HFileDataBlockEncoder getDataBlockEncoder();

    public long getLastCompactSize();

    public long getSize();

    public int getStorefilesCount();

    public int getCompactedFilesCount();

    public long getMaxStoreFileAge();

    public long getMinStoreFileAge();

    public long getAvgStoreFileAge();

    public long getNumReferenceFiles();

    public long getNumHFiles();

    public long getStoreSizeUncompressed();

    public long getStorefilesSize();

    public long getHFilesSize();

    public long getStorefilesIndexSize();

    public long getTotalStaticIndexSize();

    public long getTotalStaticBloomSize();

    public CacheConfig getCacheConfig();

    public HRegionInfo getRegionInfo();

    public RegionCoprocessorHost getCoprocessorHost();

    public boolean areWritesEnabled();

    public long getSmallestReadPoint();

    public String getColumnFamilyName();

    public TableName getTableName();

    public long getFlushedCellsCount();

    public long getFlushedCellsSize();

    public long getFlushedOutputFileSize();

    public long getCompactedCellsCount();

    public long getCompactedCellsSize();

    public long getMajorCompactedCellsCount();

    public long getMajorCompactedCellsSize();

    public void addChangedReaderObserver(ChangedReadersObserver var1);

    public void deleteChangedReaderObserver(ChangedReadersObserver var1);

    public boolean hasTooManyStoreFiles();

    public void refreshStoreFiles() throws IOException;

    public double getCompactionPressure();

    public void refreshStoreFiles(Collection<String> var1) throws IOException;

    public boolean isPrimaryReplicaStore();

    public void closeAndArchiveCompactedFiles() throws IOException;

    public boolean isSloppyMemstore();
}

