/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Comparator;
import java.util.OptionalLong;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface StoreFile {
    public static final String STORE_FILE_READER_NO_READAHEAD = "hbase.store.reader.no-readahead";
    public static final byte[] MAX_SEQ_ID_KEY = Bytes.toBytes("MAX_SEQ_ID_KEY");
    public static final byte[] MAJOR_COMPACTION_KEY = Bytes.toBytes("MAJOR_COMPACTION_KEY");
    public static final byte[] EXCLUDE_FROM_MINOR_COMPACTION_KEY = Bytes.toBytes("EXCLUDE_FROM_MINOR_COMPACTION");
    public static final byte[] BLOOM_FILTER_TYPE_KEY = Bytes.toBytes("BLOOM_FILTER_TYPE");
    public static final byte[] DELETE_FAMILY_COUNT = Bytes.toBytes("DELETE_FAMILY_COUNT");
    public static final byte[] LAST_BLOOM_KEY = Bytes.toBytes("LAST_BLOOM_KEY");
    public static final byte[] TIMERANGE_KEY = Bytes.toBytes("TIMERANGE");
    public static final byte[] EARLIEST_PUT_TS = Bytes.toBytes("EARLIEST_PUT_TS");
    public static final byte[] MOB_CELLS_COUNT = Bytes.toBytes("MOB_CELLS_COUNT");
    public static final byte[] BULKLOAD_TASK_KEY = Bytes.toBytes("BULKLOAD_SOURCE_TASK");
    public static final byte[] BULKLOAD_TIME_KEY = Bytes.toBytes("BULKLOAD_TIMESTAMP");
    public static final byte[] SKIP_RESET_SEQ_ID = Bytes.toBytes("SKIP_RESET_SEQ_ID");

    public CacheConfig getCacheConf();

    public Cell getFirstKey();

    public Cell getLastKey();

    public Comparator<Cell> getComparator();

    public long getMaxMemstoreTS();

    public StoreFileInfo getFileInfo();

    public Path getPath();

    public Path getQualifiedPath();

    public boolean isReference();

    public boolean isHFile();

    public boolean isMajorCompactionResult();

    public boolean excludeFromMinorCompaction();

    public long getMaxSequenceId();

    public long getModificationTimeStamp() throws IOException;

    public byte[] getMetadataValue(byte[] var1);

    public boolean isBulkLoadResult();

    public boolean isCompactedAway();

    public boolean isReferencedInReads();

    public OptionalLong getBulkLoadTimestamp();

    public HDFSBlocksDistribution getHDFSBlockDistribution();

    public void initReader() throws IOException;

    public StoreFileScanner getPreadScanner(boolean var1, long var2, long var4, boolean var6);

    public StoreFileScanner getStreamScanner(boolean var1, boolean var2, boolean var3, long var4, long var6, boolean var8) throws IOException;

    public StoreFileReader getReader();

    public void closeReader(boolean var1) throws IOException;

    public void markCompactedAway();

    public void deleteReader() throws IOException;

    public String toStringDetailed();

    public OptionalLong getMinimumTimestamp();

    public OptionalLong getMaximumTimestamp();
}

