/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Comparator;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Function;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Ordering;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class StoreFileComparators {
    public static final Comparator<StoreFile> SEQ_ID = Ordering.compound(ImmutableList.of(Ordering.natural().onResultOf(new GetSeqId()), Ordering.natural().onResultOf(new GetFileSize()).reverse(), Ordering.natural().onResultOf(new GetBulkTime()), Ordering.natural().onResultOf(new GetPathName())));
    public static final Comparator<StoreFile> SEQ_ID_MAX_TIMESTAMP = Ordering.compound(ImmutableList.of(Ordering.natural().onResultOf(new GetSeqId()), Ordering.natural().onResultOf(new GetMaxTimestamp()), Ordering.natural().onResultOf(new GetFileSize()).reverse(), Ordering.natural().onResultOf(new GetBulkTime()), Ordering.natural().onResultOf(new GetPathName())));

    StoreFileComparators() {
    }

    private static class GetMaxTimestamp
    implements Function<StoreFile, Long> {
        private GetMaxTimestamp() {
        }

        @Override
        public Long apply(StoreFile sf) {
            return sf.getMaximumTimestamp().orElse(Long.MAX_VALUE);
        }
    }

    private static class GetPathName
    implements Function<StoreFile, String> {
        private GetPathName() {
        }

        @Override
        public String apply(StoreFile sf) {
            return sf.getPath().getName();
        }
    }

    private static class GetBulkTime
    implements Function<StoreFile, Long> {
        private GetBulkTime() {
        }

        @Override
        public Long apply(StoreFile sf) {
            return sf.getBulkLoadTimestamp().orElse(Long.MAX_VALUE);
        }
    }

    private static class GetFileSize
    implements Function<StoreFile, Long> {
        private GetFileSize() {
        }

        @Override
        public Long apply(StoreFile sf) {
            if (sf.getReader() != null) {
                return sf.getReader().length();
            }
            return -1L;
        }
    }

    private static class GetSeqId
    implements Function<StoreFile, Long> {
        private GetSeqId() {
        }

        @Override
        public Long apply(StoreFile sf) {
            return sf.getMaxSequenceId();
        }
    }
}

