/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class StoreUtils {
    private static final Log LOG = LogFactory.getLog(StoreUtils.class);

    public static OptionalInt getDeterministicRandomSeed(Collection<StoreFile> files) {
        return files.stream().mapToInt(f -> f.getPath().getName().hashCode()).findFirst();
    }

    public static boolean hasReferences(Collection<StoreFile> files) {
        if (files != null) {
            for (StoreFile hsf : files) {
                if (!hsf.isReference()) continue;
                return true;
            }
        }
        return false;
    }

    public static long getLowestTimestamp(Collection<StoreFile> candidates) throws IOException {
        long minTs = Long.MAX_VALUE;
        for (StoreFile storeFile : candidates) {
            minTs = Math.min(minTs, storeFile.getModificationTimeStamp());
        }
        return minTs;
    }

    static Optional<StoreFile> getLargestFile(Collection<StoreFile> candidates) {
        return candidates.stream().filter(f -> f.getReader() != null).max((f1, f2) -> Long.compare(f1.getReader().length(), f2.getReader().length()));
    }

    public static long getMaxMemstoreTSInList(Collection<StoreFile> sfs) {
        long max = 0L;
        for (StoreFile sf : sfs) {
            if (sf.isBulkLoadResult()) continue;
            max = Math.max(max, sf.getMaxMemstoreTS());
        }
        return max;
    }

    public static long getMaxSequenceIdInList(Collection<StoreFile> sfs) {
        long max = 0L;
        for (StoreFile sf : sfs) {
            max = Math.max(max, sf.getMaxSequenceId());
        }
        return max;
    }

    static Optional<byte[]> getFileSplitPoint(StoreFile file, CellComparator comparator) throws IOException {
        StoreFileReader reader = file.getReader();
        if (reader == null) {
            LOG.warn((Object)("Storefile " + file + " Reader is null; cannot get split point"));
            return Optional.empty();
        }
        Cell midkey = reader.midkey();
        if (midkey != null) {
            Cell firstKey = reader.getFirstKey();
            Cell lastKey = reader.getLastKey();
            if (comparator.compareRows(midkey, firstKey) == 0 || comparator.compareRows(midkey, lastKey) == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"cannot split because midkey is the same as first or last row");
                }
                return Optional.empty();
            }
            return Optional.of(CellUtil.cloneRow(midkey));
        }
        return Optional.empty();
    }
}

