/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompactionRequest {
    private boolean isOffPeak = false;
    private DisplayCompactionType isMajor = DisplayCompactionType.MINOR;
    private int priority = Integer.MIN_VALUE;
    private Collection<StoreFile> filesToCompact;
    private long selectionTime;
    private long timeInNanos;
    private String regionName = "";
    private String storeName = "";
    private long totalSize = -1L;
    private CompactionLifeCycleTracker tracker = CompactionLifeCycleTracker.DUMMY;

    public CompactionRequest(Collection<StoreFile> files) {
        this.selectionTime = EnvironmentEdgeManager.currentTime();
        this.timeInNanos = System.nanoTime();
        this.filesToCompact = Preconditions.checkNotNull(files, "files for compaction can not null");
        this.recalculateSize();
    }

    public void updateFiles(Collection<StoreFile> files) {
        this.filesToCompact = Preconditions.checkNotNull(files, "files for compaction can not null");
        this.recalculateSize();
    }

    public Collection<StoreFile> getFiles() {
        return this.filesToCompact;
    }

    public void setDescription(String regionName, String storeName) {
        this.regionName = regionName;
        this.storeName = storeName;
    }

    public long getSize() {
        return this.totalSize;
    }

    public boolean isAllFiles() {
        return this.isMajor == DisplayCompactionType.MAJOR || this.isMajor == DisplayCompactionType.ALL_FILES;
    }

    public boolean isMajor() {
        return this.isMajor == DisplayCompactionType.MAJOR;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public boolean isOffPeak() {
        return this.isOffPeak;
    }

    public void setOffPeak(boolean value) {
        this.isOffPeak = value;
    }

    public long getSelectionTime() {
        return this.selectionTime;
    }

    public long getSelectionNanoTime() {
        return this.timeInNanos;
    }

    public void setIsMajor(boolean isMajor, boolean isAllFiles) {
        assert (isAllFiles || !isMajor);
        this.isMajor = !isAllFiles ? DisplayCompactionType.MINOR : (isMajor ? DisplayCompactionType.MAJOR : DisplayCompactionType.ALL_FILES);
    }

    public void setTracker(CompactionLifeCycleTracker tracker) {
        this.tracker = tracker;
    }

    public CompactionLifeCycleTracker getTracker() {
        return this.tracker;
    }

    public String toString() {
        String fsList = this.filesToCompact.stream().filter(f -> f.getReader() != null).map(f -> StringUtils.TraditionalBinaryPrefix.long2String(f.getReader().length(), "", 1)).collect(Collectors.joining(", "));
        return "regionName=" + this.regionName + ", storeName=" + this.storeName + ", fileCount=" + this.getFiles().size() + ", fileSize=" + StringUtils.TraditionalBinaryPrefix.long2String(this.totalSize, "", 1) + (fsList.isEmpty() ? "" : " (" + fsList + ")") + ", priority=" + this.priority + ", time=" + this.timeInNanos;
    }

    private void recalculateSize() {
        this.totalSize = this.filesToCompact.stream().map(StoreFile::getReader).mapToLong(r -> r != null ? r.length() : 0L).sum();
    }

    private static enum DisplayCompactionType {
        MINOR,
        ALL_FILES,
        MAJOR;

    }
}

