/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CloseRegionHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(CloseRegionHandler.class);
    private final RegionServerServices rsServices;
    private final HRegionInfo regionInfo;
    private final boolean abort;
    private ServerName destination;

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, ServerName destination) {
        this(server, rsServices, regionInfo, abort, EventType.M_RS_CLOSE_REGION, destination);
    }

    protected CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, EventType eventType, ServerName destination) {
        super(server, eventType);
        this.server = server;
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
        this.abort = abort;
        this.destination = destination;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            String name = this.regionInfo.getRegionNameAsString();
            LOG.debug((Object)("Processing close of " + name));
            String encodedRegionName = this.regionInfo.getEncodedName();
            HRegion region = (HRegion)this.rsServices.getFromOnlineRegions(encodedRegionName);
            if (region == null) {
                LOG.warn((Object)("Received CLOSE for region " + name + " but currently not serving - ignoring"));
                return;
            }
            if (region.close(this.abort) == null) {
                LOG.warn((Object)("Can't close region: was already closed during close(): " + name));
                return;
            }
            this.rsServices.removeFromOnlineRegions(region, this.destination);
            this.rsServices.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED, this.regionInfo);
            LOG.debug((Object)("Closed " + region.getRegionInfo().getRegionNameAsString()));
        }
        finally {
            this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes(), Boolean.FALSE);
        }
    }
}

