/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.snapshot;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.snapshot.RegionServerSnapshotManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FlushSnapshotSubprocedure
extends Subprocedure {
    private static final Log LOG = LogFactory.getLog(FlushSnapshotSubprocedure.class);
    private final List<Region> regions;
    private final SnapshotProtos.SnapshotDescription snapshot;
    private final RegionServerSnapshotManager.SnapshotSubprocedurePool taskManager;
    private boolean snapshotSkipFlush = false;
    static final int MAX_RETRIES = 3;

    public FlushSnapshotSubprocedure(ProcedureMember member, ForeignExceptionDispatcher errorListener, long wakeFrequency, long timeout, List<Region> regions, SnapshotProtos.SnapshotDescription snapshot, RegionServerSnapshotManager.SnapshotSubprocedurePool taskManager) {
        super(member, snapshot.getName(), errorListener, wakeFrequency, timeout);
        this.snapshot = snapshot;
        if (this.snapshot.getType() == SnapshotProtos.SnapshotDescription.Type.SKIPFLUSH) {
            this.snapshotSkipFlush = true;
        }
        this.regions = regions;
        this.taskManager = taskManager;
    }

    private void flushSnapshot() throws ForeignException {
        if (this.regions.isEmpty()) {
            return;
        }
        this.monitor.rethrowException();
        if (this.taskManager.hasTasks()) {
            throw new IllegalStateException("Attempting to take snapshot " + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " but we currently have outstanding tasks");
        }
        for (Region region : this.regions) {
            this.taskManager.submitTask(new RegionSnapshotTask(region, this.snapshot, this.snapshotSkipFlush, this.monitor));
            this.monitor.rethrowException();
        }
        LOG.debug((Object)("Flush Snapshot Tasks submitted for " + this.regions.size() + " regions"));
        try {
            this.taskManager.waitForOutstandingTasks();
        }
        catch (InterruptedException e) {
            LOG.error((Object)("got interrupted exception for " + this.getMemberName()));
            throw new ForeignException(this.getMemberName(), e);
        }
    }

    @Override
    public void acquireBarrier() throws ForeignException {
    }

    @Override
    public byte[] insideBarrier() throws ForeignException {
        this.flushSnapshot();
        return new byte[0];
    }

    @Override
    public void cleanup(Exception e) {
        LOG.info((Object)("Aborting all online FLUSH snapshot subprocedure task threads for '" + this.snapshot.getName() + "' due to error"), (Throwable)e);
        try {
            this.taskManager.cancelTasks();
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    public void releaseBarrier() {
    }

    public static class RegionSnapshotTask
    implements Callable<Void> {
        private Region region;
        private boolean skipFlush;
        private ForeignExceptionDispatcher monitor;
        private SnapshotProtos.SnapshotDescription snapshotDesc;

        public RegionSnapshotTask(Region region, SnapshotProtos.SnapshotDescription snapshotDesc, boolean skipFlush, ForeignExceptionDispatcher monitor) {
            this.region = region;
            this.skipFlush = skipFlush;
            this.monitor = monitor;
            this.snapshotDesc = snapshotDesc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LOG.debug((Object)("Starting snapshot operation on " + this.region));
            this.region.startRegionOperation(Region.Operation.SNAPSHOT);
            try {
                if (this.skipFlush) {
                    LOG.debug((Object)"take snapshot without flush memstore first");
                } else {
                    LOG.debug((Object)("Flush Snapshotting region " + this.region.toString() + " started..."));
                    boolean succeeded = false;
                    long readPt = this.region.getReadpoint(IsolationLevel.READ_COMMITTED);
                    for (int i = 0; i < 3; ++i) {
                        Region.FlushResult res = this.region.flush(true);
                        if (res.getResult() == Region.FlushResult.Result.CANNOT_FLUSH) {
                            this.region.waitForFlushes();
                            if (this.region.getMaxFlushedSeqId() < readPt) continue;
                            succeeded = true;
                            break;
                        }
                        succeeded = true;
                        break;
                    }
                    if (!succeeded) {
                        throw new IOException("Unable to complete flush after 3 attempts");
                    }
                }
                ((HRegion)this.region).addRegionToSnapshot(this.snapshotDesc, this.monitor);
                if (this.skipFlush) {
                    LOG.debug((Object)("... SkipFlush Snapshotting region " + this.region.toString() + " completed."));
                } else {
                    LOG.debug((Object)("... Flush Snapshotting region " + this.region.toString() + " completed."));
                }
            }
            finally {
                LOG.debug((Object)("Closing snapshot operation on " + this.region));
                this.region.closeRegionOperation(Region.Operation.SNAPSHOT);
            }
            return null;
        }
    }
}

