/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.throttle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public final class FlushThroughputControllerFactory {
    private static final Log LOG = LogFactory.getLog(FlushThroughputControllerFactory.class);
    public static final String HBASE_FLUSH_THROUGHPUT_CONTROLLER_KEY = "hbase.regionserver.flush.throughput.controller";
    private static final Class<? extends ThroughputController> DEFAULT_FLUSH_THROUGHPUT_CONTROLLER_CLASS = NoLimitThroughputController.class;

    private FlushThroughputControllerFactory() {
    }

    public static ThroughputController create(RegionServerServices server, Configuration conf) {
        Class<? extends ThroughputController> clazz = FlushThroughputControllerFactory.getThroughputControllerClass(conf);
        ThroughputController controller = ReflectionUtils.newInstance(clazz, conf);
        controller.setup(server);
        return controller;
    }

    public static Class<? extends ThroughputController> getThroughputControllerClass(Configuration conf) {
        String className = conf.get(HBASE_FLUSH_THROUGHPUT_CONTROLLER_KEY, DEFAULT_FLUSH_THROUGHPUT_CONTROLLER_CLASS.getName());
        try {
            return Class.forName(className).asSubclass(ThroughputController.class);
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to load configured flush throughput controller '" + className + "', load default throughput controller " + DEFAULT_FLUSH_THROUGHPUT_CONTROLLER_CLASS.getName() + " instead"), (Throwable)e);
            return DEFAULT_FLUSH_THROUGHPUT_CONTROLLER_CLASS;
        }
    }
}

