/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.NamespaceTableCfWALEntryFilter;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ScopeWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.AbstractService;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.Service;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class BaseReplicationEndpoint
extends AbstractService
implements ReplicationEndpoint {
    private static final Log LOG = LogFactory.getLog(BaseReplicationEndpoint.class);
    public static final String REPLICATION_WALENTRYFILTER_CONFIG_KEY = "hbase.replication.source.custom.walentryfilters";
    protected ReplicationEndpoint.Context ctx;

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        this.ctx = context;
        if (this.ctx != null) {
            ReplicationPeer peer = this.ctx.getReplicationPeer();
            if (peer != null) {
                peer.trackPeerConfigChanges(this);
            } else {
                LOG.warn((Object)("Not tracking replication peer config changes for Peer Id " + this.ctx.getPeerId() + " because there's no such peer"));
            }
        }
    }

    @Override
    public void peerConfigUpdated(ReplicationPeerConfig rpc) {
    }

    @Override
    public WALEntryFilter getWALEntryfilter() {
        String filterNameCSV;
        WALEntryFilter tableCfFilter;
        ArrayList<WALEntryFilter> filters = Lists.newArrayList();
        WALEntryFilter scopeFilter = this.getScopeWALEntryFilter();
        if (scopeFilter != null) {
            filters.add(scopeFilter);
        }
        if ((tableCfFilter = this.getNamespaceTableCfWALEntryFilter()) != null) {
            filters.add(tableCfFilter);
        }
        if (this.ctx != null && this.ctx.getPeerConfig() != null && (filterNameCSV = this.ctx.getPeerConfig().getConfiguration().get(REPLICATION_WALENTRYFILTER_CONFIG_KEY)) != null && !filterNameCSV.isEmpty()) {
            String[] filterNames;
            for (String filterName : filterNames = filterNameCSV.split(",")) {
                try {
                    Class<?> clazz = Class.forName(filterName);
                    filters.add((WALEntryFilter)clazz.newInstance());
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to create WALEntryFilter " + filterName), (Throwable)e);
                }
            }
        }
        return filters.isEmpty() ? null : new ChainWALEntryFilter(filters);
    }

    protected WALEntryFilter getScopeWALEntryFilter() {
        return new ScopeWALEntryFilter();
    }

    protected WALEntryFilter getNamespaceTableCfWALEntryFilter() {
        return new NamespaceTableCfWALEntryFilter(this.ctx.getReplicationPeer());
    }

    @Override
    public boolean canReplicateToSameCluster() {
        return false;
    }

    @Override
    public boolean isStarting() {
        return this.state() == Service.State.STARTING;
    }
}

