/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.replication.regionserver.SourceFSConfigurationProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DefaultSourceFSConfigurationProvider
implements SourceFSConfigurationProvider {
    private static final Log LOG = LogFactory.getLog(DefaultSourceFSConfigurationProvider.class);
    private Map<String, Configuration> sourceClustersConfs = new HashMap<String, Configuration>();
    private static final String XML = ".xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConf(Configuration sinkConf, String replicationClusterId) throws IOException {
        if (this.sourceClustersConfs.get(replicationClusterId) == null) {
            Map<String, Configuration> map = this.sourceClustersConfs;
            synchronized (map) {
                if (this.sourceClustersConfs.get(replicationClusterId) == null) {
                    String[] listofConfFiles;
                    LOG.info((Object)("Loading source cluster FS client conf for cluster " + replicationClusterId));
                    Configuration sourceClusterConf = new Configuration(false);
                    String replicationConfDir = sinkConf.get("hbase.replication.conf.dir");
                    if (replicationConfDir == null) {
                        LOG.debug((Object)"hbase.replication.conf.dir is not configured.");
                        URL resource = HBaseConfiguration.class.getClassLoader().getResource("hbase-site.xml");
                        if (resource != null) {
                            String path = resource.getPath();
                            replicationConfDir = path.substring(0, path.lastIndexOf("/"));
                        } else {
                            replicationConfDir = System.getenv("HBASE_CONF_DIR");
                        }
                    }
                    LOG.info((Object)("Loading source cluster " + replicationClusterId + " file system configurations from xml files under directory " + replicationConfDir));
                    File confDir = new File(replicationConfDir, replicationClusterId);
                    for (String confFile : listofConfFiles = FileUtil.list(confDir)) {
                        if (!new File(confDir, confFile).isFile() || !confFile.endsWith(XML)) continue;
                        sourceClusterConf.addResource(new Path(confDir.getPath(), confFile));
                    }
                    this.sourceClustersConfs.put(replicationClusterId, sourceClusterConf);
                }
            }
        }
        return this.sourceClustersConfs.get(replicationClusterId);
    }
}

