/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ReplicationObserver
implements RegionObserver {
    private static final Log LOG = LogFactory.getLog(ReplicationObserver.class);

    @Override
    public void preCommitStoreFile(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] family, List<Pair<Path, Path>> pairs) throws IOException {
        RegionCoprocessorEnvironment env = ctx.getEnvironment();
        Configuration c = env.getConfiguration();
        if (pairs == null || pairs.isEmpty() || !c.getBoolean("hbase.replication.bulkload.enabled", false)) {
            LOG.debug((Object)"Skipping recording bulk load entries in preCommitStoreFile for bulkloaded data replication.");
            return;
        }
        HRegionServer rs = (HRegionServer)env.getRegionServerServices();
        Replication rep = (Replication)rs.getReplicationSourceService();
        rep.addHFileRefsToQueue(env.getRegionInfo().getTable(), family, pairs);
    }
}

