/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.Unpooled;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.hbase.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CryptoAESUnwrapHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final CryptoAES cryptoAES;

    public CryptoAESUnwrapHandler(CryptoAES cryptoAES) {
        this.cryptoAES = cryptoAES;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] bytes = new byte[msg.readableBytes()];
        msg.readBytes(bytes);
        ctx.fireChannelRead(Unpooled.wrappedBuffer(this.cryptoAES.unwrap(bytes, 0, bytes.length)));
    }
}

