/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyException;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hadoop.hbase.shaded.protobuf.generated.EncryptionProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class EncryptionUtil {
    private static final Log LOG = LogFactory.getLog(EncryptionUtil.class);
    private static final SecureRandom RNG = new SecureRandom();

    private EncryptionUtil() {
    }

    public static byte[] wrapKey(Configuration conf, byte[] key, String algorithm) throws IOException {
        return EncryptionUtil.wrapKey(conf, conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), new SecretKeySpec(key, algorithm));
    }

    public static byte[] wrapKey(Configuration conf, String subject, Key key) throws IOException {
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, algorithm);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + algorithm + "' not available");
        }
        EncryptionProtos.WrappedKey.Builder builder = EncryptionProtos.WrappedKey.newBuilder();
        builder.setAlgorithm(key.getAlgorithm());
        byte[] iv = null;
        if (cipher.getIvLength() > 0) {
            iv = new byte[cipher.getIvLength()];
            RNG.nextBytes(iv);
            builder.setIv(UnsafeByteOperations.unsafeWrap(iv));
        }
        byte[] keyBytes = key.getEncoded();
        builder.setLength(keyBytes.length);
        builder.setHash(UnsafeByteOperations.unsafeWrap(Encryption.hash128(new byte[][]{keyBytes})));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encryption.encryptWithSubjectKey(out, new ByteArrayInputStream(keyBytes), subject, conf, cipher, iv);
        builder.setData(UnsafeByteOperations.unsafeWrap(out.toByteArray()));
        out.reset();
        builder.build().writeDelimitedTo(out);
        return out.toByteArray();
    }

    public static Key unwrapKey(Configuration conf, String subject, byte[] value) throws IOException, KeyException {
        EncryptionProtos.WrappedKey wrappedKey = EncryptionProtos.WrappedKey.PARSER.parseDelimitedFrom(new ByteArrayInputStream(value));
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, algorithm);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + algorithm + "' not available");
        }
        return EncryptionUtil.getUnwrapKey(conf, subject, wrappedKey, cipher);
    }

    private static Key getUnwrapKey(Configuration conf, String subject, EncryptionProtos.WrappedKey wrappedKey, Cipher cipher) throws IOException, KeyException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] iv = wrappedKey.hasIv() ? wrappedKey.getIv().toByteArray() : null;
        Encryption.decryptWithSubjectKey(out, wrappedKey.getData().newInput(), wrappedKey.getLength(), subject, conf, cipher, iv);
        byte[] keyBytes = out.toByteArray();
        if (wrappedKey.hasHash() && !Bytes.equals(wrappedKey.getHash().toByteArray(), Encryption.hash128(new byte[][]{keyBytes}))) {
            throw new KeyException("Key was not successfully unwrapped");
        }
        return new SecretKeySpec(keyBytes, wrappedKey.getAlgorithm());
    }

    public static Key unwrapWALKey(Configuration conf, String subject, byte[] value) throws IOException, KeyException {
        EncryptionProtos.WrappedKey wrappedKey = EncryptionProtos.WrappedKey.PARSER.parseDelimitedFrom(new ByteArrayInputStream(value));
        String algorithm = conf.get("hbase.crypto.wal.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, algorithm);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + algorithm + "' not available");
        }
        return EncryptionUtil.getUnwrapKey(conf, subject, wrappedKey, cipher);
    }

    public static Encryption.Context createEncryptionContext(Configuration conf, ColumnFamilyDescriptor family) throws IOException {
        Encryption.Context cryptoContext = Encryption.Context.NONE;
        String cipherName = family.getEncryptionType();
        if (cipherName != null) {
            Cipher cipher;
            Key key;
            byte[] keyBytes = family.getEncryptionKey();
            if (keyBytes != null) {
                key = EncryptionUtil.unwrapKey(conf, keyBytes);
                cipher = Encryption.getCipher(conf, key.getAlgorithm());
                if (cipher == null) {
                    throw new RuntimeException("Cipher '" + key.getAlgorithm() + "' is not available");
                }
                if (!cipher.getName().equalsIgnoreCase(cipherName)) {
                    throw new RuntimeException("Encryption for family '" + family.getNameAsString() + "' configured with type '" + cipherName + "' but key specifies algorithm '" + cipher.getName() + "'");
                }
            } else {
                cipher = Encryption.getCipher(conf, cipherName);
                if (cipher == null) {
                    throw new RuntimeException("Cipher '" + cipherName + "' is not available");
                }
                key = cipher.getRandomKey();
            }
            cryptoContext = Encryption.newContext(conf);
            cryptoContext.setCipher(cipher);
            cryptoContext.setKey(key);
        }
        return cryptoContext;
    }

    public static Key unwrapKey(Configuration conf, byte[] keyBytes) throws IOException {
        Key key;
        String masterKeyName = conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName());
        try {
            key = EncryptionUtil.unwrapKey(conf, masterKeyName, keyBytes);
        }
        catch (KeyException e) {
            String alternateKeyName;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to unwrap key with current master key '" + masterKeyName + "'"));
            }
            if ((alternateKeyName = conf.get("hbase.crypto.master.alternate.key.name")) != null) {
                try {
                    key = EncryptionUtil.unwrapKey(conf, alternateKeyName, keyBytes);
                }
                catch (KeyException ex) {
                    throw new IOException(ex);
                }
            }
            throw new IOException(e);
        }
        return key;
    }

    public static CryptoAES createCryptoAES(RPCProtos.CryptoCipherMeta cryptoCipherMeta, Configuration conf) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("commons.crypto.cipher.classes", conf.get("hbase.rpc.crypto.encryption.aes.cipher.class", "org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.cipher.JceCipher"));
        return new CryptoAES(cryptoCipherMeta.getTransformation(), properties, cryptoCipherMeta.getInKey().toByteArray(), cryptoCipherMeta.getOutKey().toByteArray(), cryptoCipherMeta.getInIv().toByteArray(), cryptoCipherMeta.getOutIv().toByteArray());
    }
}

