/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ShadedAccessControlUtil {
    public static AccessControlProtos.Permission.Action toPermissionAction(Permission.Action action) {
        switch (action) {
            case READ: {
                return AccessControlProtos.Permission.Action.READ;
            }
            case WRITE: {
                return AccessControlProtos.Permission.Action.WRITE;
            }
            case EXEC: {
                return AccessControlProtos.Permission.Action.EXEC;
            }
            case CREATE: {
                return AccessControlProtos.Permission.Action.CREATE;
            }
            case ADMIN: {
                return AccessControlProtos.Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static Permission.Action toPermissionAction(AccessControlProtos.Permission.Action action) {
        switch (action) {
            case READ: {
                return Permission.Action.READ;
            }
            case WRITE: {
                return Permission.Action.WRITE;
            }
            case EXEC: {
                return Permission.Action.EXEC;
            }
            case CREATE: {
                return Permission.Action.CREATE;
            }
            case ADMIN: {
                return Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static List<Permission.Action> toPermissionActions(List<AccessControlProtos.Permission.Action> protoActions) {
        ArrayList<Permission.Action> actions = new ArrayList<Permission.Action>(protoActions.size());
        for (AccessControlProtos.Permission.Action a : protoActions) {
            actions.add(ShadedAccessControlUtil.toPermissionAction(a));
        }
        return actions;
    }

    public static TableName toTableName(HBaseProtos.TableName tableNamePB) {
        return TableName.valueOf(tableNamePB.getNamespace().asReadOnlyByteBuffer(), tableNamePB.getQualifier().asReadOnlyByteBuffer());
    }

    public static HBaseProtos.TableName toProtoTableName(TableName tableName) {
        return HBaseProtos.TableName.newBuilder().setNamespace(ByteString.copyFrom(tableName.getNamespace())).setQualifier(ByteString.copyFrom(tableName.getQualifier())).build();
    }

    public static TablePermission toTablePermission(AccessControlProtos.Permission proto) {
        if (proto.getType() == AccessControlProtos.Permission.Type.Global) {
            AccessControlProtos.GlobalPermission perm = proto.getGlobalPermission();
            List<Permission.Action> actions = ShadedAccessControlUtil.toPermissionActions(perm.getActionList());
            return new TablePermission(null, null, null, actions.toArray(new Permission.Action[actions.size()]));
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Namespace) {
            AccessControlProtos.NamespacePermission perm = proto.getNamespacePermission();
            List<Permission.Action> actions = ShadedAccessControlUtil.toPermissionActions(perm.getActionList());
            if (!proto.hasNamespacePermission()) {
                throw new IllegalStateException("Namespace must not be empty in NamespacePermission");
            }
            String namespace = perm.getNamespaceName().toStringUtf8();
            return new TablePermission(namespace, actions.toArray(new Permission.Action[actions.size()]));
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Table) {
            AccessControlProtos.TablePermission perm = proto.getTablePermission();
            List<Permission.Action> actions = ShadedAccessControlUtil.toPermissionActions(perm.getActionList());
            byte[] qualifier = null;
            byte[] family = null;
            TableName table = null;
            if (!perm.hasTableName()) {
                throw new IllegalStateException("TableName cannot be empty");
            }
            table = ShadedAccessControlUtil.toTableName(perm.getTableName());
            if (perm.hasFamily()) {
                family = perm.getFamily().toByteArray();
            }
            if (perm.hasQualifier()) {
                qualifier = perm.getQualifier().toByteArray();
            }
            return new TablePermission(table, family, qualifier, actions.toArray(new Permission.Action[actions.size()]));
        }
        throw new IllegalStateException("Unrecognize Perm Type: " + proto.getType());
    }

    public static AccessControlProtos.Permission toPermission(Permission perm) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        if (perm instanceof TablePermission) {
            TablePermission tablePerm = (TablePermission)perm;
            if (tablePerm.hasNamespace()) {
                ret.setType(AccessControlProtos.Permission.Type.Namespace);
                AccessControlProtos.NamespacePermission.Builder builder = AccessControlProtos.NamespacePermission.newBuilder();
                builder.setNamespaceName(ByteString.copyFromUtf8(tablePerm.getNamespace()));
                Permission.Action[] actions = perm.getActions();
                if (actions != null) {
                    for (Permission.Action a : actions) {
                        builder.addAction(ShadedAccessControlUtil.toPermissionAction(a));
                    }
                }
                ret.setNamespacePermission(builder);
                return ret.build();
            }
            if (tablePerm.hasTable()) {
                Permission.Action[] actions;
                ret.setType(AccessControlProtos.Permission.Type.Table);
                AccessControlProtos.TablePermission.Builder builder = AccessControlProtos.TablePermission.newBuilder();
                builder.setTableName(ShadedAccessControlUtil.toProtoTableName(tablePerm.getTableName()));
                if (tablePerm.hasFamily()) {
                    builder.setFamily(ByteString.copyFrom(tablePerm.getFamily()));
                }
                if (tablePerm.hasQualifier()) {
                    builder.setQualifier(ByteString.copyFrom(tablePerm.getQualifier()));
                }
                if ((actions = perm.getActions()) != null) {
                    for (Permission.Action a : actions) {
                        builder.addAction(ShadedAccessControlUtil.toPermissionAction(a));
                    }
                }
                ret.setTablePermission(builder);
                return ret.build();
            }
        }
        ret.setType(AccessControlProtos.Permission.Type.Global);
        AccessControlProtos.GlobalPermission.Builder builder = AccessControlProtos.GlobalPermission.newBuilder();
        Permission.Action[] actions = perm.getActions();
        if (actions != null) {
            for (Permission.Action a : actions) {
                builder.addAction(ShadedAccessControlUtil.toPermissionAction(a));
            }
        }
        ret.setGlobalPermission(builder);
        return ret.build();
    }

    public static ListMultimap<String, TablePermission> toUserTablePermissions(AccessControlProtos.UsersAndPermissions proto) {
        ArrayListMultimap<String, TablePermission> perms = ArrayListMultimap.create();
        for (int i = 0; i < proto.getUserPermissionsCount(); ++i) {
            AccessControlProtos.UsersAndPermissions.UserPermissions userPerm = proto.getUserPermissions(i);
            for (int j = 0; j < userPerm.getPermissionsCount(); ++j) {
                TablePermission tablePerm = ShadedAccessControlUtil.toTablePermission(userPerm.getPermissions(j));
                perms.put(userPerm.getUser().toStringUtf8(), tablePerm);
            }
        }
        return perms;
    }

    public static AccessControlProtos.UsersAndPermissions toUserTablePermissions(ListMultimap<String, TablePermission> perm) {
        AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
        for (Map.Entry<String, Collection<TablePermission>> entry : perm.asMap().entrySet()) {
            AccessControlProtos.UsersAndPermissions.UserPermissions.Builder userPermBuilder = AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder();
            userPermBuilder.setUser(ByteString.copyFromUtf8(entry.getKey()));
            for (TablePermission tablePerm : entry.getValue()) {
                userPermBuilder.addPermissions(ShadedAccessControlUtil.toPermission(tablePerm));
            }
            builder.addUserPermissions(userPermBuilder.build());
        }
        return builder.build();
    }
}

